/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

public enum ContentType {
    ARCHIVE("structure", "a"),
    ARCHIVE_BZ2("structure", "a"),
    ARCHIVE_GZ("structure", "a"),
    ARCHIVE_TAR("structure", "a"),
    ARCHIVE_ZIP("structure", "a"),
    BINARY("binary", "b"),
    FOLDER("structure", "d"),
    IMAGE("image/.*", "i"),
    IMAGE_BMP("image/bmp", "i"),
    IMAGE_GIF("image/gif", "i"),
    IMAGE_ICO("image/ico", "i"),
    IMAGE_J2K("image/jpeq200", "i"),
    IMAGE_JPEG("image/jpeq", "i"),
    IMAGE_PGM("image/pgm", "i"),
    IMAGE_PNG("image/png", "i"),
    IMAGE_PSD("image/psd", "i"),
    IMAGE_TIFF("image/tiff", "i"),
    IWORK("iwork", "iw"),
    OFFICE("office", "o"),
    OFFICE2007("office", "o"),
    PDF("pdf", "p"),
    PREVIEW("", "pr"),
    TEXT("text/plain", "t"),
    TEXT_HTML("text/html", "h"),
    TEXT_RTF("text/rtf", "r"),
    TEXT_XML("text/xml", "x"),
    UNKNOWN("unknown", "u");

    private final String jsKey;
    private final String text;

    private ContentType(String string2, String string3) {
        this.text = string2;
        this.jsKey = string3;
    }

    public String docTypeKey() {
        return this.jsKey;
    }

    public boolean isArchive() {
        return this.jsKey.equals("a");
    }

    public boolean isBinary() {
        return this.jsKey.equals("b") || this.jsKey.equals("i");
    }

    public boolean isCompoundDoc() {
        return this.jsKey.equals("o") || this.jsKey.equals("p") || this.jsKey.equals("r") || this.jsKey.equals("iw");
    }

    public boolean isImage() {
        return this.jsKey.equals("i");
    }

    public boolean isStructure() {
        return this.jsKey.equals("d") || this.jsKey.equals("a");
    }

    public boolean isText(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.jsKey.equals("t") || this.jsKey.equals("h") || this.jsKey.equals("x");
        if (bl || bl2) {
            return bl2;
        }
        return this.jsKey.equals("pr") || this.isCompoundDoc();
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isVfs() {
        return this.isArchive() || this.isCompoundDoc();
    }

    public String toString() {
        return this.text;
    }
}

