/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.io.ITempFileBoss;
import com.deltopia.io.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachedInputStreamSynchronizer
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CachedInputStreamSynchronizer.class);
    private final byte[] buffer;
    private final File cacheFile;
    private final RandomAccessFile cacheRAF;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean eof = false;
    private IOException exception = null;
    private final List<Stream> listStream;
    private final Lock lock = new ReentrantLock();
    private final InputStream orgStream;
    private long pointerOrg = 0L;
    private final ITempFileBoss tempFileBoss;

    public CachedInputStreamSynchronizer(InputStream inputStream, ITempFileBoss iTempFileBoss, int n) throws IOException {
        assert (inputStream != null);
        assert (iTempFileBoss != null);
        this.orgStream = inputStream;
        this.tempFileBoss = iTempFileBoss;
        this.cacheFile = iTempFileBoss.createTempFile();
        this.cacheRAF = new RandomAccessFile(this.cacheFile, "rw");
        this.listStream = new LinkedList<Stream>();
        if (n <= 0) {
            n = 65536;
        }
        this.buffer = new byte[n];
        if (LOG.isInfoEnabled()) {
            this.info("Created inStream=" + inputStream + ", cacheFile=" + this.cacheFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long availableTo(long l) {
        CachedInputStreamSynchronizer cachedInputStreamSynchronizer = this;
        synchronized (cachedInputStreamSynchronizer) {
            long l2 = this.pointerOrg - l;
            if (LOG.isDebugEnabled()) {
                this.debug("availableTo " + l + " pointer=" + this.pointerOrg);
            }
            return l2;
        }
    }

    private void checkState() throws IOException {
        if (this.exception != null) {
            if (LOG.isInfoEnabled()) {
                this.info("Rethrow exception");
            }
            throw this.exception;
        }
        if (this.closed.get()) {
            throw new IOException("Closed " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList<Stream> arrayList;
        if (LOG.isInfoEnabled()) {
            this.info("-> Close");
        }
        if (this.closed.getAndSet(true)) {
            if (LOG.isInfoEnabled()) {
                this.warn("Already closed", null);
            }
            return;
        }
        List<Stream> object2 = this.listStream;
        synchronized (object2) {
            arrayList = new ArrayList<Stream>(this.listStream);
        }
        StreamUtil.closeSilently(this.orgStream);
        StreamUtil.closeSilently(this.cacheRAF);
        for (Stream stream : arrayList) {
            StreamUtil.closeSilently(stream);
        }
        this.tempFileBoss.deleteTempFile(this.cacheFile);
        if (LOG.isInfoEnabled()) {
            this.info("<- Close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream createStream() throws IOException {
        this.checkState();
        Stream stream = new Stream();
        List<Stream> list = this.listStream;
        synchronized (list) {
            this.listStream.add(stream);
        }
        return stream;
    }

    private void debug(String string) {
        LOG.debug("ACC " + this + " " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveStreamsCount() {
        List<Stream> list = this.listStream;
        synchronized (list) {
            return this.listStream.size();
        }
    }

    private void info(String string) {
        LOG.info("ACC " + this + " " + string);
    }

    /*
     * Exception decompiling
     */
    private long readRange(long var1_1, int var3_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStream(Stream stream) {
        List<Stream> list = this.listStream;
        synchronized (list) {
            if (!this.listStream.remove(stream)) {
                this.warn("Cannot find stream " + stream, null);
            }
        }
    }

    public String toString() {
        return "@" + System.identityHashCode(this) + " " + (this.closed.get() ? "Closed" : "Valid");
    }

    private void warn(String string, Throwable throwable) {
        LOG.warn("ACC " + this + " " + string, throwable);
    }

    private final class Stream
    extends InputStream {
        private long markPos = -1L;
        private final RandomAccessFile rafCache;

        private Stream() throws FileNotFoundException {
            this.rafCache = new RandomAccessFile(CachedInputStreamSynchronizer.this.cacheFile, "r");
            if (LOG.isInfoEnabled()) {
                this.info("Created");
            }
        }

        @Override
        public int available() throws IOException {
            CachedInputStreamSynchronizer.this.checkState();
            long l = this.rafCache.getFilePointer();
            long l2 = CachedInputStreamSynchronizer.this.availableTo(l);
            return (int)Math.min(Integer.MAX_VALUE, Math.min(0L, l2));
        }

        @Override
        public void close() throws IOException {
            if (LOG.isInfoEnabled()) {
                this.info("-> Close");
            }
            CachedInputStreamSynchronizer.this.removeStream(this);
            this.rafCache.close();
        }

        private void debug(String string) {
            LOG.debug("STR " + this + " " + string);
        }

        private long getReadPointer() throws IOException {
            return this.rafCache.getFilePointer();
        }

        private void info(String string) {
            LOG.info("STR " + this + " " + string);
        }

        @Override
        public void mark(int n) {
            try {
                this.markPos = this.getReadPointer();
            }
            catch (IOException iOException) {
                CachedInputStreamSynchronizer.this.warn("Cannot mark", iOException);
                this.markPos = -1L;
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n < 0) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            long l = this.waitForData(n2);
            if (l < 0L) {
                return -1;
            }
            n2 = (int)Math.min((long)n2, l);
            int n3 = this.rafCache.read(byArray, n, n2);
            if (LOG.isDebugEnabled()) {
                this.debug("Read " + n3 + ", requested=" + n2);
            }
            return n3;
        }

        @Override
        public void reset() throws IOException {
            if (this.markPos != -1L) {
                this.rafCache.seek(this.markPos);
            }
        }

        public String toString() {
            return "@" + System.identityHashCode(this) + " [" + CachedInputStreamSynchronizer.this + "]";
        }

        private long waitForData(int n) throws IOException {
            long l = this.getReadPointer();
            if (LOG.isDebugEnabled()) {
                this.debug("-> waitForData cur=" + l);
            }
            long l2 = CachedInputStreamSynchronizer.this.readRange(l, n);
            if (LOG.isDebugEnabled()) {
                this.debug("<- waitForData available=" + l2);
            }
            return l2;
        }
    }
}

