/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.io.IByteSequence;
import java.io.IOException;
import java.io.InputStream;

public class ByteSequenceInputStream
extends InputStream {
    private final IByteSequence byteSequence;
    protected int mark = 0;
    protected int pos;

    public ByteSequenceInputStream(IByteSequence iByteSequence) {
        this.byteSequence = iByteSequence;
    }

    @Override
    public int available() throws IOException {
        int n = this.byteSequence.length();
        return this.pos >= n ? 0 : n - this.pos;
    }

    public IByteSequence getSequence() {
        return this.byteSequence;
    }

    @Override
    public void mark(int n) {
        this.mark = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.byteSequence.length()) {
            return -1;
        }
        byte by = this.byteSequence.get(this.pos);
        ++this.pos;
        return 0xFF & by;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.byteSequence.length()) {
            return -1;
        }
        int n3 = this.byteSequence.get(this.pos, n2, byArray, n);
        this.pos += n3;
        return n3;
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
    }
}

