/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.io.IByteSequence;
import java.io.UnsupportedEncodingException;

public class ByteBuffer
implements IByteSequence {
    public static final int DEFAULT_BLOCK_CAPACITY = 1024;
    private final int blockCapacity;
    private byte[][] blocks = new byte[0][];
    private int length = 0;

    public ByteBuffer() {
        this(1024);
    }

    public ByteBuffer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("blockCapacity");
        }
        this.blockCapacity = n;
    }

    public ByteBuffer(int n, int n2) {
        this(n);
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity");
        }
        this.ensureCapacity(n2);
    }

    public synchronized void append(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = n + n2;
        if (n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        this.ensureCapacity(this.length + n2);
        int n4 = this.length / this.blockCapacity;
        int n5 = this.length % this.blockCapacity;
        while (n < n3) {
            int n6 = Math.min(n3 - n, this.blockCapacity - n5);
            System.arraycopy(byArray, n, this.blocks[n4], n5, n6);
            n += n6;
            this.length += n6;
            ++n4;
            n5 = 0;
        }
    }

    private void ensureCapacity(int n) {
        if (n <= this.length) {
            return;
        }
        int n2 = (n - 1) / this.blockCapacity;
        if (n2 < this.blocks.length) {
            return;
        }
        byte[][] byArrayArray = new byte[n2 + 1][];
        System.arraycopy(this.blocks, 0, byArrayArray, 0, this.blocks.length);
        int n3 = this.blocks.length;
        while (n3 <= n2) {
            byArrayArray[n3] = new byte[this.blockCapacity];
            ++n3;
        }
        this.blocks = byArrayArray;
    }

    @Override
    public synchronized int get(byte[] byArray) {
        return this.get(0, this.length, byArray, 0);
    }

    @Override
    public synchronized byte get(int n) {
        return this.blocks[n / this.blockCapacity][n % this.blockCapacity];
    }

    @Override
    public synchronized int get(int n, int n2, byte[] byArray, int n3) {
        if (n2 == 0) {
            return 0;
        }
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        n2 = Math.min(n2, this.length - n);
        int n4 = n + n2;
        int n5 = n / this.blockCapacity;
        int n6 = n % this.blockCapacity;
        while (n < n4) {
            int n7 = Math.min(n4 - n, this.blockCapacity - n6);
            System.arraycopy(this.blocks[n5], n6, byArray, n3, n7);
            n += n7;
            n3 += n7;
            ++n5;
            n6 = 0;
        }
        return n2;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public synchronized byte[] toByteArray(int n) {
        if (n < 0 || n > this.length) {
            throw new IllegalArgumentException("offset out of range.");
        }
        int n2 = this.length - n;
        byte[] byArray = new byte[n2];
        this.get(n, n2, byArray, 0);
        return byArray;
    }

    public String toString() {
        return new String(this.toByteArray(0));
    }

    @Override
    public String toString(int n) {
        return new String(this.toByteArray(n));
    }

    @Override
    public String toString(String string, int n) throws UnsupportedEncodingException {
        return new String(this.toByteArray(n), string);
    }
}

