/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.io;

import com.deltopia.util.Checker;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class BomHeader
extends Enum<BomHeader> {
    public static final /* enum */ BomHeader UTF16BE = new BomHeader("UTF-16BE", new byte[]{-2, -1});
    public static final /* enum */ BomHeader UTF16LE = new BomHeader("UTF-16LE", new byte[]{-1, -2});
    public static final /* enum */ BomHeader UTF32BE;
    public static final /* enum */ BomHeader UTF32LE;
    public static final /* enum */ BomHeader UTF8;
    private static final String BOM_SUFFIX = "_BOM";
    private static final Map<String, BomHeader> MAP_CHARSET_2_BOM;
    private static final Map<String, BomHeader> MAP_UI_CHARSET_2_BOM;
    private final byte[] bytes;
    private final String charset;
    private final String logStr;
    private final String uiCharset;
    private static final /* synthetic */ BomHeader[] ENUM$VALUES;

    static {
        byte[] byArray = new byte[4];
        byArray[2] = -2;
        byArray[3] = -1;
        UTF32BE = new BomHeader("UTF-32BE", byArray);
        byte[] byArray2 = new byte[4];
        byArray2[0] = -1;
        byArray2[1] = -2;
        UTF32LE = new BomHeader("UTF-32LE", byArray2);
        UTF8 = new BomHeader("UTF-8", new byte[]{-17, -69, -65});
        ENUM$VALUES = new BomHeader[]{UTF16BE, UTF16LE, UTF32BE, UTF32LE, UTF8};
        BomHeader[] bomHeaderArray = BomHeader.values();
        LinkedHashMap<String, BomHeader> linkedHashMap = new LinkedHashMap<String, BomHeader>(bomHeaderArray.length);
        LinkedHashMap<String, BomHeader> linkedHashMap2 = new LinkedHashMap<String, BomHeader>(bomHeaderArray.length);
        BomHeader[] bomHeaderArray2 = bomHeaderArray;
        int n = bomHeaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            BomHeader bomHeader = bomHeaderArray2[n2];
            linkedHashMap.put(bomHeader.charset, bomHeader);
            linkedHashMap2.put(bomHeader.uiCharset, bomHeader);
            ++n2;
        }
        MAP_CHARSET_2_BOM = Collections.unmodifiableMap(linkedHashMap);
        MAP_UI_CHARSET_2_BOM = Collections.unmodifiableMap(linkedHashMap2);
    }

    public static BomHeader fromCharsetOpt(String string) {
        return MAP_CHARSET_2_BOM.get(string);
    }

    public static BomHeader fromUiCharsetOpt(String string) {
        return MAP_UI_CHARSET_2_BOM.get(string);
    }

    public static final Set<String> getUiCharsets() {
        return MAP_UI_CHARSET_2_BOM.keySet();
    }

    private BomHeader(String string2, byte[] byArray) {
        this.charset = Checker.notEmpty(string2, "charset");
        this.bytes = Checker.notNull(byArray, "bytes");
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray2[n3];
            stringBuilder.append(String.format("%x", by));
            if (by != 0) {
                stringBuilder.append('(').append(by).append(')');
            }
            stringBuilder.append(',');
            ++n3;
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        this.uiCharset = String.valueOf(string2) + BOM_SUFFIX;
        this.logStr = String.valueOf(string2) + ": " + stringBuilder;
    }

    public String charset() {
        return this.charset;
    }

    byte[] getBytes() {
        return this.bytes;
    }

    public int length() {
        return this.bytes.length;
    }

    public boolean matches(byte[] byArray) {
        Checker.notNull(byArray, "bytes");
        int n = this.bytes.length;
        if (byArray.length < n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.bytes[n2] != byArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        return this.charset;
    }

    public String toStringEx() {
        return this.logStr;
    }

    public String uiCharset() {
        return this.uiCharset;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Checker.notNull(outputStream, "out stream");
        outputStream.write(this.bytes);
    }

    public static BomHeader[] values() {
        BomHeader[] bomHeaderArray = ENUM$VALUES;
        int n = bomHeaderArray.length;
        BomHeader[] bomHeaderArray2 = new BomHeader[n];
        System.arraycopy(ENUM$VALUES, 0, bomHeaderArray2, 0, n);
        return bomHeaderArray2;
    }

    public static BomHeader valueOf(String string) {
        return Enum.valueOf(BomHeader.class, string);
    }
}

