/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.internal.io;

import com.deltopia.LibLoadResult;
import com.deltopia.LibraryLoader;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.internal.io.AbstractFileSystem;
import com.deltopia.io.DefaultFileSystem;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileInfoEx;
import com.deltopia.io.IFile;
import com.deltopia.io.IO;
import com.deltopia.io.IStorageListener;
import com.deltopia.io.NullSyncProgressMonitor;
import com.deltopia.io.Principal;
import com.deltopia.io.UrlEx;
import com.deltopia.util.Checker;
import com.deltopia.util.OS;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFileSystem
extends AbstractFileSystem {
    private static LibLoadResult loadResult = LibLoadResult.UNDEFINED;
    private static final Logger LOG = LoggerFactory.getLogger(BaseFileSystem.class);
    protected static final int OPT_DEFAULT = 0;
    protected static final int OPT_NO_REPLACE_EXISTING = 1;

    private static final void checkPointer(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("pointer");
        }
    }

    private static final EnumSet<AbstractFileSystem.Feature> checkSupportedFeatures(EnumSet<AbstractFileSystem.Feature> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("supportedFeatures");
        }
        Properties properties = System.getProperties();
        Object object = enumSet.clone();
        for (AbstractFileSystem.Feature feature : enumSet) {
            String string = "com.deltopia.io.native." + feature.getPropertyKey();
            String string2 = properties.getProperty(string);
            if (string2 == null || string2.length() <= 0) continue;
            if (string2.equals("true")) {
                if (!((AbstractCollection)object).add(feature)) continue;
                LOG.warn("Enable " + (Object)((Object)feature));
                continue;
            }
            if (!string2.equals("false") || !((AbstractCollection)object).remove((Object)feature)) continue;
            LOG.warn("Disable " + (Object)((Object)feature));
        }
        return object;
    }

    private static final String pathToString(File file) {
        String string = file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string = string.concat("\\*");
        } else if (string.isEmpty() || string.charAt(string.length() - 1) != '/') {
            string = string.concat("/");
        }
        return string;
    }

    protected BaseFileSystem(EnumSet<AbstractFileSystem.Feature> enumSet, int n) throws UnsatisfiedLinkError {
        super(BaseFileSystem.checkSupportedFeatures(enumSet), n);
        if (loadResult == LibLoadResult.UNDEFINED) {
            loadResult = LibraryLoader.loadLibrary("deltopia");
            if (loadResult == LibLoadResult.SUCCESS) {
                loadResult = LibLoadResult.FAILURE;
                this.nInitStatic();
                loadResult = LibLoadResult.SUCCESS;
            }
        } else {
            LOG.warn("loadLibrary already called with result: " + (Object)((Object)loadResult));
        }
    }

    public boolean allowSecureAccess(long l, boolean bl) {
        BaseFileSystem.checkPointer(l);
        this.urlCheckSupported();
        boolean bl2 = this.nAllowSecureAccess(l, bl);
        if (bl2) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.valueOf(bl ? "Allow" : "Deny") + "SecureAccess URL succeeded: " + l);
            }
        } else {
            LOG.warn(String.valueOf(bl ? "Allow" : "Deny") + "SecureAccess URL failed: " + l);
        }
        return bl2;
    }

    @Override
    public boolean compareByteByByte(File file, File file2, IProgressMonitor iProgressMonitor) throws IOException {
        if (!this.isSupported(AbstractFileSystem.Feature.COMPARE_BB)) {
            throw new UnsupportedOperationException("compareByteByByte");
        }
        if (file == null) {
            throw new NullPointerException("path1");
        }
        if (file2 == null) {
            throw new NullPointerException("path2");
        }
        if (file.isDirectory() || file2.isDirectory()) {
            return false;
        }
        if (this.isSupportedNative(AbstractFileSystem.Feature.COMPARE_BB)) {
            try {
                return this.nCompareByteByByte(file.getPath(), file2.getPath(), iProgressMonitor);
            }
            catch (IOException iOException) {
                throw new IOException(String.valueOf(iOException.getMessage()) + ": '" + file + " / '" + file2 + '\'');
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.COMPARE_BB);
            }
        }
        return DefaultFileSystem.getInstance().compareByteByByte(file, file2, iProgressMonitor);
    }

    @Override
    public long copyFile(IFile iFile, IFile iFile2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        if (!this.isSupported(AbstractFileSystem.Feature.COPY)) {
            throw new UnsupportedOperationException("copyFile");
        }
        if (iFile == null) {
            throw new NullPointerException("srcFile");
        }
        if (iFile2 == null) {
            throw new NullPointerException("dstFile");
        }
        long l = 0L;
        if (iFile.isLocal() && iFile2.isLocal() && this.isSupportedNative(AbstractFileSystem.Feature.COPY)) {
            String string = iFile.getPath();
            String string2 = iFile2.getPath();
            l = this.copyFile(string, string2, iSyncProgressMonitor);
            this.postProcessLocalFileInfo(false, iFile, string, string2);
            return l;
        }
        return DefaultFileSystem.getInstance().copyFile(iFile, iFile2, iSyncProgressMonitor);
    }

    @Override
    public long copyFile(String string, String string2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        long l = 0L;
        try {
            if (iSyncProgressMonitor == null) {
                iSyncProgressMonitor = new NullSyncProgressMonitor();
            }
            l = this.nCopyFileCallback(string, string2, 0, iSyncProgressMonitor);
            iSyncProgressMonitor.itemTransferred();
            if (l < 0L) {
                String string3 = "Couldn''t copy '{0}' to '{1}'. Native copied: {2} bytes.";
                throw new IOException(NLS.bind((String)string3, (Object[])new String[]{string, string2, Long.toString(l)}));
            }
        }
        catch (IOException iOException) {
            String string4 = "Couldn''t copy ''{0}'' to ''{1}''. Reason: {2}";
            throw new IOException(NLS.bind((String)string4, (Object[])new String[]{string, string2, iOException.getMessage()}));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.COPY);
        }
        return l;
    }

    @Override
    protected void createSymbolicLinkImpl(File file, String string, boolean bl) throws IOException, UnsupportedOperationException {
        if (this.isSupportedNative(AbstractFileSystem.Feature.CREATE_SYM_LINK)) {
            try {
                this.nCreateSymbolicLink(file.getPath(), string, bl);
                return;
            }
            catch (IOException iOException) {
                String string2 = "Couldn''t create symlink ''{0}'': {1}";
                throw new IOException(NLS.bind((String)string2, (Object)file, (Object)iOException.getMessage()));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.CREATE_SYM_LINK);
            }
        }
        DefaultFileSystem.getInstance().createSymbolicLinkImpl(file, string, bl);
    }

    @Override
    public final boolean delete(File file, boolean bl) {
        boolean bl2 = false;
        if (bl && this.isSupportedNative(AbstractFileSystem.Feature.MOVE_TO_TRASH)) {
            try {
                bl2 = this.deleteToTrash(file);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.MOVE_TO_TRASH);
            }
        }
        if (!bl2) {
            bl2 = DefaultFileSystem.deletePath(file, null);
        }
        return bl2;
    }

    protected boolean deleteToTrash(File file) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected final FileInfo getFileInfoImpl(File file) throws IOException {
        if (this.isSupportedNative(AbstractFileSystem.Feature.GET_FILE_INFO)) {
            try {
                FileInfo fileInfo = this.nGetFileInfo(file.getPath(), file.getName(), 127);
                if (fileInfo == null) {
                    throw new IOException(NLS.bind((String)"Path does not exist: ''{0}''", (Object)file));
                }
                return fileInfo;
            }
            catch (IOException iOException) {
                throw new IOException(NLS.bind((String)"''{0}'': {1}", (Object)file, (Object)iOException.getMessage()));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.GET_FILE_INFO);
            }
        }
        return DefaultFileSystem.getInstance().getFileInfo(file);
    }

    @Override
    protected final Principal getGroupImpl(Object object) throws IOException {
        if (!this.isSupportedNative(AbstractFileSystem.Feature.GET_USER)) {
            throw new UnsupportedOperationException("Get group not supported");
        }
        int n = 0;
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (!(object instanceof String)) {
            throw new IllegalArgumentException("Invalid GID: " + object + " [" + object.getClass() + ']');
        }
        try {
            Principal principal = this.nGetGroup(object, n);
            return principal;
        }
        catch (IOException iOException) {
            throw new IOException(NLS.bind((String)"Couldn''t obtain Group onwer name for ID={0}. Reason: {1}", (Object)object, (Object)iOException.getMessage()));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.GET_GROUP);
            throw new IOException("No native API for getting Group name from ID", unsatisfiedLinkError);
        }
    }

    @Override
    protected final Principal getOwnerImpl(Object object) throws IOException {
        if (!this.isSupportedNative(AbstractFileSystem.Feature.GET_USER)) {
            throw new UnsupportedOperationException("Get user not supported");
        }
        int n = 0;
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (!(object instanceof String)) {
            throw new IllegalArgumentException("Invalid UID: " + object + " [" + object.getClass() + ']');
        }
        try {
            Principal principal = this.nGetUser(object, n);
            return principal;
        }
        catch (IOException iOException) {
            throw new IOException(NLS.bind((String)"Couldn''t obtain Onwer name for ID={0}. Reason: {1}", (Object)object, (Object)iOException.getMessage()));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.GET_USER);
            throw new IOException("No native API for getting Owner name from ID", unsatisfiedLinkError);
        }
    }

    @Override
    public final boolean isSupported(AbstractFileSystem.Feature feature) {
        return this.isSupportedNative(feature) || DefaultFileSystem.getInstance().isSupported(feature);
    }

    protected final boolean isSupportedNative(AbstractFileSystem.Feature feature) {
        return super.isSupported(feature);
    }

    @Override
    protected final FileInfo[] listFileInfosImpl(File file, int n, IProgressMonitor iProgressMonitor, int n2) throws IOException {
        if (this.isSupportedNative(AbstractFileSystem.Feature.DIR_LIST)) {
            String string = BaseFileSystem.pathToString(file);
            FileInfo[] fileInfoArray = null;
            try {
                if (iProgressMonitor != null && n2 <= 0) {
                    n2 = 128;
                }
                fileInfoArray = this.nListFileInfos(string, n, iProgressMonitor, n2);
            }
            catch (IOException iOException) {
                throw new IOException(String.valueOf(iOException.getMessage()) + " for: " + file);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.DIR_LIST);
            }
            if (fileInfoArray == null) {
                throw new IOException(NLS.bind((String)"Couldn''t natively list files for ''{0}''", (Object)file));
            }
            return fileInfoArray;
        }
        return DefaultFileSystem.getInstance().listFileInfos(file, n, iProgressMonitor, n2);
    }

    @Override
    public long moveFile(IFile iFile, IFile iFile2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        if (!this.isSupported(AbstractFileSystem.Feature.MOVE)) {
            throw new UnsupportedOperationException("moveFile");
        }
        if (iFile == null) {
            throw new NullPointerException("srcFile");
        }
        if (iFile2 == null) {
            throw new NullPointerException("dstFile");
        }
        if (iSyncProgressMonitor == null) {
            iSyncProgressMonitor = new NullSyncProgressMonitor();
        }
        if (iFile.isLocal() && iFile2.isLocal()) {
            if (this.isSupportedNative(AbstractFileSystem.Feature.MOVE)) {
                String string = iFile.getPath();
                String string2 = iFile2.getPath();
                try {
                    long l = this.nMoveFileCallback(string, string2, 0, iSyncProgressMonitor);
                    if (l < 0L) {
                        String string3 = "Couldn''t move '{0}' to '{1}'. Native moved: {2} bytes.";
                        throw new IOException(NLS.bind((String)string3, (Object[])new String[]{string, string2, Long.toString(l)}));
                    }
                    this.postProcessLocalFileInfo(true, iFile, string, string2);
                    return l;
                }
                catch (IOException iOException) {
                    String string4 = "Couldn''t move ''{0}'' to ''{1}''. Reason: {2}";
                    throw new IOException(NLS.bind((String)string4, (Object[])new String[]{string, string2, iOException.getMessage()}));
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.MOVE);
                }
            } else if (this.isSupportedNative(AbstractFileSystem.Feature.COPY)) {
                try {
                    DefaultFileSystem.renameFile(iFile, iFile2, iSyncProgressMonitor);
                    return iFile2.size();
                }
                catch (IOException iOException) {
                    long l = this.copyFile(iFile, iFile2, iSyncProgressMonitor);
                    DefaultFileSystem.deleteFile(iFile, iSyncProgressMonitor);
                    return l;
                }
            }
        }
        return DefaultFileSystem.getInstance().moveFile(iFile, iFile2, iSyncProgressMonitor);
    }

    private native boolean nAllowSecureAccess(long var1, boolean var3);

    protected final native boolean nCompareByteByByte(String var1, String var2, IProgressMonitor var3) throws IOException;

    protected native long nCopyFileCallback(String var1, String var2, int var3, ISyncProgressMonitor var4) throws IOException;

    private native void nCreateSymbolicLink(String var1, String var2, boolean var3) throws IOException;

    protected final native FileInfo nGetFileInfo(String var1, String var2, int var3) throws IOException;

    private native Principal nGetGroup(Object var1, int var2) throws IOException;

    private native Principal nGetUser(Object var1, int var2) throws IOException;

    protected native void nInitStatic() throws IllegalStateException;

    protected native FileInfo[] nListFileInfos(String var1, int var2, IProgressMonitor var3, int var4) throws IOException;

    protected native long nMoveFileCallback(String var1, String var2, int var3, ISyncProgressMonitor var4);

    private native String nReadSymbolicLink(String var1) throws IOException;

    protected final native void nSetFileInfo(String var1, int var2, long var3, long var5, long var7, int var9) throws IOException;

    private native void nUrlDeleteBookmark(long var1);

    private native UrlEx nUrlFromBookmark(byte[] var1) throws IOException;

    private native UrlEx nUrlFromPath(String var1) throws IOException;

    private native void nUrlRelease(long var1);

    private native byte[] nUrlToBookmark(long var1) throws IOException;

    protected final void onNativeError(Error error, AbstractFileSystem.Feature feature) {
        LOG.error(String.valueOf((Object)feature), (Throwable)error);
        super.disableSupportedFeature(feature);
    }

    @Override
    public String readSymbolicLink(String string) throws UnsupportedOperationException, IOException {
        if (this.isSupportedNative(AbstractFileSystem.Feature.READ_SYM_LINK)) {
            try {
                String string2 = this.nReadSymbolicLink(string);
                if (string2 == null) {
                    throw new IOException("null target " + string);
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("readLink of '" + string + "' target: '" + string2 + '\'');
                }
                return string2;
            }
            catch (IOException iOException) {
                throw new IOException(String.valueOf(iOException.getMessage()) + ": '" + string + "': ");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.READ_SYM_LINK);
            }
        }
        return DefaultFileSystem.getInstance().readSymbolicLink(string);
    }

    @Override
    protected final void setFileInfoImpl(File file, FileInfo fileInfo, int n) throws IOException {
        if (this.isSupportedNative(AbstractFileSystem.Feature.SET_FILE_INFO)) {
            long l;
            long l2;
            if (fileInfo instanceof FileInfoEx) {
                FileInfoEx fileInfoEx = (FileInfoEx)fileInfo;
                l2 = fileInfoEx.lastAccessedTime();
                l = fileInfoEx.createdTime();
            } else {
                l2 = 0L;
                l = 0L;
                n &= 0xFFFFFFE7;
            }
            try {
                boolean bl = LOG.isInfoEnabled();
                FileInfo fileInfo2 = bl ? IO.fileSystem().getFileInfo(file) : null;
                this.nSetFileInfo(file.getPath(), n, fileInfo.lastModifiedTime(), l2, l, fileInfo.attributes());
                if (bl) {
                    FileInfo fileInfo3 = IO.fileSystem().getFileInfo(file);
                    if ((n & 4) != 0) {
                        if (fileInfo3.lastModifiedTime() != fileInfo.lastModifiedTime()) {
                            LOG.warn("SetFileInfo desired date differs from set '" + file + "': " + fileInfo.lastModifiedTime() + " != " + fileInfo3.lastModifiedTime());
                        }
                    } else if (fileInfo3.lastModifiedTime() != fileInfo2.lastModifiedTime()) {
                        LOG.warn("SetFileInfo date was changed '" + file + "': " + fileInfo2.lastModifiedTime() + " != " + fileInfo3.lastModifiedTime() + " on mask=" + n);
                    }
                    if ((n & 1) != 0) {
                        if (fileInfo3.permissions() != fileInfo.permissions()) {
                            LOG.warn("SetFileInfo desired permissions differs from set '" + file + "': " + FileInfo.toStringAttributes(fileInfo.permissions()) + " != " + FileInfo.toStringAttributes(fileInfo3.permissions()));
                        }
                    } else if (fileInfo3.permissions() != fileInfo2.permissions()) {
                        LOG.warn("SetFileInfo permissions were changed '" + file + "': " + FileInfo.toStringAttributes(fileInfo2.permissions()) + " != " + FileInfo.toStringAttributes(fileInfo3.permissions()) + " on mask=" + n);
                    }
                }
                return;
            }
            catch (IOException iOException) {
                throw new IOException(String.valueOf(iOException.getMessage()) + ": '" + file + '\'');
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.SET_FILE_INFO);
            }
        }
        DefaultFileSystem.getInstance().setFileInfo(file, fileInfo, n);
    }

    private final void urlCheckSupported() {
        if (!this.isSupportedNative(AbstractFileSystem.Feature.URL_EX)) {
            throw new UnsupportedOperationException("UrlEx not supported");
        }
    }

    public void urlDeleteBookmark(long l) {
        BaseFileSystem.checkPointer(l);
        this.urlCheckSupported();
        this.nUrlDeleteBookmark(l);
        if (LOG.isInfoEnabled()) {
            LOG.info("Delete bookmark: " + l);
        }
    }

    public UrlEx urlFromBookmark(byte[] byArray) throws IOException {
        UrlEx urlEx;
        if (byArray.length <= 0) {
            throw new IllegalArgumentException("null bookmark");
        }
        if (byArray.length <= 0) {
            throw new IllegalArgumentException("empty bookmark");
        }
        this.urlCheckSupported();
        try {
            urlEx = this.nUrlFromBookmark(byArray);
            if (LOG.isInfoEnabled()) {
                LOG.info("Creates URL from bookmark: " + urlEx);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.URL_EX);
            throw new UnsupportedOperationException();
        }
        if (urlEx == null) {
            throw new IOException("Cannot create URL from bookmark: " + byArray.length);
        }
        return urlEx;
    }

    public final UrlEx urlFromPath(String string) throws IOException {
        UrlEx urlEx;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("'path' cannot be null nor empty");
        }
        this.urlCheckSupported();
        try {
            urlEx = this.nUrlFromPath(string);
            if (LOG.isInfoEnabled()) {
                LOG.info("Creates URL from str: " + string);
            }
        }
        catch (IOException iOException) {
            throw new IOException(String.valueOf(iOException.getMessage()) + ": '" + string + '\'');
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.URL_EX);
            throw new UnsupportedOperationException();
        }
        if (urlEx == null) {
            throw new IOException("Cannot create URL from string: " + string);
        }
        return urlEx;
    }

    public void urlRelease(long l) {
        BaseFileSystem.checkPointer(l);
        this.urlCheckSupported();
        this.nUrlRelease(l);
        if (LOG.isInfoEnabled()) {
            LOG.info("Release URL: " + l);
        }
    }

    public byte[] urlToBookmark(long l) throws IOException {
        BaseFileSystem.checkPointer(l);
        this.urlCheckSupported();
        byte[] byArray = this.nUrlToBookmark(l);
        if (byArray == null || byArray.length <= 0) {
            throw new IOException("Cannot create bookmark from URL: " + l);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Creates URL bookmark: " + byArray.length);
        }
        return byArray;
    }

    @Override
    public final void addStorageListener(File file, IStorageListener iStorageListener) {
        Checker.notNull(file, "file");
        if (this.isSupportedNative(AbstractFileSystem.Feature.STORAGE_LISTENER)) {
            this.addStorageListenerImpl(file, iStorageListener);
        } else {
            DefaultFileSystem.getInstance().addStorageListener(file, iStorageListener);
        }
    }

    @Override
    public final void removeStorageListener(File file, IStorageListener iStorageListener) {
        Checker.notNull(file, "file");
        if (this.isSupportedNative(AbstractFileSystem.Feature.STORAGE_LISTENER)) {
            this.removeStorageListenerImpl(file, iStorageListener);
        } else {
            DefaultFileSystem.getInstance().removeStorageListener(file, iStorageListener);
        }
    }

    protected void addStorageListenerImpl(File file, IStorageListener iStorageListener) {
        throw new UnsupportedOperationException("No native storage implemented");
    }

    protected void removeStorageListenerImpl(File file, IStorageListener iStorageListener) {
        throw new UnsupportedOperationException("No native storage implemented");
    }

    private void postProcessLocalFileInfo(boolean bl, IFile iFile, String string, String string2) {
        if (OS.OSX) {
            try {
                File file = new File(string2);
                FileInfo fileInfo = IO.fileSystem().getFileInfo(file);
                FileInfo fileInfo2 = iFile.getFileInfo();
                if (!fileInfo.equalsSettable(fileInfo2)) {
                    LOG.warn(NLS.bind((String)"{0}: : source: ''{1}'' ({2}) != target: ''{3}'' ({4})", (Object[])new String[]{bl ? "MOVE" : "COPY", string, fileInfo2.toString(), string2, fileInfo.toString()}));
                }
            }
            catch (Throwable throwable) {
                LOG.warn("Alternative file info copy failed:", throwable);
            }
        }
    }
}

