/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.internal.io;

import com.deltopia.interfaces.IPrincipal;
import com.deltopia.io.FileInfo;
import com.deltopia.io.IFileSystem;
import com.deltopia.io.IStorageListener;
import com.deltopia.io.Principal;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileSystem
implements IFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileSystem.class);
    private static final boolean toCHECK_SET_FILE_INFO = false;
    private final ConcurrentMap<Object, Principal> groupCache = new ConcurrentHashMap<Object, Principal>(2);
    private final ConcurrentMap<Object, Principal> ownerCache = new ConcurrentHashMap<Object, Principal>(2);
    private final int supportedAttributes;
    private final Set<Feature> supportedFeatures;

    protected AbstractFileSystem(EnumSet<Feature> enumSet, int n) {
        if (enumSet == null) {
            throw new NullPointerException("defSupportedFeatures");
        }
        this.supportedFeatures = EnumSet.copyOf(enumSet);
        this.supportedAttributes = n;
        if (LOG.isInfoEnabled()) {
            LOG.info("Create " + this.getClass() + ". Features: " + this.supportedFeatures + ", attributes=" + n);
        }
    }

    @Override
    public boolean isStorageListenerSupported() {
        return this.isSupported(Feature.STORAGE_LISTENER);
    }

    @Override
    public void addStorageListener(File file, IStorageListener iStorageListener) {
        throw new UnsupportedOperationException("addStorageListener");
    }

    @Override
    public Menu attachContextMenu(Control control, Menu menu, Set<File> set) throws UnsupportedOperationException, IOException {
        throw new UnsupportedOperationException("attachContextMenu");
    }

    @Override
    public final void createSymbolicLink(File file, String string, boolean bl) throws IOException, UnsupportedOperationException {
        if (!this.isSupported(Feature.CREATE_SYM_LINK)) {
            throw new UnsupportedOperationException("createSymbolicLink");
        }
        if (file == null) {
            throw new NullPointerException("linkPath");
        }
        if (string == null) {
            throw new NullPointerException("targetPath");
        }
        this.createSymbolicLinkImpl(file, string, bl);
    }

    protected void createSymbolicLinkImpl(File file, String string, boolean bl) throws IOException, UnsupportedOperationException {
        throw new IllegalStateException();
    }

    @Override
    public boolean delete(File file, boolean bl) {
        throw new UnsupportedOperationException("delete");
    }

    protected final void disableSupportedFeature(Feature feature) {
        if (feature == null) {
            throw new NullPointerException("feature");
        }
        this.supportedFeatures.remove((Object)feature);
    }

    @Override
    public final FileInfo getFileInfo(File file) throws IOException {
        if (!this.isSupported(Feature.GET_FILE_INFO)) {
            throw new UnsupportedOperationException("getFileInfo");
        }
        if (file == null) {
            throw new NullPointerException("path");
        }
        return this.getFileInfoImpl(file);
    }

    protected FileInfo getFileInfoImpl(File file) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public final IPrincipal getGroup(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        Principal principal = (Principal)this.groupCache.get(object);
        if (principal == null) {
            Principal principal2 = this.getGroupImpl(object);
            principal = this.groupCache.putIfAbsent(object, principal2);
            if (principal == null) {
                principal = principal2;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Get group: " + principal);
            }
        }
        return principal;
    }

    protected Principal getGroupImpl(Object object) throws IOException {
        throw new UnsupportedOperationException("Get group is not supported");
    }

    protected Principal getOwnerImpl(Object object) throws IOException {
        throw new UnsupportedOperationException("Get user is not supported");
    }

    @Override
    public final int getSupportedAttributes() {
        return this.supportedAttributes;
    }

    @Override
    public Image getThumbnail(Device device, File file, int n, int n2) throws IllegalArgumentException {
        return null;
    }

    @Override
    public final IPrincipal getUser(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        Principal principal = (Principal)this.ownerCache.get(object);
        if (principal == null) {
            Principal principal2 = this.getOwnerImpl(object);
            principal = this.ownerCache.putIfAbsent(object, principal2);
            if (principal == null) {
                principal = principal2;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Get user: " + principal);
            }
        }
        return principal;
    }

    @Override
    public final boolean isContextMenuSupported() {
        return this.isSupported(Feature.SHOW_CONTEXT_MENU);
    }

    @Override
    public final boolean isCreateSymbolicLinkSupported() {
        return this.isSupported(Feature.CREATE_SYM_LINK);
    }

    @Override
    public final boolean isMoveToTrashSupported() {
        return this.isSupported(Feature.MOVE_TO_TRASH);
    }

    @Override
    public final boolean isReadSymbolicLinkSupported() {
        return this.isSupported(Feature.READ_SYM_LINK);
    }

    public boolean isSupported(Feature feature) {
        return this.supportedFeatures.contains((Object)feature);
    }

    @Override
    public final boolean isUrlExSupported() {
        return this.isSupported(Feature.URL_EX);
    }

    @Override
    public final FileInfo[] listFileInfos(File file, int n, IProgressMonitor iProgressMonitor, int n2) throws IOException {
        if (!this.isSupported(Feature.DIR_LIST)) {
            throw new UnsupportedOperationException("listFileInfos");
        }
        if (file == null) {
            throw new NullPointerException("path");
        }
        return this.listFileInfosImpl(file, n, iProgressMonitor, n2);
    }

    protected FileInfo[] listFileInfosImpl(File file, int n, IProgressMonitor iProgressMonitor, int n2) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public String readSymbolicLink(String string) throws UnsupportedOperationException, IOException {
        throw new UnsupportedOperationException("readSymbolicLink");
    }

    @Override
    public final byte[] readSymbolicLinkData(String string) throws UnsupportedOperationException, IOException {
        String string2 = this.readSymbolicLink(string);
        return string2.getBytes("UTF-8");
    }

    @Override
    public void removeStorageListener(File file, IStorageListener iStorageListener) {
        throw new UnsupportedOperationException("removeStorageListener");
    }

    @Override
    public final void setFileInfo(File file, FileInfo fileInfo, int n) throws IOException {
        if (file == null) {
            throw new NullPointerException("path");
        }
        if (fileInfo == null) {
            throw new NullPointerException("info");
        }
        if ((n & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException("validMask = " + n);
        }
        if (n == 0) {
            return;
        }
        this.setFileInfoImpl(file, fileInfo, n);
    }

    protected abstract void setFileInfoImpl(File var1, FileInfo var2, int var3) throws IOException;

    protected static enum Feature {
        COMPARE_BB("compare.byte"),
        COPY("copy"),
        CREATE_SYM_LINK("create.sym.link"),
        DIR_LIST("dir.list"),
        GET_FILE_INFO("get.file.info"),
        GET_GROUP("get.group"),
        GET_USER("get.user"),
        MOVE("move"),
        MOVE_TO_TRASH("move.trash"),
        READ_SYM_LINK("read.sym.link"),
        SET_FILE_INFO("set.file.info"),
        SHOW_CONTEXT_MENU("show.context.menu"),
        URL_EX("url.ex"),
        STORAGE_LISTENER("storage.listener");

        private final String key;

        private Feature(String string2) {
            this.key = string2;
        }

        public String getPropertyKey() {
            return this.key;
        }
    }
}

