/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.internal;

import com.deltopia.internal.Worker;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerPoolImpl {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerPoolImpl.class);
    private final List<Runnable> assignments = new ArrayList<Runnable>();
    private boolean shutdownInProgress;
    private int workerCount;
    private final long workerIdleTimeout;
    private final Worker[] workers;

    public WorkerPoolImpl(int n, long l) {
        this.workers = new Worker[n];
        this.workerIdleTimeout = l;
    }

    public void beginShutdown() {
        this.shutdownInProgress = true;
        this.clearAssignments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAssignments() {
        List<Runnable> list = this.assignments;
        synchronized (list) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Clear all assignments. Size=" + this.assignments.size());
            }
            this.assignments.clear();
            this.assignments.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Runnable getAssignment(Worker worker) {
        if (this.shutdownInProgress) {
            return null;
        }
        List<Runnable> list = this.assignments;
        synchronized (list) {
            boolean bl = false;
            try {
                while (this.assignments.size() == 0) {
                    block16: {
                        if (this.shutdownInProgress) {
                            this.clearAssignments();
                        } else {
                            try {
                                if (LOG.isInfoEnabled()) {
                                    LOG.info("No assignments. Wait for " + this.workerIdleTimeout);
                                }
                                this.assignments.wait(this.workerIdleTimeout);
                                if (this.assignments.size() != 0) continue;
                                if (!LOG.isInfoEnabled()) break block16;
                                LOG.info("No assignments. Exit");
                            }
                            catch (InterruptedException interruptedException) {
                                bl = true;
                                continue;
                            }
                        }
                    }
                    return null;
                }
            }
            finally {
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
            Runnable runnable = this.assignments.remove(0);
            if (LOG.isInfoEnabled()) {
                LOG.info("Get assignment " + runnable + ". Size=" + this.assignments.size());
            }
            return runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAssignmentCount() {
        List<Runnable> list = this.assignments;
        synchronized (list) {
            return this.assignments.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable[] getAssignments(boolean bl) {
        List<Runnable> list = this.assignments;
        synchronized (list) {
            Runnable[] runnableArray = this.assignments.toArray(new Runnable[this.assignments.size()]);
            if (LOG.isInfoEnabled()) {
                LOG.info("Get assignment list: " + runnableArray.length);
            }
            if (bl) {
                this.clearAssignments();
            }
            return runnableArray;
        }
    }

    public void queueAssignment(Runnable runnable) {
        this.queueAssignment(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAssignment(Runnable runnable, boolean bl) {
        if (runnable == null) {
            throw new IllegalArgumentException("assignment");
        }
        Object object = this.assignments;
        synchronized (object) {
            int n = this.assignments.indexOf(runnable);
            if (n != -1) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Assignment already exist " + runnable + " at " + n + ". Size=" + this.assignments.size());
                }
                if (!bl) {
                    return;
                }
                this.assignments.remove(n);
            }
            if (bl) {
                this.assignments.add(0, runnable);
            } else {
                this.assignments.add(runnable);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Add Assignment " + runnable + " at " + (bl ? 0 : this.assignments.size() - 1));
            }
            this.assignments.notifyAll();
        }
        object = this;
        synchronized (object) {
            if (this.workerCount < this.workers.length) {
                Worker worker = new Worker(this);
                this.registerWorker(worker);
                worker.start();
            }
        }
    }

    private synchronized void registerWorker(Worker worker) {
        if (this.workerCount >= this.workers.length) {
            throw new IllegalStateException();
        }
        this.workers[this.workerCount++] = worker;
    }

    public void restart() {
        this.clearAssignments();
        this.shutdownInProgress = false;
    }

    synchronized void unregisterWorker(Worker worker) {
        int n = 0;
        while (n < this.workers.length) {
            if (worker == this.workers[n]) {
                System.arraycopy(this.workers, n + 1, this.workers, n, this.workerCount - n - 1);
                this.workers[--this.workerCount] = null;
                break;
            }
            ++n;
        }
    }
}

