/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.internal;

import com.deltopia.internal.WorkerPoolImpl;
import com.deltopia.util.MemoryUtil;
import org.eclipse.core.runtime.ISafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(Worker.class);
    private Runnable assignment;
    private final WorkerPoolImpl pool;

    public Worker(WorkerPoolImpl workerPoolImpl) {
        this.pool = workerPoolImpl;
    }

    @Override
    public final void run() {
        try {
            MemoryUtil.dumpMemoryUsage(LOG, "Start Worker.run");
            while ((this.assignment = this.pool.getAssignment(this)) != null) {
                try {
                    try {
                        this.assignment.run();
                    }
                    catch (Exception exception) {
                        if (this.assignment instanceof ISafeRunnable) {
                            ((ISafeRunnable)this.assignment).handleException((Throwable)exception);
                        }
                        this.assignment = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.assignment = null;
                    throw throwable;
                }
                this.assignment = null;
            }
        }
        finally {
            this.assignment = null;
            this.pool.unregisterWorker(this);
            MemoryUtil.dumpMemoryUsage(LOG, "Finish Worker.run");
        }
    }
}

