/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.collection;

import com.deltopia.collection.ISortedSetList;
import com.deltopia.collection.SortedArrayList;
import com.deltopia.collection.SortedArrayListComparator;
import com.deltopia.util.Checker;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class SortedSetListFactory {
    static final <E, C extends ISortedSetList<E>> boolean binarySearchAddAll(C c, Collection<? extends E> collection) {
        Checker.notNull(collection, "listToAdd");
        boolean bl = false;
        for (E e : collection) {
            boolean bl2 = c.add(e);
            if (!bl2) continue;
            bl = true;
        }
        return bl;
    }

    static final <E extends Comparable<E>, C extends List<E>> int binarySearchForAdd(C c, E e) {
        Checker.notNull(e, "elem");
        int n = Collections.binarySearch(c, e);
        return SortedSetListFactory.convertIndex(n);
    }

    static final <E, C extends List<E>, CP extends Comparator<E>> int binarySearchForAdd(C c, E e, CP CP) {
        Checker.notNull(e, "elem");
        int n = Collections.binarySearch(c, e, CP);
        return SortedSetListFactory.convertIndex(n);
    }

    static final <E extends Comparable<E>, C extends List<E>> int indexOf(C c, Object object) {
        Checker.notNull(object, "elem");
        int n = Collections.binarySearch(c, (Comparable)object);
        return n >= 0 ? n : -1;
    }

    static final <E, C extends List<E>, CP extends Comparator<E>> int indexOf(C c, Object object, CP CP) {
        Checker.notNull(object, "elem");
        int n = Collections.binarySearch(c, object, CP);
        return n >= 0 ? n : -1;
    }

    private static final int convertIndex(int n) {
        if (n < 0) {
            int n2 = -(n + 1);
            if (n2 < 0) {
                n2 = 0;
            }
            return n2;
        }
        return -1;
    }

    public static final <E extends Comparable<E>> ISortedSetList<E> mostMemoryOptimal(int n) {
        return new SortedArrayList(n);
    }

    public static final <E> ISortedSetList<E> mostMemoryOptimal(int n, Comparator<E> comparator) {
        return new SortedArrayListComparator<E>(n, comparator);
    }
}

