/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.collection;

import com.deltopia.collection.ISortedSetList;
import com.deltopia.collection.SortedSetListFactory;
import com.deltopia.util.Checker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

final class SortedArrayListComparator<E>
extends ArrayList<E>
implements ISortedSetList<E> {
    private final Comparator<E> comparator;

    SortedArrayListComparator(int n, Comparator<E> comparator) {
        super(n);
        this.comparator = Checker.notNull(comparator, "comparator");
    }

    @Override
    public boolean add(E e) {
        int n = SortedSetListFactory.binarySearchForAdd(this, e, this.comparator);
        if (n >= 0) {
            super.add(n, e);
            return true;
        }
        return false;
    }

    @Override
    public void add(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return SortedSetListFactory.binarySearchAddAll(this, collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        return SortedSetListFactory.indexOf(this, object, this.comparator);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException();
    }
}

