/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia;

import com.deltopia.CharSequenceUtil;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public final class StringUtil {
    public static final int compare(String string, String string2, boolean bl, boolean bl2) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return bl2 ? 1 : -1;
        }
        if (string2 == null) {
            return bl2 ? -1 : 1;
        }
        if (bl) {
            return string.compareToIgnoreCase(string2);
        }
        return string.compareTo(string2);
    }

    public static String ellipsize(String string, Control control, int n) {
        if (string == null) {
            return "";
        }
        GC gC = new GC((Drawable)control);
        String string2 = string;
        try {
            int n2;
            int n3;
            n = n != -1 ? n : (int)((double)(control.getSize().x - 2 * control.getBorderWidth()) * 0.9);
            int n4 = string.length();
            while ((n3 = (n2 = gC.textExtent((String)string2).x) - n) > 0) {
                int n5 = string2.length();
                int n6 = (int)Math.ceil((double)(n3 * n5) / (double)n2);
                if (n4 <= n6) {
                    break;
                }
                int n7 = n5 - n6;
                String string3 = StringUtil.ellipsize(string, (int)((double)n7 * 0.3), (int)((double)n7 * 0.7));
                if (n5 <= string3.length()) {
                    break;
                }
                string2 = string3;
            }
        }
        finally {
            gC.dispose();
        }
        return string2;
    }

    public static String ellipsize(String string, int n, int n2) {
        int n3 = n + n2;
        int n4 = string.length();
        return n4 <= n3 ? string : String.valueOf(string.substring(0, n)) + "..." + string.substring(n4 - n2);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String join(Object[] objectArray, int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2 - 1) {
            stringBuffer.append(objectArray[n3]);
            stringBuffer.append(string);
            ++n3;
        }
        if (n2 > n) {
            stringBuffer.append(objectArray[n2 - 1]);
        }
        return stringBuffer.toString();
    }

    public static String join(Object[] objectArray, String string) {
        return StringUtil.join(objectArray, 0, objectArray.length, string);
    }

    public static String makeSafe(String string) {
        return string != null ? string : "";
    }

    public static String replace(String string, String string2, String string3) {
        if (string != null && string2 != null) {
            int n;
            StringBuilder stringBuilder = new StringBuilder(string);
            int n2 = string2.length();
            int n3 = string3 == null ? 0 : string3.length();
            int n4 = 0;
            while ((n = stringBuilder.indexOf(string2, n4)) > -1) {
                stringBuilder.replace(n, n + n2, string3);
                n4 = n + n3;
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private static boolean startsWith(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == null && charSequence2 == null;
        }
        if (charSequence2.length() > charSequence.length()) {
            return false;
        }
        return CharSequenceUtil.regionMatches(charSequence, bl, 0, charSequence2, 0, charSequence2.length());
    }

    public static boolean startsWithIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtil.startsWith(charSequence, charSequence2, true);
    }

    public static final String toBinStr(short s) {
        String string = String.format("0b%16s", Integer.toBinaryString(s));
        return string.replace(' ', '0');
    }

    private StringUtil() {
    }
}

