/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia;

public final class MathUtil {
    private static final double LN_OF_2 = Math.log(2.0);

    public static final int compare(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public static final boolean isDetermined(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    public static final boolean isEqual(double d, double d2, double d3) throws IllegalArgumentException {
        if (!MathUtil.isDetermined(d)) {
            throw new IllegalArgumentException("value1 " + d);
        }
        if (!MathUtil.isDetermined(d2)) {
            throw new IllegalArgumentException("value2 " + d2);
        }
        if (!MathUtil.isDetermined(d3)) {
            throw new IllegalArgumentException("accuracy " + d3);
        }
        return Math.abs(d - d2) < d3;
    }

    public static final double log2(double d) {
        return Math.log(d) / LN_OF_2;
    }

    public static final int floorPow2(int n) {
        boolean bl;
        if (n == 0) {
            return 0;
        }
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        int n2 = 31 - Integer.numberOfLeadingZeros(n);
        int n3 = 1 << n2;
        if (bl) {
            n3 = -n3;
        }
        return n3;
    }

    private MathUtil() {
    }
}

