/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.forms.widgets.Twistie;
import org.eclipse.ui.internal.forms.IMessageToolTipManager;
import org.eclipse.ui.internal.forms.widgets.BusyIndicator;
import org.eclipse.ui.internal.forms.widgets.FormHeading;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class TitleRegion
extends Canvas {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_HOVER_LIGHT = 1;
    public static final int STATE_HOVER_FULL = 2;
    private int hoverState;
    private static final int HMARGIN = 1;
    private static final int VMARGIN = 5;
    private static final int SPACING = 5;
    private static final int ARC_WIDTH = 20;
    private static final int ARC_HEIGHT = 20;
    private Image image;
    private BusyIndicator busyLabel;
    private Label titleLabel = new Label((Composite)this, 64);
    private SizeCache titleCache;
    private int fontHeight = -1;
    private int fontBaselineHeight = -1;
    private MenuHyperlink menuHyperlink;
    private MenuManager menuManager;
    private boolean dragSupport;
    private int dragOperations;
    private Transfer[] dragTransferTypes;
    private DragSourceListener dragListener;
    private DragSource dragSource;
    private Image dragImage;

    public TitleRegion(Composite composite) {
        super(composite, 0);
        this.titleLabel.setVisible(false);
        this.titleCache = new SizeCache();
        super.setLayout((Layout)new TitleRegionLayout());
        this.hookHoverListeners();
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (TitleRegion.this.dragImage != null) {
                    TitleRegion.this.dragImage.dispose();
                    TitleRegion.this.dragImage = null;
                }
            }
        });
    }

    public boolean forceFocus() {
        return false;
    }

    private Color getColor(String string) {
        return (Color)((FormHeading)this.getParent()).colors.get(string);
    }

    private void hookHoverListeners() {
        HoverListener hoverListener = new HoverListener();
        this.addMouseTrackListener(hoverListener);
        this.addMouseMoveListener(hoverListener);
        this.titleLabel.addMouseTrackListener((MouseTrackListener)hoverListener);
        this.titleLabel.addMouseMoveListener((MouseMoveListener)hoverListener);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TitleRegion.this.onPaint(paintEvent);
            }
        });
    }

    private void onPaint(PaintEvent paintEvent) {
        if (this.hoverState == 0) {
            return;
        }
        GC gC = paintEvent.gc;
        Rectangle rectangle = this.getClientArea();
        gC.setBackground(this.getHoverBackground());
        int n = gC.getAntialias();
        FormUtil.setAntialias(gC, 1);
        gC.fillRoundRectangle(rectangle.x + 1, rectangle.y + 2, rectangle.width - 2, rectangle.height - 4, 20, 20);
        FormUtil.setAntialias(gC, n);
    }

    private Color getHoverBackground() {
        if (this.hoverState == 0) {
            return null;
        }
        Color color = this.getColor(this.hoverState == 2 ? "org.eclipse.ui.forms.H_H_HOVER_FULL" : "org.eclipse.ui.forms.H_H_HOVER_LIGHT");
        if (color == null) {
            color = this.getDisplay().getSystemColor(this.hoverState == 2 ? 22 : 19);
        }
        return color;
    }

    public void setHoverState(int n) {
        if (this.dragSource == null || this.hoverState == n) {
            return;
        }
        this.hoverState = n;
        Color color = this.getHoverBackground();
        this.titleLabel.setBackground(color != null ? color : this.getColor("baseBg"));
        if (this.busyLabel != null) {
            this.busyLabel.setBackground(color != null ? color : this.getColor("baseBg"));
        }
        if (this.menuHyperlink != null) {
            this.menuHyperlink.setBackground(color != null ? color : this.getColor("baseBg"));
        }
        this.redraw();
    }

    public final Point computeSize(int n, int n2, boolean bl) {
        return ((TitleRegionLayout)this.getLayout()).computeSize((Composite)this, n, n2, bl);
    }

    public final void setLayout(Layout layout) {
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void updateImage(Image image, boolean bl) {
        Image image2;
        Image image3 = image2 = image != null ? image : this.image;
        if (image2 != null) {
            this.ensureBusyLabelExists();
        } else if (this.busyLabel != null && !this.busyLabel.isBusy()) {
            this.busyLabel.dispose();
            this.busyLabel = null;
        }
        if (this.busyLabel != null) {
            this.busyLabel.setImage(image2);
        }
        if (bl) {
            this.layout();
        }
    }

    public void updateToolTip(String string) {
        if (this.busyLabel != null) {
            this.busyLabel.setToolTipText(string);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.titleLabel.setBackground(color);
        if (this.busyLabel != null) {
            this.busyLabel.setBackground(color);
        }
        if (this.menuHyperlink != null) {
            this.menuHyperlink.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.titleLabel.setForeground(color);
        if (this.menuHyperlink != null) {
            this.menuHyperlink.setForeground(color);
        }
    }

    public void setText(String string) {
        if (string != null) {
            this.titleLabel.setText(string);
        }
        this.titleLabel.setVisible(string != null);
        this.layout();
        this.redraw();
    }

    public String getText() {
        return this.titleLabel.getText();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.titleLabel.setFont(font);
        this.fontHeight = -1;
        this.fontBaselineHeight = -1;
        this.layout();
    }

    private void ensureBusyLabelExists() {
        if (this.busyLabel == null) {
            IMessageToolTipManager iMessageToolTipManager;
            this.busyLabel = new BusyIndicator((Composite)this, 0);
            this.busyLabel.setBackground(this.getColor("baseBg"));
            HoverListener hoverListener = new HoverListener();
            this.busyLabel.addMouseTrackListener(hoverListener);
            this.busyLabel.addMouseMoveListener(hoverListener);
            if (this.menuManager != null) {
                this.busyLabel.setMenu(this.menuManager.createContextMenu((Control)this));
            }
            if (this.dragSupport) {
                this.addDragSupport((Control)this.busyLabel, this.dragOperations, this.dragTransferTypes, this.dragListener);
            }
            if ((iMessageToolTipManager = ((FormHeading)this.getParent()).getMessageToolTipManager()) != null) {
                iMessageToolTipManager.createToolTip((Control)this.busyLabel, true);
            }
        }
    }

    private void createMenuHyperlink() {
        this.menuHyperlink = new MenuHyperlink((Composite)this, 0);
        this.menuHyperlink.setBackground(this.getColor("baseBg"));
        this.menuHyperlink.setDecorationColor(this.getForeground());
        this.menuHyperlink.setHoverDecorationColor(this.getDisplay().getSystemColor(24));
        HoverListener hoverListener = new HoverListener();
        this.menuHyperlink.addMouseTrackListener(hoverListener);
        this.menuHyperlink.addMouseMoveListener(hoverListener);
        if (this.dragSupport) {
            this.addDragSupport((Control)this.menuHyperlink, this.dragOperations, this.dragTransferTypes, this.dragListener);
        }
    }

    public boolean setBusy(boolean bl) {
        if (bl) {
            this.ensureBusyLabelExists();
        } else if (this.busyLabel == null) {
            return false;
        }
        if (bl == this.busyLabel.isBusy()) {
            return false;
        }
        this.busyLabel.setBusy(bl);
        if (this.busyLabel.getImage() == null) {
            this.layout();
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return this.busyLabel != null && this.busyLabel.isBusy();
    }

    public int getFontHeight() {
        if (this.fontHeight == -1) {
            Font font = this.getFont();
            GC gC = new GC((Drawable)this.getDisplay());
            gC.setFont(font);
            FontMetrics fontMetrics = gC.getFontMetrics();
            this.fontHeight = fontMetrics.getHeight();
            gC.dispose();
        }
        return this.fontHeight;
    }

    public int getFontBaselineHeight() {
        if (this.fontBaselineHeight == -1) {
            Font font = this.getFont();
            GC gC = new GC((Drawable)this.getDisplay());
            gC.setFont(font);
            FontMetrics fontMetrics = gC.getFontMetrics();
            this.fontBaselineHeight = fontMetrics.getHeight() - fontMetrics.getDescent();
            gC.dispose();
        }
        return this.fontBaselineHeight;
    }

    public IMenuManager getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            Menu menu = this.menuManager.createContextMenu((Control)this);
            this.setMenu(menu);
            this.titleLabel.setMenu(menu);
            if (this.busyLabel != null) {
                this.busyLabel.setMenu(menu);
            }
            this.createMenuHyperlink();
        }
        return this.menuManager;
    }

    public void addDragSupport(int n, Transfer[] transferArray, DragSourceListener dragSourceListener) {
        this.dragSupport = true;
        this.dragOperations = n;
        this.dragTransferTypes = transferArray;
        this.dragListener = dragSourceListener;
        this.dragSource = this.addDragSupport((Control)this.titleLabel, n, transferArray, dragSourceListener);
        this.addDragSupport((Control)this, n, transferArray, dragSourceListener);
        if (this.busyLabel != null) {
            this.addDragSupport((Control)this.busyLabel, n, transferArray, dragSourceListener);
        }
        if (this.menuHyperlink != null) {
            this.addDragSupport((Control)this.menuHyperlink, n, transferArray, dragSourceListener);
        }
    }

    private DragSource addDragSupport(Control control, int n, Transfer[] transferArray, DragSourceListener dragSourceListener) {
        DragSource dragSource = new DragSource(control, n);
        dragSource.setTransfer(transferArray);
        dragSource.addDragListener(dragSourceListener);
        dragSource.setDragSourceEffect(new DragSourceEffect(control){

            public void dragStart(DragSourceEvent dragSourceEvent) {
                dragSourceEvent.image = TitleRegion.this.createDragEffectImage();
            }
        });
        return dragSource;
    }

    private Image createDragEffectImage() {
        return null;
    }

    public void addDropSupport(int n, Transfer[] transferArray, DropTargetListener dropTargetListener) {
        DropTarget dropTarget = new DropTarget((Control)this, n);
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener(dropTargetListener);
    }

    private class HoverListener
    implements MouseTrackListener,
    MouseMoveListener {
        private HoverListener() {
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            TitleRegion.this.setHoverState(2);
        }

        public void mouseExit(MouseEvent mouseEvent) {
            TitleRegion.this.setHoverState(0);
        }

        public void mouseHover(MouseEvent mouseEvent) {
        }

        public void mouseMove(MouseEvent mouseEvent) {
            if (mouseEvent.button > 0) {
                TitleRegion.this.setHoverState(0);
            } else {
                TitleRegion.this.setHoverState(2);
            }
        }
    }

    private class MenuHyperlink
    extends Twistie {
        private boolean firstTime;

        public MenuHyperlink(Composite composite, int n) {
            super(composite, n);
            this.firstTime = true;
            this.setExpanded(true);
        }

        @Override
        public void setExpanded(boolean bl) {
            if (this.firstTime) {
                super.setExpanded(bl);
                this.firstTime = false;
            } else {
                Menu menu = TitleRegion.this.menuManager.createContextMenu((Control)TitleRegion.this.menuHyperlink);
                menu.setVisible(true);
            }
        }
    }

    private class TitleRegionLayout
    extends Layout
    implements ILayoutExtension {
        private TitleRegionLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            return this.layout(composite, false, 0, 0, n, n2, bl);
        }

        protected void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            this.layout(composite, true, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
        }

        private Point layout(Composite composite, boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
            int n5;
            int n6 = n3 == -1 ? -1 : n3 - 2;
            Point point = null;
            Point point2 = null;
            Point point3 = null;
            if (TitleRegion.this.busyLabel != null) {
                point = TitleRegion.this.busyLabel.computeSize(-1, -1);
            }
            if (TitleRegion.this.menuManager != null) {
                TitleRegion.this.menuHyperlink.setVisible(!TitleRegion.this.menuManager.isEmpty() && TitleRegion.this.titleLabel.getVisible());
                if (TitleRegion.this.menuHyperlink.getVisible()) {
                    point3 = TitleRegion.this.menuHyperlink.computeSize(-1, -1);
                }
            }
            if (bl2) {
                TitleRegion.this.titleCache.flush();
            }
            TitleRegion.this.titleCache.setControl((Control)TitleRegion.this.titleLabel);
            int n7 = n5 = n6 == -1 ? n6 : n6 - 10;
            if (point != null && n5 != -1) {
                n5 -= point.x + 5;
            }
            if (point3 != null && n5 != -1) {
                n5 -= point3.x + 5;
            }
            if (TitleRegion.this.titleLabel.getVisible()) {
                point2 = TitleRegion.this.titleCache.computeSize(n5, -1);
                if (n5 != -1) {
                    int n8 = ((TitleRegion)TitleRegion.this).titleCache.computeSize((int)-1, (int)-1).x;
                    point2.x = Math.min(point2.x, n8);
                }
            } else {
                point2 = new Point(0, 0);
            }
            Point point4 = new Point(n3, n4);
            if (!bl) {
                point4.x = point2.x > 0 ? 12 + point2.x : 0;
                point4.y = point2.y;
                if (point != null) {
                    point4.x += point.x + 5;
                    point4.y = Math.max(point4.y, point.y);
                }
                if (point3 != null) {
                    point4.x += point3.x + 5;
                    point4.y = Math.max(point4.y, point3.y);
                }
                if (point4.y > 0) {
                    point4.y += 10;
                }
            } else {
                int n9 = n + 1 + 5;
                int n10 = n2 + 5;
                if (point != null) {
                    TitleRegion.this.busyLabel.setBounds(n9, n10 + (TitleRegion.this.getFontHeight() >= point.y ? TitleRegion.this.getFontHeight() : point.y) - 1 - point.y, point.x, point.y);
                    n9 += point.x + 5;
                }
                if (TitleRegion.this.titleLabel.getVisible()) {
                    int n11 = n3 - 2 - 10;
                    String string = System.getProperty("os.name");
                    if ("linux".equalsIgnoreCase(string)) {
                        ++n11;
                    }
                    if (point != null) {
                        n11 -= point.x + 5;
                    }
                    if (point3 != null) {
                        n11 -= point3.x + 5;
                    }
                    TitleRegion.this.titleLabel.setBounds(n9, n10, n11, point2.y);
                    n9 += n11 + 5;
                }
                if (point3 != null) {
                    TitleRegion.this.menuHyperlink.setBounds(n9, n10 + TitleRegion.this.getFontHeight() / 2 - point3.y / 2, point3.x, point3.y);
                }
            }
            return point4;
        }

        @Override
        public int computeMaximumWidth(Composite composite, boolean bl) {
            return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)bl).x;
        }

        @Override
        public int computeMinimumWidth(Composite composite, boolean bl) {
            return this.computeSize((Composite)composite, (int)0, (int)-1, (boolean)bl).x;
        }
    }
}

