/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import com.ibm.icu.text.BreakIterator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.SelectionData;

public class TextSegment
extends ParagraphSegment {
    private String colorId;
    private String fontId;
    private String text;
    protected boolean underline;
    private boolean wrapAllowed = true;
    protected Vector areaRectangles = new Vector();
    private TextFragment[] textFragments;

    public TextSegment(String string, String string2) {
        this(string, string2, null, true);
    }

    public TextSegment(String string, String string2, String string3) {
        this(string, string2, string3, true);
    }

    public TextSegment(String string, String string2, String string3, boolean bl) {
        this.text = this.cleanup(string);
        this.fontId = string2;
        this.colorId = string3;
        this.wrapAllowed = bl;
    }

    private String cleanup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\n' || c == '\r' || c == '\f') {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setWordWrapAllowed(boolean bl) {
        this.wrapAllowed = bl;
    }

    public boolean isWordWrapAllowed() {
        return this.wrapAllowed;
    }

    public boolean isSelectable() {
        return false;
    }

    public String getColorId() {
        return this.colorId;
    }

    public String getText() {
        return this.text;
    }

    void setText(String string) {
        this.text = this.cleanup(string);
        this.textFragments = null;
    }

    void setColorId(String string) {
        this.colorId = string;
    }

    void setFontId(String string) {
        this.fontId = string;
        this.textFragments = null;
    }

    @Override
    public boolean contains(int n, int n2) {
        int n3 = 0;
        while (n3 < this.areaRectangles.size()) {
            AreaRectangle areaRectangle = (AreaRectangle)this.areaRectangles.get(n3);
            if (areaRectangle.contains(n, n2)) {
                return true;
            }
            if (n3 < this.areaRectangles.size() - 1) {
                Rectangle rectangle = areaRectangle.rect;
                Rectangle rectangle2 = ((AreaRectangle)this.areaRectangles.get((int)(n3 + 1))).rect;
                if (n2 >= rectangle.y + rectangle.height && n2 < rectangle2.y) {
                    int n4 = Math.max(rectangle.x, rectangle2.x);
                    int n5 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
                    if (n >= n4 && n <= n5) {
                        return true;
                    }
                }
            }
            ++n3;
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        int n = 0;
        while (n < this.areaRectangles.size()) {
            AreaRectangle areaRectangle = (AreaRectangle)this.areaRectangles.get(n);
            if (areaRectangle.intersects(rectangle)) {
                return true;
            }
            if (n < this.areaRectangles.size() - 1) {
                Rectangle rectangle2 = areaRectangle.rect;
                Rectangle rectangle3 = ((AreaRectangle)this.areaRectangles.get((int)(n + 1))).rect;
                if (rectangle2.y + rectangle2.height < rectangle3.y) {
                    int n2;
                    int n3 = rectangle2.y + rectangle2.height;
                    int n4 = rectangle3.y - n3;
                    int n5 = Math.max(rectangle2.x, rectangle3.x);
                    Rectangle rectangle4 = new Rectangle(n5, n3, (n2 = Math.min(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width)) - n5, n4);
                    if (rectangle4.intersects(rectangle)) {
                        return true;
                    }
                }
            }
            ++n;
        }
        return false;
    }

    public Rectangle getBounds() {
        if (this.areaRectangles.size() == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        AreaRectangle areaRectangle = (AreaRectangle)this.areaRectangles.get(0);
        Rectangle rectangle = Geometry.copy((Rectangle)areaRectangle.rect);
        int n = 1;
        while (n < this.areaRectangles.size()) {
            AreaRectangle areaRectangle2 = (AreaRectangle)this.areaRectangles.get(n);
            rectangle.add(areaRectangle2.rect);
            ++n;
        }
        return rectangle;
    }

    @Override
    public boolean advanceLocator(GC gC, int n, Locator locator, Hashtable hashtable, boolean bl) {
        FontMetrics fontMetrics;
        Font font = null;
        if (this.fontId != null) {
            font = gC.getFont();
            fontMetrics = (Font)hashtable.get(this.fontId);
            if (fontMetrics != null) {
                gC.setFont((Font)fontMetrics);
            }
        }
        fontMetrics = gC.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        boolean bl2 = false;
        if (n == -1 || !this.wrapAllowed) {
            Point point = gC.textExtent(this.text);
            int n3 = locator.x + point.x;
            if (this.isSelectable()) {
                ++n3;
            }
            if (n != -1 && n3 + locator.marginWidth > n) {
                locator.resetCaret();
                locator.y += locator.rowHeight;
                if (bl) {
                    locator.collectHeights();
                }
                locator.rowHeight = 0;
                locator.leading = 0;
                bl2 = true;
            }
            int n4 = point.x;
            if (this.isSelectable()) {
                ++n4;
            }
            locator.x += n4;
            locator.width = locator.x;
            locator.rowHeight = Math.max(locator.rowHeight, point.y);
            locator.leading = Math.max(locator.leading, fontMetrics.getLeading());
            return bl2;
        }
        this.computeTextFragments(gC);
        int n5 = 0;
        Point point = new Point(0, 0);
        int n6 = 0;
        while (n6 < this.textFragments.length) {
            TextFragment textFragment = this.textFragments[n6];
            int n7 = locator.x + point.x;
            if (this.isSelectable()) {
                ++n7;
            }
            if ((n6 != 0 || locator.x > locator.getStartX() + (this.isSelectable() ? 1 : 0)) && n7 + textFragment.length > n) {
                int n8 = n7;
                locator.rowHeight = Math.max(locator.rowHeight, point.y);
                locator.leading = Math.max(locator.leading, fontMetrics.getLeading());
                if (bl) {
                    locator.collectHeights();
                }
                locator.x = locator.indent;
                locator.y += locator.rowHeight;
                locator.rowHeight = 0;
                locator.leading = 0;
                point.x = 0;
                point.y = 0;
                n5 = Math.max(n5, n8);
                bl2 = true;
            }
            point.x += textFragment.length;
            point.y = Math.max(n2, point.y);
            n5 = Math.max(n5, locator.x + point.x);
            ++n6;
        }
        n6 = point.x;
        if (this.isSelectable()) {
            ++n6;
        }
        locator.x += n6;
        locator.width = n5;
        locator.rowHeight = Math.max(locator.rowHeight, point.y);
        locator.leading = Math.max(locator.leading, fontMetrics.getLeading());
        if (font != null) {
            gC.setFont(font);
        }
        return bl2;
    }

    private void layoutWithoutWrapping(GC gC, int n, Locator locator, boolean bl, FontMetrics fontMetrics, int n2, int n3) {
        Point point = gC.textExtent(this.text);
        int n4 = point.x;
        if (this.isSelectable()) {
            ++n4;
        }
        if (locator.x + n4 > n - locator.marginWidth) {
            locator.resetCaret();
            locator.y += locator.rowHeight;
            locator.rowHeight = 0;
            ++locator.rowCounter;
        }
        int n5 = locator.getBaseline(fontMetrics.getHeight() - fontMetrics.getLeading());
        Rectangle rectangle = new Rectangle(locator.x, n5, n4, n2 - n3 + 3);
        this.areaRectangles.add(new AreaRectangle(rectangle, 0, -1));
        locator.x += n4;
        locator.width = n4;
        locator.rowHeight = Math.max(locator.rowHeight, point.y);
    }

    protected int convertOffsetToStringIndex(GC gC, String string, int n, int n2, int n3) {
        int n4 = string.length();
        while (n4 > 0 && n + n2 > n3) {
            String string2 = string.substring(0, --n4);
            n2 = gC.textExtent((String)string2).x;
        }
        return n4;
    }

    public void paintFocus(GC gC, Color color, Color color2, boolean bl, Rectangle rectangle) {
        if (this.areaRectangles == null) {
            return;
        }
        int n = 0;
        while (n < this.areaRectangles.size()) {
            AreaRectangle areaRectangle = (AreaRectangle)this.areaRectangles.get(n);
            Rectangle rectangle2 = areaRectangle.rect;
            int n2 = rectangle2.x;
            int n3 = rectangle2.y;
            if (rectangle != null) {
                n2 -= rectangle.x;
                n3 -= rectangle.y;
            }
            if (bl) {
                gC.setBackground(color);
                gC.setForeground(color2);
                gC.drawFocus(n2, n3, rectangle2.width, rectangle2.height);
            } else {
                gC.setForeground(color);
                gC.drawRectangle(n2, n3, rectangle2.width - 1, rectangle2.height - 1);
            }
            ++n;
        }
    }

    @Override
    public void paint(GC gC, boolean bl, Hashtable hashtable, boolean bl2, SelectionData selectionData, Rectangle rectangle) {
        this.paint(gC, bl, hashtable, bl2, false, selectionData, rectangle);
    }

    protected void paint(GC gC, boolean bl, Hashtable hashtable, boolean bl2, boolean bl3, SelectionData selectionData, Rectangle rectangle) {
        FontMetrics fontMetrics;
        Font font = null;
        Color color = null;
        Color color2 = null;
        if (this.fontId != null) {
            font = gC.getFont();
            fontMetrics = (Font)hashtable.get(this.fontId);
            if (fontMetrics != null) {
                gC.setFont((Font)fontMetrics);
            }
        }
        if (!bl && this.colorId != null) {
            color = gC.getForeground();
            fontMetrics = (Color)hashtable.get(this.colorId);
            if (fontMetrics != null) {
                gC.setForeground((Color)fontMetrics);
            }
        }
        color2 = gC.getBackground();
        fontMetrics = gC.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getDescent();
        int n3 = 0;
        while (n3 < this.areaRectangles.size()) {
            AreaRectangle areaRectangle = (AreaRectangle)this.areaRectangles.get(n3);
            Rectangle rectangle2 = areaRectangle.rect;
            String string = areaRectangle.getText();
            Point point = gC.textExtent(string);
            int n4 = rectangle2.x + (this.isSelectable() ? 1 : 0);
            int n5 = rectangle2.y + n - n2 + 1;
            this.paintString(gC, string, point.x, n4, rectangle2.y, n5, selectionData, rectangle2, bl, bl3, rectangle);
            if (bl2) {
                int n6 = rectangle2.x;
                int n7 = rectangle2.y;
                if (rectangle != null) {
                    n6 -= rectangle.x;
                    n7 -= rectangle.y;
                }
                Color color3 = gC.getForeground();
                gC.setForeground(color2);
                gC.drawRectangle(n6, n7, rectangle2.width - 1, rectangle2.height - 1);
                gC.setForeground(color3);
                gC.drawFocus(n6, n7, rectangle2.width, rectangle2.height);
            }
            ++n3;
        }
        if (font != null) {
            gC.setFont(font);
        }
        if (color != null) {
            gC.setForeground(color);
        }
        if (color2 != null) {
            gC.setBackground(color2);
        }
    }

    @Override
    public void computeSelection(GC gC, Hashtable hashtable, SelectionData selectionData) {
        Font font = null;
        if (this.fontId != null) {
            font = gC.getFont();
            Font font2 = (Font)hashtable.get(this.fontId);
            if (font2 != null) {
                gC.setFont(font2);
            }
        }
        int n = 0;
        while (n < this.areaRectangles.size()) {
            AreaRectangle areaRectangle = (AreaRectangle)this.areaRectangles.get(n);
            Rectangle rectangle = areaRectangle.rect;
            String string = areaRectangle.getText();
            Point point = gC.textExtent(string);
            this.computeSelection(gC, string, point.x, selectionData, rectangle);
            ++n;
        }
        if (font != null) {
            gC.setFont(font);
        }
    }

    private void paintString(GC gC, String string, int n, int n2, int n3, int n4, SelectionData selectionData, Rectangle rectangle, boolean bl, boolean bl2, Rectangle rectangle2) {
        if (selectionData != null && selectionData.isEnclosed()) {
            int n5;
            Color color = gC.getBackground();
            Color color2 = gC.getForeground();
            int n6 = selectionData.getLeftOffset(rectangle.height);
            int n7 = selectionData.getRightOffset(rectangle.height);
            boolean bl3 = selectionData.isFirstSelectionRow(rectangle.y, rectangle.height);
            boolean bl4 = selectionData.isLastSelectionRow(rectangle.y, rectangle.height);
            boolean bl5 = selectionData.isSelectedRow(rectangle.y, rectangle.height);
            int n8 = -1;
            int n9 = -1;
            if (bl3 && n2 + n < n6 || bl4 && n2 > n7) {
                this.paintStringSegment(gC, string, gC.textExtent((String)string).x, n2, n3, n4, bl, bl2, rectangle2);
                return;
            }
            if (bl3 && rectangle.x + n > n6) {
                n8 = this.convertOffsetToStringIndex(gC, string, rectangle.x, n, n6);
            }
            if (bl4 && rectangle.x + n > n7) {
                n9 = this.convertOffsetToStringIndex(gC, string, rectangle.x, n, n7);
            }
            if (bl3 && n8 != -1) {
                String string2 = string.substring(0, n8);
                n5 = gC.textExtent((String)string2).x;
                this.paintStringSegment(gC, string2, n5, n2, n3, n4, bl, bl2, rectangle2);
                n2 += n5;
            }
            if (bl5) {
                int n10 = n8 != -1 ? n8 : 0;
                n5 = n9 != -1 ? n9 : string.length();
                String string3 = string.substring(n10, n5);
                Point point = gC.textExtent(string3);
                gC.setForeground(selectionData.fg);
                gC.setBackground(selectionData.bg);
                gC.fillRectangle(n2, n3, point.x, point.y);
                this.paintStringSegment(gC, string3, point.x, n2, n3, n4, bl, bl2, rectangle2);
                n2 += point.x;
                gC.setForeground(color2);
                gC.setBackground(color);
            } else {
                this.paintStringSegment(gC, string, gC.textExtent((String)string).x, n2, n3, n4, bl, bl2, rectangle2);
            }
            if (bl4 && n9 != -1) {
                String string4 = string.substring(n9);
                this.paintStringSegment(gC, string4, gC.textExtent((String)string4).x, n2, n3, n4, bl, bl2, rectangle2);
            }
        } else {
            this.paintStringSegment(gC, string, gC.textExtent((String)string).x, n2, n3, n4, bl, bl2, rectangle2);
        }
    }

    private void computeSelection(GC gC, String string, int n, SelectionData selectionData, Rectangle rectangle) {
        int n2;
        int n3;
        String string2;
        int n4 = selectionData.getLeftOffset(rectangle.height);
        int n5 = selectionData.getRightOffset(rectangle.height);
        boolean bl = selectionData.isFirstSelectionRow(rectangle.y, rectangle.height);
        boolean bl2 = selectionData.isLastSelectionRow(rectangle.y, rectangle.height);
        boolean bl3 = selectionData.isSelectedRow(rectangle.y, rectangle.height);
        int n6 = -1;
        int n7 = -1;
        if (bl && rectangle.x < n4) {
            n6 = this.convertOffsetToStringIndex(gC, string, rectangle.x, n, n4);
        }
        if (bl2 && rectangle.x + n > n5) {
            n7 = this.convertOffsetToStringIndex(gC, string, rectangle.x, n, n5);
        }
        if (bl3 && (string2 = string.substring(n3 = n6 != -1 ? n6 : 0, n2 = n7 != -1 ? n7 : string.length())).length() > 0) {
            selectionData.addSegment(string2);
        }
    }

    private void paintStringSegment(GC gC, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, Rectangle rectangle) {
        boolean bl3 = false;
        int n5 = n2;
        int n6 = n3;
        int n7 = n4;
        if (rectangle != null) {
            n5 -= rectangle.x;
            n6 -= rectangle.y;
            n7 -= rectangle.y;
        }
        if (bl2 && !bl) {
            bl3 = true;
        }
        if (bl3) {
            this.drawUnderline(gC, n, n5, n7, bl, bl2);
            this.drawText(gC, string, n5, n6);
        } else {
            this.drawText(gC, string, n5, n6);
            this.drawUnderline(gC, n, n5, n7, bl, bl2);
        }
    }

    protected void drawText(GC gC, String string, int n, int n2) {
        gC.drawText(string, n, n2, true);
    }

    private void drawUnderline(GC gC, int n, int n2, int n3, boolean bl, boolean bl2) {
        if (this.underline || bl2) {
            Color color = null;
            if (bl2 && !bl) {
                color = gC.getForeground();
                gC.setForeground(gC.getBackground());
            }
            gC.drawLine(n2, n3, n2 + n - 1, n3);
            if (color != null) {
                gC.setForeground(color);
            }
        }
    }

    @Override
    public void layout(GC gC, int n, Locator locator, Hashtable hashtable, boolean bl) {
        FontMetrics fontMetrics;
        Font font = null;
        this.areaRectangles.clear();
        if (this.fontId != null) {
            font = gC.getFont();
            fontMetrics = (Font)hashtable.get(this.fontId);
            if (fontMetrics != null) {
                gC.setFont((Font)fontMetrics);
            }
        }
        fontMetrics = gC.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.getDescent();
        if (!this.wrapAllowed) {
            this.layoutWithoutWrapping(gC, n, locator, bl, fontMetrics, n2, n3);
        } else {
            int n4 = 0;
            short s = 0;
            Point point = new Point(0, 0);
            this.computeTextFragments(gC);
            int n5 = n - locator.marginWidth;
            int n6 = 0;
            while (n6 < this.textFragments.length) {
                TextFragment textFragment = this.textFragments[n6];
                short s2 = textFragment.index;
                if (s2 != 0) {
                    if ((n6 != 0 || locator.x > locator.getStartX() + (this.isSelectable() ? 1 : 0)) && locator.x + point.x + textFragment.length > n5) {
                        if (n6 != 0) {
                            int n7 = locator.getBaseline(n2 - fontMetrics.getLeading());
                            Rectangle rectangle = new Rectangle(this.isSelectable() ? locator.x - 1 : locator.x, n7, this.isSelectable() ? point.x + 1 : point.x, n2 - n3 + 3);
                            this.areaRectangles.add(new AreaRectangle(rectangle, n4, s));
                        }
                        locator.rowHeight = Math.max(locator.rowHeight, point.y);
                        locator.resetCaret();
                        if (this.isSelectable()) {
                            ++locator.x;
                        }
                        locator.y += locator.rowHeight;
                        ++locator.rowCounter;
                        locator.rowHeight = 0;
                        n4 = s;
                        point.x = 0;
                        point.y = 0;
                    }
                    s = s2;
                    point.x += textFragment.length;
                    point.y = Math.max(n2, point.y);
                }
                ++n6;
            }
            n6 = locator.getBaseline(n2 - fontMetrics.getLeading());
            int n8 = point.x;
            if (this.isSelectable()) {
                ++n8;
            }
            Rectangle rectangle = new Rectangle(this.isSelectable() ? locator.x - 1 : locator.x, n6, this.isSelectable() ? point.x + 1 : point.x, n2 - n3 + 3);
            this.areaRectangles.add(new AreaRectangle(rectangle, n4, s));
            locator.x += n8;
            locator.rowHeight = Math.max(locator.rowHeight, point.y);
        }
        if (font != null) {
            gC.setFont(font);
        }
    }

    private void computeTextFragments(GC gC) {
        if (this.textFragments != null) {
            return;
        }
        ArrayList<TextFragment> arrayList = new ArrayList<TextFragment>();
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(this.getText());
        int n = 0;
        int n2 = breakIterator.first();
        while (n2 != -1) {
            if (n2 != 0) {
                String string = this.text.substring(n, n2);
                Point point = gC.textExtent(string);
                arrayList.add(new TextFragment((short)n2, (short)point.x));
                n = n2;
            }
            n2 = breakIterator.next();
        }
        this.textFragments = arrayList.toArray(new TextFragment[arrayList.size()]);
    }

    @Override
    public void clearCache(String string) {
        if (string == null && (this.fontId == null || this.fontId.equals("f.____bold"))) {
            this.textFragments = null;
        } else if (string != null && this.fontId != null && string.equals(this.fontId)) {
            this.textFragments = null;
        }
    }

    class AreaRectangle {
        Rectangle rect;
        int from;
        int to;

        public AreaRectangle(Rectangle rectangle, int n, int n2) {
            this.rect = rectangle;
            this.from = n;
            this.to = n2;
        }

        public boolean contains(int n, int n2) {
            return this.rect.contains(n, n2);
        }

        public boolean intersects(Rectangle rectangle) {
            return this.rect.intersects(rectangle);
        }

        public String getText() {
            if (this.from == 0 && this.to == -1) {
                return TextSegment.this.getText();
            }
            if (this.from > 0 && this.to == -1) {
                return TextSegment.this.getText().substring(this.from);
            }
            return TextSegment.this.getText().substring(this.from, this.to);
        }
    }

    static class SelectionRange {
        public int start;
        public int stop;

        public SelectionRange() {
            this.reset();
        }

        public void reset() {
            this.start = -1;
            this.stop = -1;
        }
    }

    static class TextFragment {
        short index;
        short length;

        public TextFragment(short s, short s2) {
            this.index = s;
            this.length = s2;
        }
    }
}

