/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.ArrayList;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.Locator;

public class SelectionData {
    public Display display;
    public Color bg;
    public Color fg;
    private Point start;
    private Point stop;
    private ArrayList segments;
    private boolean newLineNeeded;

    public SelectionData(MouseEvent mouseEvent) {
        this.display = mouseEvent.display;
        this.segments = new ArrayList();
        this.start = new Point(mouseEvent.x, mouseEvent.y);
        this.stop = new Point(mouseEvent.x, mouseEvent.y);
        this.bg = mouseEvent.display.getSystemColor(26);
        this.fg = mouseEvent.display.getSystemColor(27);
    }

    public void markNewLine() {
        this.newLineNeeded = true;
    }

    public void addSegment(String string) {
        if (this.newLineNeeded) {
            this.segments.add(System.getProperty("line.separator"));
            this.newLineNeeded = false;
        }
        this.segments.add(string);
    }

    public void update(MouseEvent mouseEvent) {
        this.stop.x = mouseEvent.x;
        this.stop.y = mouseEvent.y;
    }

    public void reset() {
        this.segments.clear();
    }

    public String getSelectionText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.segments.size()) {
            stringBuffer.append((String)this.segments.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean canCopy() {
        return this.segments.size() > 0;
    }

    private int getTopOffset() {
        return this.start.y < this.stop.y ? this.start.y : this.stop.y;
    }

    private int getBottomOffset() {
        return this.start.y > this.stop.y ? this.start.y : this.stop.y;
    }

    public int getLeftOffset(Locator locator) {
        return this.isInverted(locator) ? this.stop.x : this.start.x;
    }

    public int getLeftOffset(int n) {
        return this.isInverted(n) ? this.stop.x : this.start.x;
    }

    public int getRightOffset(Locator locator) {
        return this.isInverted(locator) ? this.start.x : this.stop.x;
    }

    public int getRightOffset(int n) {
        return this.isInverted(n) ? this.start.x : this.stop.x;
    }

    private boolean isInverted(Locator locator) {
        int n = ((int[])locator.heights.get(locator.rowCounter))[0];
        return this.isInverted(n);
    }

    private boolean isInverted(int n) {
        int n2 = this.start.y - this.stop.y;
        if (Math.abs(n2) > n) {
            return n2 > 0;
        }
        return this.start.x > this.stop.x;
    }

    public boolean isEnclosed() {
        return !this.start.equals((Object)this.stop);
    }

    public boolean isSelectedRow(Locator locator) {
        if (!this.isEnclosed()) {
            return false;
        }
        int n = ((int[])locator.heights.get(locator.rowCounter))[0];
        return this.isSelectedRow(locator.y, n);
    }

    public boolean isSelectedRow(int n, int n2) {
        if (!this.isEnclosed()) {
            return false;
        }
        return n + n2 >= this.getTopOffset() && n <= this.getBottomOffset();
    }

    public boolean isFirstSelectionRow(Locator locator) {
        if (!this.isEnclosed()) {
            return false;
        }
        int n = ((int[])locator.heights.get(locator.rowCounter))[0];
        return locator.y + n >= this.getTopOffset() && locator.y <= this.getTopOffset();
    }

    public boolean isFirstSelectionRow(int n, int n2) {
        if (!this.isEnclosed()) {
            return false;
        }
        return n + n2 >= this.getTopOffset() && n <= this.getTopOffset();
    }

    public boolean isLastSelectionRow(Locator locator) {
        if (!this.isEnclosed()) {
            return false;
        }
        int n = ((int[])locator.heights.get(locator.rowCounter))[0];
        return locator.y + n >= this.getBottomOffset() && locator.y <= this.getBottomOffset();
    }

    public boolean isLastSelectionRow(int n, int n2) {
        if (!this.isEnclosed()) {
            return false;
        }
        return n + n2 >= this.getBottomOffset() && n <= this.getBottomOffset();
    }
}

