/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.SelectionData;
import org.eclipse.ui.internal.forms.widgets.TextHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.TextSegment;

public class Paragraph {
    public static final String[] PROTOCOLS = new String[]{"http://", "https://", "ftp://"};
    private Vector segments;
    private boolean addVerticalSpace = true;

    public Paragraph(boolean bl) {
        this.addVerticalSpace = bl;
    }

    public int getIndent() {
        return 0;
    }

    public boolean getAddVerticalSpace() {
        return this.addVerticalSpace;
    }

    public ParagraphSegment[] getSegments() {
        if (this.segments == null) {
            return new ParagraphSegment[0];
        }
        return this.segments.toArray(new ParagraphSegment[this.segments.size()]);
    }

    public void addSegment(ParagraphSegment paragraphSegment) {
        if (this.segments == null) {
            this.segments = new Vector();
        }
        this.segments.add(paragraphSegment);
    }

    public void parseRegularText(String string, boolean bl, boolean bl2, HyperlinkSettings hyperlinkSettings, String string2) {
        this.parseRegularText(string, bl, bl2, hyperlinkSettings, string2, null);
    }

    public void parseRegularText(String string, boolean bl, boolean bl2, HyperlinkSettings hyperlinkSettings, String string2, String string3) {
        if (string.length() == 0) {
            return;
        }
        if (bl) {
            int n = this.findUrl(string, 0);
            if (n == -1) {
                this.addSegment(new TextSegment(string, string2, string3, bl2));
            } else {
                int n2 = 0;
                while (n != -1) {
                    this.addSegment(new TextSegment(string.substring(n2, n), string2, string3, bl2));
                    boolean bl3 = false;
                    n2 = n;
                    while (n2 < string.length()) {
                        char c = string.charAt(n2);
                        if (Character.isSpaceChar(c)) {
                            this.addHyperlinkSegment(string.substring(n, n2), hyperlinkSettings, string2);
                            bl3 = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl3) {
                        this.addHyperlinkSegment(string.substring(n), hyperlinkSettings, string2);
                        break;
                    }
                    n = this.findUrl(string, n2);
                }
                if (n2 < string.length()) {
                    this.addSegment(new TextSegment(string.substring(n2), string2, string3, bl2));
                }
            }
        } else {
            this.addSegment(new TextSegment(string, string2, string3, bl2));
        }
    }

    private int findUrl(String string, int n) {
        int[] nArray = new int[PROTOCOLS.length];
        int n2 = 0;
        while (n2 < PROTOCOLS.length) {
            nArray[n2] = string.indexOf(PROTOCOLS[n2], n);
            ++n2;
        }
        Arrays.sort(nArray);
        n2 = 0;
        while (n2 < PROTOCOLS.length) {
            if (nArray[n2] != -1) {
                return nArray[n2];
            }
            ++n2;
        }
        return -1;
    }

    private void addHyperlinkSegment(String string, HyperlinkSettings hyperlinkSettings, String string2) {
        TextHyperlinkSegment textHyperlinkSegment = new TextHyperlinkSegment(string, hyperlinkSettings, string2);
        textHyperlinkSegment.setWordWrapAllowed(false);
        textHyperlinkSegment.setHref(string);
        this.addSegment(textHyperlinkSegment);
    }

    protected void computeRowHeights(GC gC, int n, Locator locator, int n2, Hashtable hashtable) {
        ArrayList arrayList;
        ParagraphSegment[] paragraphSegmentArray = this.getSegments();
        Locator locator2 = locator.create();
        locator2.heights = arrayList = new ArrayList();
        locator2.rowCounter = 0;
        int n3 = 0;
        while (n3 < paragraphSegmentArray.length) {
            ParagraphSegment paragraphSegment = paragraphSegmentArray[n3];
            paragraphSegment.advanceLocator(gC, n, locator2, hashtable, true);
            ++n3;
        }
        if (locator2.rowHeight == 0) {
            FontMetrics fontMetrics = gC.getFontMetrics();
            locator2.rowHeight = fontMetrics.getHeight();
        }
        locator2.collectHeights();
        locator.heights = arrayList;
        locator.rowCounter = 0;
    }

    public void layout(GC gC, int n, Locator locator, int n2, Hashtable hashtable, IHyperlinkSegment iHyperlinkSegment) {
        ParagraphSegment[] paragraphSegmentArray = this.getSegments();
        if (paragraphSegmentArray.length > 0) {
            if (locator.heights == null) {
                this.computeRowHeights(gC, n, locator, n2, hashtable);
            }
            int n3 = 0;
            while (n3 < paragraphSegmentArray.length) {
                ParagraphSegment paragraphSegment = paragraphSegmentArray[n3];
                boolean bl = false;
                if (iHyperlinkSegment != null && paragraphSegment.equals(iHyperlinkSegment)) {
                    bl = true;
                }
                paragraphSegment.layout(gC, n, locator, hashtable, bl);
                ++n3;
            }
            locator.heights = null;
            locator.y += locator.rowHeight;
        } else {
            locator.y += n2;
        }
    }

    public void paint(GC gC, Rectangle rectangle, Hashtable hashtable, IHyperlinkSegment iHyperlinkSegment, SelectionData selectionData) {
        ParagraphSegment[] paragraphSegmentArray = this.getSegments();
        int n = 0;
        while (n < paragraphSegmentArray.length) {
            ParagraphSegment paragraphSegment = paragraphSegmentArray[n];
            if (paragraphSegment.intersects(rectangle)) {
                boolean bl = false;
                if (iHyperlinkSegment != null && paragraphSegment.equals(iHyperlinkSegment)) {
                    bl = true;
                }
                paragraphSegment.paint(gC, false, hashtable, bl, selectionData, rectangle);
            }
            ++n;
        }
    }

    public void computeSelection(GC gC, Hashtable hashtable, IHyperlinkSegment iHyperlinkSegment, SelectionData selectionData) {
        ParagraphSegment[] paragraphSegmentArray = this.getSegments();
        int n = 0;
        while (n < paragraphSegmentArray.length) {
            ParagraphSegment paragraphSegment = paragraphSegmentArray[n];
            paragraphSegment.computeSelection(gC, hashtable, selectionData);
            ++n;
        }
    }

    public String getAccessibleText() {
        ParagraphSegment[] paragraphSegmentArray = this.getSegments();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = 0;
        while (n < paragraphSegmentArray.length) {
            ParagraphSegment paragraphSegment = paragraphSegmentArray[n];
            if (paragraphSegment instanceof TextSegment) {
                String string = ((TextSegment)paragraphSegment).getText();
                printWriter.print(string);
            }
            ++n;
        }
        printWriter.println();
        stringWriter.flush();
        return stringWriter.toString();
    }

    public ParagraphSegment findSegmentAt(int n, int n2) {
        if (this.segments != null) {
            int n3 = 0;
            while (n3 < this.segments.size()) {
                ParagraphSegment paragraphSegment = (ParagraphSegment)this.segments.get(n3);
                if (paragraphSegment.contains(n, n2)) {
                    return paragraphSegment;
                }
                ++n3;
            }
        }
        return null;
    }

    public void clearCache(String string) {
        if (this.segments != null) {
            int n = 0;
            while (n < this.segments.size()) {
                ParagraphSegment paragraphSegment = (ParagraphSegment)this.segments.get(n);
                paragraphSegment.clearCache(string);
                ++n;
            }
        }
    }
}

