/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Hashtable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.SelectionData;

public abstract class ObjectSegment
extends ParagraphSegment {
    public static final int TOP = 1;
    public static final int MIDDLE = 2;
    public static final int BOTTOM = 3;
    private int alignment = 3;
    private boolean nowrap = false;
    private Rectangle bounds;
    private String objectId;

    public int getVerticalAlignment() {
        return this.alignment;
    }

    void setVerticalAlignment(int n) {
        this.alignment = n;
    }

    public String getObjectId() {
        return this.objectId;
    }

    void setObjectId(String string) {
        this.objectId = string;
    }

    protected abstract Point getObjectSize(Hashtable var1, int var2);

    @Override
    public boolean advanceLocator(GC gC, int n, Locator locator, Hashtable hashtable, boolean bl) {
        Point point = this.getObjectSize(hashtable, n);
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        if (point != null) {
            n2 = point.x + (this.isSelectable() ? 2 : 0);
            n3 = point.y + (this.isSelectable() ? 2 : 0);
        }
        if (n != -1 && !this.nowrap && locator.x + n2 + locator.marginWidth > n) {
            if (bl) {
                locator.collectHeights();
            }
            locator.resetCaret();
            locator.x += n2;
            locator.y += locator.rowHeight;
            locator.width = locator.x;
            locator.rowHeight = n3;
            locator.leading = 0;
            bl2 = true;
        } else {
            locator.x += n2;
            locator.width += n2;
            locator.rowHeight = Math.max(locator.rowHeight, n3);
        }
        return bl2;
    }

    @Override
    public boolean contains(int n, int n2) {
        if (this.bounds == null) {
            return false;
        }
        return this.bounds.contains(n, n2);
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        if (this.bounds == null) {
            return false;
        }
        return this.bounds.intersects(rectangle);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isSelectable() {
        return false;
    }

    public boolean isNowrap() {
        return this.nowrap;
    }

    public void setNowrap(boolean bl) {
        this.nowrap = bl;
    }

    @Override
    public void paint(GC gC, boolean bl, Hashtable hashtable, boolean bl2, SelectionData selectionData, Rectangle rectangle) {
    }

    @Override
    public void layout(GC gC, int n, Locator locator, Hashtable hashtable, boolean bl) {
        Point point = this.getObjectSize(hashtable, n);
        int n2 = 0;
        int n3 = 0;
        if (point == null) {
            return;
        }
        n2 = point.x + (this.isSelectable() ? 2 : 0);
        n3 = point.y + (this.isSelectable() ? 2 : 0);
        locator.width = n2;
        if (!this.nowrap && locator.x + n2 + locator.marginWidth > n) {
            locator.newLine();
            ++locator.rowCounter;
        }
        int n4 = locator.x;
        int n5 = locator.y;
        if (this.alignment == 2) {
            n5 = locator.getMiddle(n3, false);
        } else if (this.alignment == 3) {
            n5 = locator.getBaseline(n3, false);
        }
        locator.x += n2;
        locator.rowHeight = Math.max(locator.rowHeight, n3);
        this.bounds = new Rectangle(n4, n5, n2, n3);
    }

    @Override
    public void computeSelection(GC gC, Hashtable hashtable, SelectionData selectionData) {
    }
}

