/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.ObjectSegment;
import org.eclipse.ui.internal.forms.widgets.SelectionData;

public class ImageSegment
extends ObjectSegment {
    public static final String SEL_IMAGE_PREFIX = "isel.";

    public Image getImage(Hashtable hashtable) {
        return this.getImage(this.getObjectId(), hashtable);
    }

    private Image getImage(String string, Hashtable hashtable) {
        if (string == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof Image) {
            return (Image)v;
        }
        return null;
    }

    private Image getSelectedImage(Hashtable hashtable, SelectionData selectionData) {
        String string = SEL_IMAGE_PREFIX + this.getObjectId();
        Image image = this.getImage(string, hashtable);
        if (image == null && (image = FormUtil.createAlphaMashImage((Device)selectionData.display, this.getImage(hashtable))) != null) {
            hashtable.put(string, image);
        }
        return image;
    }

    @Override
    public void paint(GC gC, boolean bl, Hashtable hashtable, boolean bl2, SelectionData selectionData, Rectangle rectangle) {
        int n;
        int n2;
        Image image = this.getImage(hashtable);
        int n3 = 0;
        int n4 = 0;
        if (image == null) {
            return;
        }
        Rectangle rectangle2 = image.getBounds();
        n3 = rectangle2.width + (this.isSelectable() ? 2 : 0);
        n4 = rectangle2.height + (this.isSelectable() ? 2 : 0);
        rectangle2 = this.getBounds();
        int n5 = rectangle2.x + (this.isSelectable() ? 1 : 0);
        int n6 = rectangle2.y + (this.isSelectable() ? 1 : 0);
        if (selectionData != null) {
            n2 = selectionData.getLeftOffset(rectangle2.height);
            n = selectionData.getRightOffset(rectangle2.height);
            boolean bl3 = selectionData.isFirstSelectionRow(rectangle2.y, rectangle2.height);
            boolean bl4 = selectionData.isLastSelectionRow(rectangle2.y, rectangle2.height);
            boolean bl5 = selectionData.isSelectedRow(rectangle2.y, rectangle2.height);
            if (bl5) {
                if (bl3 && n2 > n5 || bl4 && n < n5 + n3 / 2) {
                    this.drawClipImage(gC, image, n5, n6, rectangle);
                } else {
                    Color color = gC.getBackground();
                    gC.setBackground(selectionData.bg);
                    int n7 = n5;
                    int n8 = n6;
                    if (rectangle != null) {
                        n7 -= rectangle.x;
                        n8 -= rectangle.y;
                    }
                    gC.fillRectangle(n7, n8, n3, n4);
                    Image image2 = this.getSelectedImage(hashtable, selectionData);
                    gC.drawImage(image2, n7, n8);
                    gC.setBackground(color);
                }
            } else {
                this.drawClipImage(gC, image, n5, n6, rectangle);
            }
        } else {
            this.drawClipImage(gC, image, n5, n6, rectangle);
        }
        if (bl2) {
            n2 = rectangle2.x;
            n = rectangle2.y;
            if (rectangle != null) {
                n2 -= rectangle.x;
                n -= rectangle.y;
            }
            Color color = gC.getForeground();
            gC.setForeground(gC.getBackground());
            gC.drawRectangle(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            gC.setForeground(color);
            gC.drawFocus(n2, n, rectangle2.width, rectangle2.height);
        }
    }

    private void drawClipImage(GC gC, Image image, int n, int n2, Rectangle rectangle) {
        if (rectangle != null) {
            n -= rectangle.x;
            n2 -= rectangle.y;
        }
        gC.drawImage(image, n, n2);
    }

    @Override
    protected Point getObjectSize(Hashtable hashtable, int n) {
        Image image = this.getImage(hashtable);
        if (image == null) {
            return new Point(0, 0);
        }
        Rectangle rectangle = image.getBounds();
        return new Point(rectangle.width, rectangle.height);
    }
}

