/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import com.ibm.icu.text.BreakIterator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ILayoutExtension;

public class FormUtil {
    public static final String PLUGIN_ID = "org.eclipse.ui.forms";
    static final int H_SCROLL_INCREMENT = 5;
    static final int V_SCROLL_INCREMENT = 64;
    public static final String DEBUG = "org.eclipse.ui.forms/debug";
    public static final String DEBUG_TEXT = "org.eclipse.ui.forms/debug/text";
    public static final String DEBUG_TEXTSIZE = "org.eclipse.ui.forms/debug/textsize";
    public static final String DEBUG_FOCUS = "org.eclipse.ui.forms/debug/focus";
    public static final String FOCUS_SCROLLING = "focusScrolling";
    public static final String IGNORE_BODY = "__ignore_body__";

    public static Text createText(Composite composite, String string, FormToolkit formToolkit) {
        return FormUtil.createText(composite, string, formToolkit, 1);
    }

    public static Text createText(Composite composite, String string, FormToolkit formToolkit, int n) {
        formToolkit.createLabel(composite, string);
        Text text = formToolkit.createText(composite, "");
        int n2 = n == 1 ? 768 : 256;
        GridData gridData = new GridData(n2 | 4);
        gridData.horizontalSpan = n;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static Text createText(Composite composite, String string, FormToolkit formToolkit, int n, int n2) {
        GridData gridData;
        Label label = formToolkit.createLabel(composite, string);
        if ((n2 & 2) != 0) {
            gridData = new GridData(2);
            label.setLayoutData((Object)gridData);
        }
        gridData = formToolkit.createText(composite, "", n2);
        int n3 = n == 1 ? 768 : 256;
        GridData gridData2 = new GridData(n3 | 4);
        gridData2.horizontalSpan = n;
        gridData.setLayoutData((Object)gridData2);
        return gridData;
    }

    public static Text createText(Composite composite, FormToolkit formToolkit, int n) {
        Text text = formToolkit.createText(composite, "");
        int n2 = n == 1 ? 768 : 256;
        GridData gridData = new GridData(n2 | 4);
        gridData.horizontalSpan = n;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static int computeMinimumWidth(GC gC, String string) {
        String string2;
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n = 0;
        int n2 = 0;
        int n3 = breakIterator.first();
        while (n3 != -1) {
            string2 = string.substring(n, n3);
            Point point = gC.textExtent(string2);
            n2 = Math.max(n2, point.x);
            n = n3;
            n3 = breakIterator.next();
        }
        String string3 = string.substring(n);
        string2 = gC.textExtent(string3);
        n2 = Math.max(n2, ((Point)string2).x);
        return n2;
    }

    public static Point computeWrapSize(GC gC, String string, int n) {
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = 0;
        int n4 = 0;
        int n5 = n2;
        int n6 = 0;
        int n7 = breakIterator.first();
        while (n7 != -1) {
            String string2 = string.substring(n3, n7);
            Point point = gC.textExtent(string2);
            if (point.x > n) {
                n3 = n4;
                n5 += point.y;
                string2 = string.substring(n4, n7);
                point = gC.textExtent(string2);
            }
            n6 = Math.max(n6, point.x);
            n4 = n7;
            n7 = breakIterator.next();
        }
        if (n6 > n) {
            return FormUtil.computeWrapSize(gC, string, n6);
        }
        return new Point(n6, n5);
    }

    public static void paintWrapText(GC gC, String string, Rectangle rectangle) {
        FormUtil.paintWrapText(gC, string, rectangle, false);
    }

    public static void paintWrapText(GC gC, String string, Rectangle rectangle, boolean bl) {
        Point point;
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getDescent();
        int n3 = 0;
        int n4 = 0;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = breakIterator.first();
        while (n7 != -1) {
            String string2 = string.substring(n3, n7);
            point = gC.textExtent(string2);
            if (point.x > n6) {
                String string3 = string.substring(n3, n4);
                gC.drawText(string3, rectangle.x, n5, true);
                if (bl) {
                    Point point2 = gC.textExtent(string3);
                    int n8 = n5 + n - n2 + 1;
                    gC.drawLine(rectangle.x, n8, rectangle.x + point2.x, n8);
                }
                n3 = n4;
                n5 += n;
            }
            n4 = n7;
            n7 = breakIterator.next();
        }
        String string4 = string.substring(n3, n4);
        gC.drawText(string4, rectangle.x, n5, true);
        if (bl) {
            int n9 = n5 + n - n2 + 1;
            point = gC.textExtent(string4);
            gC.drawLine(rectangle.x, n9, rectangle.x + point.x, n9);
        }
    }

    public static ScrolledComposite getScrolledComposite(Control control) {
        Composite composite = control.getParent();
        while (composite != null) {
            if (composite instanceof ScrolledComposite) {
                return (ScrolledComposite)composite;
            }
            composite = composite.getParent();
        }
        return null;
    }

    public static void ensureVisible(Control control) {
        Object object;
        ScrolledComposite scrolledComposite = FormUtil.getScrolledComposite(control);
        if (!(scrolledComposite == null || (object = scrolledComposite.getData(FOCUS_SCROLLING)) != null && object.equals(Boolean.FALSE))) {
            FormUtil.ensureVisible(scrolledComposite, control);
        }
    }

    public static void ensureVisible(ScrolledComposite scrolledComposite, Control control) {
        if (control instanceof FormText) {
            return;
        }
        Point point = control.getSize();
        Point point2 = FormUtil.getControlLocation(scrolledComposite, control);
        FormUtil.ensureVisible(scrolledComposite, point2, point);
    }

    public static void ensureVisible(ScrolledComposite scrolledComposite, Point point, Point point2) {
        Rectangle rectangle = scrolledComposite.getClientArea();
        Point point3 = scrolledComposite.getOrigin();
        int n = point3.x;
        int n2 = point3.y;
        if (point2.x < rectangle.width && point.x + point2.x > point3.x + rectangle.width) {
            n = point.x + point2.x - rectangle.width;
        }
        if (point.x < n) {
            n = point2.x < rectangle.width ? point.x + point2.x - rectangle.width : point.x;
        }
        if (point2.y < rectangle.height && point.y + point2.y > point3.y + rectangle.height) {
            n2 = point.y + point2.y - rectangle.height;
        }
        if (point.y < n2) {
            n2 = point2.y < rectangle.height ? point.y + point2.y - rectangle.height : point.y;
        }
        if (point3.x != n || point3.y != n2) {
            scrolledComposite.setOrigin(n, n2);
        }
    }

    public static void ensureVisible(ScrolledComposite scrolledComposite, Control control, MouseEvent mouseEvent) {
        Point point = FormUtil.getControlLocation(scrolledComposite, control);
        int n = point.x + mouseEvent.x;
        int n2 = point.y + mouseEvent.y;
        Rectangle rectangle = scrolledComposite.getClientArea();
        Point point2 = scrolledComposite.getOrigin();
        int n3 = point2.x;
        int n4 = point2.y;
        if (n > point2.x + rectangle.width) {
            n3 = n - rectangle.width;
        } else if (n < n3) {
            n3 = n;
        }
        if (n2 > point2.y + rectangle.height) {
            n4 = n2 - rectangle.height;
        } else if (n2 < n4) {
            n4 = n2;
        }
        if (point2.x != n3 || point2.y != n4) {
            scrolledComposite.setOrigin(n3, n4);
        }
    }

    public static Point getControlLocation(ScrolledComposite scrolledComposite, Control control) {
        int n = 0;
        int n2 = 0;
        Control control2 = scrolledComposite.getContent();
        for (Control control3 = control; control3 != control2; control3 = control3.getParent()) {
            Point point = control3.getLocation();
            n += point.x;
            n2 += point.y;
        }
        return new Point(n, n2);
    }

    static void scrollVertical(ScrolledComposite scrolledComposite, boolean bl) {
        FormUtil.scroll(scrolledComposite, 0, bl ? -64 : 64);
    }

    static void scrollHorizontal(ScrolledComposite scrolledComposite, boolean bl) {
        FormUtil.scroll(scrolledComposite, bl ? -5 : 5, 0);
    }

    static void scrollPage(ScrolledComposite scrolledComposite, boolean bl) {
        Rectangle rectangle = scrolledComposite.getClientArea();
        int n = bl ? -rectangle.height : rectangle.height;
        FormUtil.scroll(scrolledComposite, 0, n);
    }

    static void scroll(ScrolledComposite scrolledComposite, int n, int n2) {
        Point point = scrolledComposite.getOrigin();
        Point point2 = scrolledComposite.getContent().getSize();
        int n3 = point.x + n;
        int n4 = point.y + n2;
        n3 = Math.max(n3, 0);
        n3 = Math.min(n3, point2.x - 1);
        n4 = Math.max(n4, 0);
        n4 = Math.min(n4, point2.y - 1);
        scrolledComposite.setOrigin(n3, n4);
    }

    public static void updatePageIncrement(ScrolledComposite scrolledComposite) {
        Rectangle rectangle;
        ScrollBar scrollBar = scrolledComposite.getVerticalBar();
        if (scrollBar != null) {
            rectangle = scrolledComposite.getClientArea();
            int n = rectangle.height - 5;
            scrollBar.setPageIncrement(n);
        }
        if ((rectangle = scrolledComposite.getHorizontalBar()) != null) {
            Rectangle rectangle2 = scrolledComposite.getClientArea();
            int n = rectangle2.width - 5;
            rectangle.setPageIncrement(n);
        }
    }

    public static void processKey(int n, Control control) {
        if (control.isDisposed()) {
            return;
        }
        ScrolledComposite scrolledComposite = FormUtil.getScrolledComposite(control);
        if (scrolledComposite != null) {
            if (control instanceof Combo) {
                return;
            }
            switch (n) {
                case 0x1000002: {
                    if (scrolledComposite.getData("novarrows") != null) break;
                    FormUtil.scrollVertical(scrolledComposite, false);
                    break;
                }
                case 0x1000001: {
                    if (scrolledComposite.getData("novarrows") != null) break;
                    FormUtil.scrollVertical(scrolledComposite, true);
                    break;
                }
                case 0x1000003: {
                    FormUtil.scrollHorizontal(scrolledComposite, true);
                    break;
                }
                case 0x1000004: {
                    FormUtil.scrollHorizontal(scrolledComposite, false);
                    break;
                }
                case 0x1000005: {
                    FormUtil.scrollPage(scrolledComposite, true);
                    break;
                }
                case 0x1000006: {
                    FormUtil.scrollPage(scrolledComposite, false);
                }
            }
        }
    }

    public static boolean isWrapControl(Control control) {
        if ((control.getStyle() & 0x40) != 0) {
            return true;
        }
        if (control instanceof Composite) {
            return ((Composite)control).getLayout() instanceof ILayoutExtension;
        }
        return false;
    }

    public static int getWidthHint(int n, Control control) {
        boolean bl = FormUtil.isWrapControl(control);
        return bl ? n : -1;
    }

    public static int getHeightHint(int n, Control control) {
        Layout layout;
        if (control instanceof Composite && (layout = ((Composite)control).getLayout()) instanceof ColumnLayout) {
            return n;
        }
        return -1;
    }

    public static int computeMinimumWidth(Control control, boolean bl) {
        Layout layout;
        if (control instanceof Composite && (layout = ((Composite)control).getLayout()) instanceof ILayoutExtension) {
            return ((ILayoutExtension)layout).computeMinimumWidth((Composite)control, bl);
        }
        return control.computeSize((int)FormUtil.getWidthHint((int)5, (Control)control), (int)-1, (boolean)bl).x;
    }

    public static int computeMaximumWidth(Control control, boolean bl) {
        Layout layout;
        if (control instanceof Composite && (layout = ((Composite)control).getLayout()) instanceof ILayoutExtension) {
            return ((ILayoutExtension)layout).computeMaximumWidth((Composite)control, bl);
        }
        return control.computeSize((int)-1, (int)-1, (boolean)bl).x;
    }

    public static Form getForm(Control control) {
        Composite composite = control.getParent();
        while (composite != null) {
            if (composite instanceof Form) {
                return (Form)composite;
            }
            composite = composite.getParent();
        }
        return null;
    }

    public static Image createAlphaMashImage(Device device, Image image) {
        Rectangle rectangle = image.getBounds();
        int n = 0;
        int n2 = 0;
        ImageData imageData = image.getImageData();
        int n3 = 0;
        while (n3 < rectangle.height) {
            n = n2;
            int n4 = 0;
            while (n4 < rectangle.width) {
                imageData.setAlpha(n4, n3, n);
                n = n == 255 ? 0 : 255;
                ++n4;
            }
            n2 = n2 == 255 ? 0 : 255;
            ++n3;
        }
        return new Image(device, imageData);
    }

    public static boolean mnemonicMatch(String string, char c) {
        char c2 = FormUtil.findMnemonic(string);
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    private static char findMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return string.charAt(n);
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    public static void setFocusScrollingEnabled(Control control, boolean bl) {
        ScrolledComposite scrolledComposite = null;
        scrolledComposite = control instanceof ScrolledComposite ? (ScrolledComposite)control : FormUtil.getScrolledComposite(control);
        if (scrolledComposite != null) {
            scrolledComposite.setData(FOCUS_SCROLLING, (Object)(bl ? null : Boolean.FALSE));
        }
    }

    public static void setAntialias(GC gC, int n) {
        if (!gC.getAdvanced()) {
            gC.setAdvanced(true);
            if (!gC.getAdvanced()) {
                return;
            }
        }
        gC.setAntialias(n);
    }
}

