/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.swt.SWT;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.internal.forms.widgets.AggregateHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.BreakSegment;
import org.eclipse.ui.internal.forms.widgets.BulletParagraph;
import org.eclipse.ui.internal.forms.widgets.ControlSegment;
import org.eclipse.ui.internal.forms.widgets.IFocusSelectable;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.ImageHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.ImageSegment;
import org.eclipse.ui.internal.forms.widgets.ObjectSegment;
import org.eclipse.ui.internal.forms.widgets.Paragraph;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.SWTUtil;
import org.eclipse.ui.internal.forms.widgets.TextHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.TextSegment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FormTextModel {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private boolean whitespaceNormalized = true;
    private Vector paragraphs;
    private IFocusSelectable[] selectableSegments;
    private int selectedSegmentIndex = -1;
    private int savedSelectedLinkIndex = -1;
    private HyperlinkSettings hyperlinkSettings;
    public static final String BOLD_FONT_ID = "f.____bold";

    public FormTextModel() {
        this.reset();
    }

    public Paragraph[] getParagraphs() {
        if (this.paragraphs == null) {
            return new Paragraph[0];
        }
        return this.paragraphs.toArray(new Paragraph[this.paragraphs.size()]);
    }

    public String getAccessibleText() {
        if (this.paragraphs == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.paragraphs.size()) {
            Paragraph paragraph = (Paragraph)this.paragraphs.get(n);
            String string = paragraph.getAccessibleText();
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void parseTaggedText(String string, boolean bl) {
        if (string == null) {
            this.reset();
            return;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
            this.parseInputStream(byteArrayInputStream, bl);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SWT.error((int)42, (Throwable)unsupportedEncodingException);
        }
    }

    public void parseInputStream(InputStream inputStream, boolean bl) {
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringComments(true);
        this.reset();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ParseErrorHandler());
            InputSource inputSource = new InputSource(inputStream);
            Document document = documentBuilder.parse(inputSource);
            this.processDocument(document, bl);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SWT.error((int)5, (Throwable)parserConfigurationException, (String)(" " + parserConfigurationException.getMessage()));
        }
        catch (SAXException sAXException) {
            SWT.error((int)5, (Throwable)sAXException, (String)(" " + sAXException.getMessage()));
        }
        catch (IOException iOException) {
            SWT.error((int)39, (Throwable)iOException);
        }
    }

    private void processDocument(Document document, boolean bl) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        this.processSubnodes(this.paragraphs, nodeList, bl);
    }

    private void processSubnodes(Vector vector, NodeList nodeList, boolean bl) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Paragraph paragraph;
            String string;
            Node node = nodeList.item(n);
            if (node.getNodeType() == 3) {
                string = this.getSingleNodeText(node);
                if (string != null && !this.isIgnorableWhiteSpace(string, true)) {
                    paragraph = new Paragraph(true);
                    paragraph.parseRegularText(string, bl, true, this.getHyperlinkSettings(), null);
                    vector.add(paragraph);
                }
            } else if (node.getNodeType() == 1) {
                string = node.getNodeName().toLowerCase();
                if (string.equals("p")) {
                    paragraph = this.processParagraph(node, bl);
                    if (paragraph != null) {
                        vector.add(paragraph);
                    }
                } else if (string.equals("li") && (paragraph = this.processListItem(node, bl)) != null) {
                    vector.add(paragraph);
                }
            }
            ++n;
        }
    }

    private Paragraph processParagraph(Node node, boolean bl) {
        Object object;
        NodeList nodeList = node.getChildNodes();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("addVerticalSpace");
        boolean bl2 = true;
        if (node2 == null) {
            node2 = namedNodeMap.getNamedItem("vspace");
        }
        if (node2 != null) {
            object = node2.getNodeValue();
            bl2 = ((String)object).equalsIgnoreCase("true");
        }
        object = new Paragraph(bl2);
        this.processSegments((Paragraph)object, nodeList, bl);
        return object;
    }

    private Paragraph processListItem(Node node, boolean bl) {
        Object object;
        NodeList nodeList = node.getChildNodes();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("addVerticalSpace");
        Node node3 = namedNodeMap.getNamedItem("style");
        Node node4 = namedNodeMap.getNamedItem("value");
        Node node5 = namedNodeMap.getNamedItem("indent");
        Node node6 = namedNodeMap.getNamedItem("bindent");
        int n = 1;
        int n2 = -1;
        int n3 = -1;
        String string = null;
        boolean bl2 = true;
        if (node2 != null) {
            object = node2.getNodeValue();
            bl2 = ((String)object).equalsIgnoreCase("true");
        }
        if (node3 != null) {
            object = node3.getNodeValue();
            if (((String)object).equalsIgnoreCase("text")) {
                n = 2;
            } else if (((String)object).equalsIgnoreCase("image")) {
                n = 3;
            } else if (((String)object).equalsIgnoreCase("bullet")) {
                n = 1;
            }
        }
        if (node4 != null) {
            string = node4.getNodeValue();
            if (n == 3) {
                string = "i." + string;
            }
        }
        if (node5 != null) {
            object = node5.getNodeValue();
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (node6 != null) {
            object = node6.getNodeValue();
            try {
                n3 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        object = new BulletParagraph(bl2);
        ((BulletParagraph)object).setIndent(n2);
        ((BulletParagraph)object).setBulletIndent(n3);
        ((BulletParagraph)object).setBulletStyle(n);
        ((BulletParagraph)object).setBulletText(string);
        this.processSegments((Paragraph)object, nodeList, bl);
        return object;
    }

    private void processSegments(Paragraph paragraph, NodeList nodeList, boolean bl) {
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            Node node = nodeList.item(n);
            ParagraphSegment paragraphSegment = null;
            if (node.getNodeType() == 3) {
                string = this.getSingleNodeText(node);
                if (string != null && !this.isIgnorableWhiteSpace(string, false)) {
                    paragraph.parseRegularText(string, bl, true, this.getHyperlinkSettings(), null);
                }
            } else if (node.getNodeType() == 1) {
                string = node.getNodeName();
                if (string.equalsIgnoreCase("img")) {
                    paragraphSegment = this.processImageSegment(node);
                } else if (string.equalsIgnoreCase("a")) {
                    paragraphSegment = this.processHyperlinkSegment(node, this.getHyperlinkSettings());
                } else if (string.equalsIgnoreCase("span")) {
                    this.processTextSegment(paragraph, bl, node);
                } else if (string.equalsIgnoreCase("b")) {
                    String string2 = this.getNodeText(node);
                    String string3 = BOLD_FONT_ID;
                    paragraph.parseRegularText(string2, bl, true, this.getHyperlinkSettings(), string3);
                } else if (string.equalsIgnoreCase("br")) {
                    paragraphSegment = new BreakSegment();
                } else if (string.equalsIgnoreCase("control")) {
                    paragraphSegment = this.processControlSegment(node);
                }
            }
            if (paragraphSegment != null) {
                paragraph.addSegment(paragraphSegment);
            }
            ++n;
        }
    }

    private boolean isIgnorableWhiteSpace(String string, boolean bl) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(bl && c == ' ' || c == '\n' || c == '\r' || c == '\f')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private ImageSegment processImageSegment(Node node) {
        ImageSegment imageSegment = new ImageSegment();
        this.processObjectSegment(imageSegment, node, "i.");
        return imageSegment;
    }

    private ControlSegment processControlSegment(Node node) {
        Object object;
        ControlSegment controlSegment = new ControlSegment();
        this.processObjectSegment(controlSegment, node, "o.");
        Node node2 = node.getAttributes().getNamedItem("fill");
        if (node2 != null) {
            object = node2.getNodeValue();
            boolean bl = ((String)object).equalsIgnoreCase("true");
            controlSegment.setFill(bl);
        }
        try {
            Node node3;
            object = node.getAttributes().getNamedItem("width");
            if (object != null) {
                String string = object.getNodeValue();
                int n = Integer.parseInt(string);
                controlSegment.setWidth(n);
            }
            if ((node3 = node.getAttributes().getNamedItem("height")) != null) {
                String string = node3.getNodeValue();
                int n = Integer.parseInt(string);
                controlSegment.setHeight(n);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return controlSegment;
    }

    private void processObjectSegment(ObjectSegment objectSegment, Node node, String string) {
        String string2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("href");
        Node node3 = namedNodeMap.getNamedItem("align");
        if (node2 != null) {
            string2 = node2.getNodeValue();
            objectSegment.setObjectId(String.valueOf(string) + string2);
        }
        if (node3 != null) {
            string2 = node3.getNodeValue().toLowerCase();
            if (string2.equals("top")) {
                objectSegment.setVerticalAlignment(1);
            } else if (string2.equals("middle")) {
                objectSegment.setVerticalAlignment(2);
            } else if (string2.equals("bottom")) {
                objectSegment.setVerticalAlignment(3);
            }
        }
    }

    private void appendText(String string, StringBuffer stringBuffer, int[] nArray) {
        if (!this.whitespaceNormalized) {
            stringBuffer.append(string);
        } else {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == ' ' || c == '\t') {
                    nArray[0] = nArray[0] + 1;
                    if (nArray[0] == 1) {
                        stringBuffer.append(c);
                    }
                } else if (c == '\n' || c == '\r' || c == '\f') {
                    nArray[0] = nArray[0] + 1;
                    if (nArray[0] == 1) {
                        stringBuffer.append(' ');
                    }
                } else {
                    nArray[0] = 0;
                    stringBuffer.append(c);
                }
                ++n;
            }
        }
    }

    private String getNormalizedText(String string) {
        int[] nArray = new int[1];
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            return null;
        }
        this.appendText(string, stringBuffer, nArray);
        return stringBuffer.toString();
    }

    private String getSingleNodeText(Node node) {
        return this.getNormalizedText(node.getNodeValue());
    }

    private String getNodeText(Node node) {
        NodeList nodeList = node.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = new int[1];
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() == 3) {
                String string = node2.getNodeValue();
                this.appendText(string, stringBuffer, nArray);
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    private ParagraphSegment processHyperlinkSegment(Node node, HyperlinkSettings hyperlinkSettings) {
        Object object;
        Node node2;
        Node node3;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        boolean bl = true;
        String string2 = null;
        Node node4 = namedNodeMap.getNamedItem("href");
        if (node4 != null) {
            string = node4.getNodeValue();
        }
        if ((node3 = namedNodeMap.getNamedItem("bold")) != null) {
            string2 = BOLD_FONT_ID;
        }
        if ((node2 = namedNodeMap.getNamedItem("nowrap")) != null && (object = node2.getNodeValue()) != null && ((String)object).equalsIgnoreCase("true")) {
            bl = false;
        }
        if ((object = this.checkChildren(node)) instanceof Node) {
            Node node5;
            Node node6 = (Node)object;
            ImageHyperlinkSegment imageHyperlinkSegment = new ImageHyperlinkSegment();
            imageHyperlinkSegment.setHref(string);
            imageHyperlinkSegment.setWordWrapAllowed(bl);
            Node node7 = node6.getAttributes().getNamedItem("alt");
            if (node7 != null) {
                imageHyperlinkSegment.setTooltipText(node7.getNodeValue());
            }
            if ((node5 = node6.getAttributes().getNamedItem("text")) != null) {
                imageHyperlinkSegment.setText(node5.getNodeValue());
            }
            this.processObjectSegment(imageHyperlinkSegment, node6, "i.");
            return imageHyperlinkSegment;
        }
        if (object instanceof String) {
            String string3 = (String)object;
            TextHyperlinkSegment textHyperlinkSegment = new TextHyperlinkSegment(string3, hyperlinkSettings, null);
            textHyperlinkSegment.setHref(string);
            textHyperlinkSegment.setFontId(string2);
            Node node8 = namedNodeMap.getNamedItem("alt");
            if (node8 != null) {
                textHyperlinkSegment.setTooltipText(node8.getNodeValue());
            }
            textHyperlinkSegment.setWordWrapAllowed(bl);
            return textHyperlinkSegment;
        }
        AggregateHyperlinkSegment aggregateHyperlinkSegment = new AggregateHyperlinkSegment();
        aggregateHyperlinkSegment.setHref(string);
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node9;
            ParagraphSegment paragraphSegment;
            String string4;
            Node node10 = nodeList.item(n);
            if (node10.getNodeType() == 3) {
                string4 = node10.getNodeValue();
                paragraphSegment = new TextHyperlinkSegment(this.getNormalizedText(string4), hyperlinkSettings, null);
                node9 = namedNodeMap.getNamedItem("alt");
                if (node9 != null) {
                    ((TextHyperlinkSegment)paragraphSegment).setTooltipText(node9.getNodeValue());
                }
                ((TextSegment)paragraphSegment).setWordWrapAllowed(bl);
                aggregateHyperlinkSegment.add((TextHyperlinkSegment)paragraphSegment);
            } else if (node10.getNodeType() == 1 && (string4 = node10.getNodeName()).equalsIgnoreCase("img")) {
                paragraphSegment = new ImageHyperlinkSegment();
                this.processObjectSegment((ObjectSegment)paragraphSegment, node10, "i.");
                node9 = node10.getAttributes().getNamedItem("alt");
                if (node9 != null) {
                    ((ImageHyperlinkSegment)paragraphSegment).setTooltipText(node9.getNodeValue());
                }
                aggregateHyperlinkSegment.add((ImageHyperlinkSegment)paragraphSegment);
                ((ImageHyperlinkSegment)paragraphSegment).setWordWrapAllowed(bl);
            }
            ++n;
        }
        return aggregateHyperlinkSegment;
    }

    private Object checkChildren(Node node) {
        boolean bl = false;
        Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node3 = nodeList.item(n);
            if (node3.getNodeType() == 3) {
                bl = true;
            } else if (node3.getNodeType() == 1 && node3.getNodeName().equalsIgnoreCase("img")) {
                node2 = node3;
            }
            ++n;
        }
        if (bl && node2 == null) {
            return this.getNodeText(node);
        }
        if (!bl && node2 != null) {
            return node2;
        }
        return null;
    }

    private void processTextSegment(Paragraph paragraph, boolean bl, Node node) {
        String string;
        String string2 = this.getNodeText(node);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("font");
        Node node3 = namedNodeMap.getNamedItem("color");
        boolean bl2 = true;
        Node node4 = namedNodeMap.getNamedItem("nowrap");
        if (node4 != null && (string = node4.getNodeValue()) != null && string.equalsIgnoreCase("true")) {
            bl2 = false;
        }
        string = null;
        String string3 = null;
        if (node2 != null) {
            string = "f." + node2.getNodeValue();
        }
        if (node3 != null) {
            string3 = "c." + node3.getNodeValue();
        }
        paragraph.parseRegularText(string2, bl, bl2, this.getHyperlinkSettings(), string, string3);
    }

    public void parseRegularText(String string, boolean bl) {
        this.reset();
        if (string == null) {
            return;
        }
        string = this.getNormalizedText(string);
        Paragraph paragraph = new Paragraph(true);
        this.paragraphs.add(paragraph);
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (paragraph == null) {
                paragraph = new Paragraph(true);
                this.paragraphs.add(paragraph);
            }
            if (c == '\n') {
                String string2 = string.substring(n, n2);
                n = n2 + 1;
                paragraph.parseRegularText(string2, bl, true, this.getHyperlinkSettings(), null);
                paragraph = null;
            }
            ++n2;
        }
        if (paragraph != null) {
            String string3 = string.substring(n);
            paragraph.parseRegularText(string3, bl, true, this.getHyperlinkSettings(), null);
        }
    }

    public HyperlinkSettings getHyperlinkSettings() {
        if (this.hyperlinkSettings == null) {
            this.hyperlinkSettings = new HyperlinkSettings(SWTUtil.getStandardDisplay());
        }
        return this.hyperlinkSettings;
    }

    public void setHyperlinkSettings(HyperlinkSettings hyperlinkSettings) {
        this.hyperlinkSettings = hyperlinkSettings;
    }

    private void reset() {
        if (this.paragraphs == null) {
            this.paragraphs = new Vector();
        }
        this.paragraphs.clear();
        this.selectedSegmentIndex = -1;
        this.savedSelectedLinkIndex = -1;
        this.selectableSegments = null;
    }

    IFocusSelectable[] getFocusSelectableSegments() {
        if (this.selectableSegments != null || this.paragraphs == null) {
            return this.selectableSegments;
        }
        Vector<ParagraphSegment> vector = new Vector<ParagraphSegment>();
        int n = 0;
        while (n < this.paragraphs.size()) {
            Paragraph paragraph = (Paragraph)this.paragraphs.get(n);
            ParagraphSegment[] paragraphSegmentArray = paragraph.getSegments();
            int n2 = 0;
            while (n2 < paragraphSegmentArray.length) {
                if (paragraphSegmentArray[n2] instanceof IFocusSelectable) {
                    vector.add(paragraphSegmentArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        this.selectableSegments = vector.toArray(new IFocusSelectable[vector.size()]);
        return this.selectableSegments;
    }

    public IHyperlinkSegment getHyperlink(int n) {
        IFocusSelectable iFocusSelectable;
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        if (iFocusSelectableArray.length > n && (iFocusSelectable = iFocusSelectableArray[n]) instanceof IHyperlinkSegment) {
            return (IHyperlinkSegment)iFocusSelectable;
        }
        return null;
    }

    public IHyperlinkSegment findHyperlinkAt(int n, int n2) {
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        int n3 = 0;
        while (n3 < iFocusSelectableArray.length) {
            IHyperlinkSegment iHyperlinkSegment;
            IFocusSelectable iFocusSelectable = iFocusSelectableArray[n3];
            if (iFocusSelectable instanceof IHyperlinkSegment && (iHyperlinkSegment = (IHyperlinkSegment)iFocusSelectable).contains(n, n2)) {
                return iHyperlinkSegment;
            }
            ++n3;
        }
        return null;
    }

    public int getHyperlinkCount() {
        return this.getFocusSelectableSegments().length;
    }

    public int indexOf(IHyperlinkSegment iHyperlinkSegment) {
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        int n = 0;
        while (n < iFocusSelectableArray.length) {
            IHyperlinkSegment iHyperlinkSegment2;
            IFocusSelectable iFocusSelectable = iFocusSelectableArray[n];
            if (iFocusSelectable instanceof IHyperlinkSegment && iHyperlinkSegment == (iHyperlinkSegment2 = (IHyperlinkSegment)iFocusSelectable)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ParagraphSegment findSegmentAt(int n, int n2) {
        int n3 = 0;
        while (n3 < this.paragraphs.size()) {
            Paragraph paragraph = (Paragraph)this.paragraphs.get(n3);
            ParagraphSegment paragraphSegment = paragraph.findSegmentAt(n, n2);
            if (paragraphSegment != null) {
                return paragraphSegment;
            }
            ++n3;
        }
        return null;
    }

    public void clearCache(String string) {
        int n = 0;
        while (n < this.paragraphs.size()) {
            Paragraph paragraph = (Paragraph)this.paragraphs.get(n);
            paragraph.clearCache(string);
            ++n;
        }
    }

    public IFocusSelectable getSelectedSegment() {
        if (this.selectableSegments == null || this.selectedSegmentIndex == -1) {
            return null;
        }
        return this.selectableSegments[this.selectedSegmentIndex];
    }

    public int getSelectedSegmentIndex() {
        return this.selectedSegmentIndex;
    }

    public boolean linkExists(IHyperlinkSegment iHyperlinkSegment) {
        if (this.selectableSegments == null) {
            return false;
        }
        int n = 0;
        while (n < this.selectableSegments.length) {
            if (this.selectableSegments[n] == iHyperlinkSegment) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean traverseFocusSelectableObjects(boolean bl) {
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        if (iFocusSelectableArray == null) {
            return false;
        }
        int n = iFocusSelectableArray.length;
        this.selectedSegmentIndex = bl ? ++this.selectedSegmentIndex : --this.selectedSegmentIndex;
        if (this.selectedSegmentIndex < 0 || this.selectedSegmentIndex > n - 1) {
            this.selectedSegmentIndex = -1;
        }
        return this.selectedSegmentIndex != -1;
    }

    public IFocusSelectable getNextFocusSegment(boolean bl) {
        int n;
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        if (iFocusSelectableArray == null) {
            return null;
        }
        int n2 = n = bl ? this.selectedSegmentIndex + 1 : this.selectedSegmentIndex - 1;
        if (n < 0 || n > iFocusSelectableArray.length - 1) {
            return null;
        }
        return iFocusSelectableArray[n];
    }

    public boolean restoreSavedLink() {
        if (this.savedSelectedLinkIndex != -1) {
            this.selectedSegmentIndex = this.savedSelectedLinkIndex;
            return true;
        }
        return false;
    }

    public void selectLink(IHyperlinkSegment iHyperlinkSegment) {
        if (iHyperlinkSegment == null) {
            this.savedSelectedLinkIndex = this.selectedSegmentIndex;
            this.selectedSegmentIndex = -1;
        } else {
            this.select(iHyperlinkSegment);
        }
    }

    public void select(IFocusSelectable iFocusSelectable) {
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        this.selectedSegmentIndex = -1;
        if (iFocusSelectableArray == null) {
            return;
        }
        int n = 0;
        while (n < iFocusSelectableArray.length) {
            if (iFocusSelectableArray[n].equals(iFocusSelectable)) {
                this.selectedSegmentIndex = n;
                break;
            }
            ++n;
        }
    }

    public boolean hasFocusSegments() {
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        return iFocusSelectableArray.length > 0;
    }

    public void dispose() {
        this.paragraphs = null;
        this.selectedSegmentIndex = -1;
        this.savedSelectedLinkIndex = -1;
        this.selectableSegments = null;
    }

    public boolean isWhitespaceNormalized() {
        return this.whitespaceNormalized;
    }

    public void setWhitespaceNormalized(boolean bl) {
        this.whitespaceNormalized = bl;
    }

    public class ParseErrorHandler
    implements ErrorHandler {
        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    }
}

