/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.ResourceManagerManger;

public class FormImages {
    private static FormImages instance;
    private ResourceManagerManger manager = new ResourceManagerManger();
    private HashMap descriptors;

    public static FormImages getInstance() {
        if (instance == null) {
            instance = new FormImages();
        }
        return instance;
    }

    private FormImages() {
    }

    public Image getGradient(Color color, Color color2, int n, int n2, int n3, Display display) {
        if (color == null || color.isDisposed() || color2 == null || color2.isDisposed()) {
            return null;
        }
        SimpleImageDescriptor simpleImageDescriptor = new SimpleImageDescriptor(color, color2, n, n2, n3);
        return this.getGradient(simpleImageDescriptor, display);
    }

    public Image getGradient(Color[] colorArray, int[] nArray, int n, boolean bl, Color color, Display display) {
        if (colorArray.length == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < colorArray.length) {
            if (colorArray[n2] == null || colorArray[n2].isDisposed()) {
                return null;
            }
            ++n2;
        }
        if (color != null && color.isDisposed()) {
            return null;
        }
        ComplexImageDescriptor complexImageDescriptor = new ComplexImageDescriptor(colorArray, n, nArray, bl, color);
        return this.getGradient(complexImageDescriptor, display);
    }

    private synchronized Image getGradient(AbstractImageDescriptor abstractImageDescriptor, Display display) {
        this.checkHashMaps();
        Image image = this.manager.getResourceManager(display).createImage((ImageDescriptor)abstractImageDescriptor);
        this.descriptors.put(image, abstractImageDescriptor);
        return image;
    }

    public synchronized boolean markFinished(Image image, Display display) {
        this.checkHashMaps();
        AbstractImageDescriptor abstractImageDescriptor = (AbstractImageDescriptor)((Object)this.descriptors.get(image));
        if (abstractImageDescriptor != null) {
            LocalResourceManager localResourceManager = this.manager.getResourceManager(display);
            localResourceManager.destroyImage((ImageDescriptor)abstractImageDescriptor);
            if (localResourceManager.find((DeviceResourceDescriptor)abstractImageDescriptor) == null) {
                this.descriptors.remove(image);
                this.validateHashMaps();
            }
            return true;
        }
        image.dispose();
        return false;
    }

    private void checkHashMaps() {
        if (this.descriptors == null) {
            this.descriptors = new HashMap();
        }
    }

    private void validateHashMaps() {
        if (this.descriptors.size() == 0) {
            this.descriptors = null;
        }
    }

    private abstract class AbstractImageDescriptor
    extends ImageDescriptor {
        RGB[] fRGBs;
        int fLength;

        AbstractImageDescriptor(Color[] colorArray, int n) {
            this.fRGBs = new RGB[colorArray.length];
            int n2 = 0;
            while (n2 < colorArray.length) {
                Color color = colorArray[n2];
                this.fRGBs[n2] = color == null ? null : color.getRGB();
                ++n2;
            }
            this.fLength = n;
        }

        public boolean equals(Object object) {
            if (object instanceof AbstractImageDescriptor) {
                AbstractImageDescriptor abstractImageDescriptor = (AbstractImageDescriptor)((Object)object);
                if (abstractImageDescriptor.fRGBs.length == this.fRGBs.length) {
                    boolean bl = abstractImageDescriptor.fLength == this.fLength;
                    int n = 0;
                    while (n < this.fRGBs.length && bl) {
                        bl = bl && abstractImageDescriptor.fRGBs[n].equals((Object)this.fRGBs[n]);
                        ++n;
                    }
                    return bl;
                }
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.fRGBs.length) {
                n = n * 7 + this.fRGBs[n2].hashCode();
                ++n2;
            }
            n = n * 7 + this.fLength;
            return n;
        }
    }

    private class ComplexImageDescriptor
    extends AbstractImageDescriptor {
        RGB fBgRGB;
        boolean fVertical;
        int[] fPercents;

        public ComplexImageDescriptor(Color[] colorArray, int n, int[] nArray, boolean bl, Color color) {
            super(colorArray, n);
            this.fBgRGB = color == null ? null : color.getRGB();
            this.fVertical = bl;
            this.fPercents = nArray;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof ComplexImageDescriptor) {
                ComplexImageDescriptor complexImageDescriptor = (ComplexImageDescriptor)((Object)object);
                if (super.equals(object) && complexImageDescriptor.fVertical == this.fVertical && Arrays.equals(complexImageDescriptor.fPercents, this.fPercents)) {
                    if (complexImageDescriptor.fBgRGB == null && this.fBgRGB == null || complexImageDescriptor.fBgRGB != null && complexImageDescriptor.fBgRGB.equals((Object)this.fBgRGB)) {
                        return true;
                    }
                    int n = 0;
                    int n2 = 0;
                    while (n2 < this.fPercents.length) {
                        n += this.fPercents[n2];
                        ++n2;
                    }
                    if (n >= 100) {
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = n * 7 + new Boolean(this.fVertical).hashCode();
            int n2 = 0;
            while (n2 < this.fPercents.length) {
                n = n * 7 + new Integer(this.fPercents[n2]).hashCode();
                ++n2;
            }
            return n;
        }

        public ImageData getImageData() {
            return null;
        }

        public Image createImage(boolean bl, Device device) {
            int n = this.fVertical ? 1 : this.fLength;
            int n2 = this.fVertical ? this.fLength : 1;
            Image image = new Image(device, Math.max(n, 1), Math.max(n2, 1));
            GC gC = new GC((Drawable)image);
            Color[] colorArray = new Color[this.fRGBs.length];
            int n3 = 0;
            while (n3 < colorArray.length) {
                colorArray[n3] = new Color(device, this.fRGBs[n3]);
                ++n3;
            }
            Color color = this.fBgRGB == null ? null : new Color(device, this.fBgRGB);
            this.drawTextGradient(gC, n, n2, colorArray, this.fPercents, this.fVertical, color);
            gC.dispose();
            int n4 = 0;
            while (n4 < colorArray.length) {
                colorArray[n4].dispose();
                ++n4;
            }
            if (color != null) {
                color.dispose();
            }
            return image;
        }

        private void drawTextGradient(GC gC, int n, int n2, Color[] colorArray, int[] nArray, boolean bl, Color color) {
            Color color2 = gC.getBackground();
            if (colorArray.length == 1) {
                if (colorArray[0] != null) {
                    gC.setBackground(colorArray[0]);
                }
                gC.fillRectangle(0, 0, n, n2);
            } else {
                Color color3 = gC.getForeground();
                Color color4 = colorArray[0];
                if (color4 == null) {
                    color4 = color2;
                }
                int n3 = 0;
                int n4 = 0;
                while (n4 < nArray.length) {
                    int n5;
                    gC.setForeground(color4);
                    color4 = colorArray[n4 + 1];
                    if (color4 == null) {
                        color4 = color2;
                    }
                    gC.setBackground(color4);
                    if (bl) {
                        n5 = nArray[n4] * n2 / 100;
                        gC.fillGradientRectangle(0, n3, n, n5, true);
                        n3 += n5;
                    } else {
                        n5 = nArray[n4] * n / 100;
                        gC.fillGradientRectangle(n3, 0, n5, n2, false);
                        n3 += n5;
                    }
                    ++n4;
                }
                if (bl && n3 < n2) {
                    if (color != null) {
                        gC.setBackground(color);
                    }
                    gC.fillRectangle(0, n3, n, n2 - n3);
                }
                if (!bl && n3 < n) {
                    if (color != null) {
                        gC.setBackground(color);
                    }
                    gC.fillRectangle(n3, 0, n - n3, n2);
                }
                gC.setForeground(color3);
            }
        }
    }

    private class SimpleImageDescriptor
    extends AbstractImageDescriptor {
        private int fTheight;
        private int fMarginHeight;

        SimpleImageDescriptor(Color color, Color color2, int n, int n2, int n3) {
            super(new Color[]{color, color2}, n);
            this.fTheight = n2;
            this.fMarginHeight = n3;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof SimpleImageDescriptor) {
                SimpleImageDescriptor simpleImageDescriptor = (SimpleImageDescriptor)((Object)object);
                if (super.equals(object) && simpleImageDescriptor.fTheight == this.fTheight && simpleImageDescriptor.fMarginHeight == this.fMarginHeight) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = n * 7 + new Integer(this.fTheight).hashCode();
            n = n * 7 + new Integer(this.fMarginHeight).hashCode();
            return n;
        }

        public ImageData getImageData() {
            return null;
        }

        public Image createImage(boolean bl, Device device) {
            Image image = new Image(device, 1, this.fLength);
            Color color = new Color(device, this.fRGBs[0]);
            Color color2 = new Color(device, this.fRGBs[1]);
            image.setBackground(color);
            GC gC = new GC((Drawable)image);
            gC.setBackground(color);
            gC.fillRectangle(0, 0, 1, this.fLength);
            gC.setForeground(color2);
            gC.setBackground(color);
            gC.fillGradientRectangle(0, this.fMarginHeight + 2, 1, this.fTheight - 2, true);
            gC.dispose();
            color.dispose();
            color2.dispose();
            return image;
        }
    }
}

