/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.internal.forms.IMessageToolTipManager;
import org.eclipse.ui.internal.forms.MessageManager;
import org.eclipse.ui.internal.forms.widgets.FormImages;
import org.eclipse.ui.internal.forms.widgets.FormsResources;
import org.eclipse.ui.internal.forms.widgets.TitleRegion;

public class FormHeading
extends Canvas {
    private static final int TITLE_HMARGIN = 1;
    private static final int SPACING = 5;
    private static final int VSPACING = 5;
    private static final int HMARGIN = 6;
    private static final int VMARGIN = 1;
    private static final int CLIENT_MARGIN = 1;
    private static final int SEPARATOR = 2;
    private static final int BOTTOM_TOOLBAR = 4;
    private static final int BACKGROUND_IMAGE_TILED = 8;
    private static final int SEPARATOR_HEIGHT = 2;
    private static final int MESSAGE_AREA_LIMIT = 50;
    static IMessage[] NULL_MESSAGE_ARRAY = new IMessage[0];
    public static final String COLOR_BASE_BG = "baseBg";
    private Image backgroundImage;
    private Image gradientImage;
    Hashtable colors = new Hashtable();
    private int flags;
    private GradientInfo gradientInfo;
    private ToolBarManager toolBarManager;
    private SizeCache toolbarCache = new SizeCache();
    private SizeCache clientCache = new SizeCache();
    private SizeCache messageCache = new SizeCache();
    private TitleRegion titleRegion;
    private MessageRegion messageRegion;
    private IMessageToolTipManager messageToolTipManager = new DefaultMessageToolTipManager();
    private Control headClient;

    public boolean forceFocus() {
        return false;
    }

    private boolean hasToolBar() {
        return this.toolBarManager != null && !this.toolBarManager.isEmpty();
    }

    private boolean hasMessageRegion() {
        return this.messageRegion != null && !this.messageRegion.isEmpty();
    }

    public FormHeading(Composite composite, int n) {
        super(composite, n);
        this.setBackgroundMode(1);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                FormHeading.this.onPaint(event.gc);
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (FormHeading.this.gradientImage != null) {
                    FormImages.getInstance().markFinished(FormHeading.this.gradientImage, FormHeading.this.getDisplay());
                    FormHeading.this.gradientImage = null;
                }
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (FormHeading.this.gradientInfo != null || FormHeading.this.backgroundImage != null && !FormHeading.this.isBackgroundImageTiled()) {
                    FormHeading.this.updateGradientImage();
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                FormHeading.this.updateTitleRegionHoverState(mouseEvent);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
                FormHeading.this.updateTitleRegionHoverState(mouseEvent);
            }

            public void mouseExit(MouseEvent mouseEvent) {
                FormHeading.this.titleRegion.setHoverState(0);
            }

            public void mouseHover(MouseEvent mouseEvent) {
            }
        });
        super.setLayout((Layout)new FormHeadingLayout());
        this.titleRegion = new TitleRegion((Composite)this);
    }

    public final Point computeSize(int n, int n2, boolean bl) {
        return ((FormHeadingLayout)this.getLayout()).computeSize((Composite)this, n, n2, bl);
    }

    public final void setLayout(Layout layout) {
    }

    public String getText() {
        return this.titleRegion.getText();
    }

    public Image getImage() {
        return this.titleRegion.getImage();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.internalSetBackground(color);
    }

    private void internalSetBackground(Color color) {
        this.titleRegion.setBackground(color);
        if (this.messageRegion != null) {
            this.messageRegion.setBackground(color);
        }
        if (this.toolBarManager != null) {
            this.toolBarManager.getControl().setBackground(color);
        }
        this.putColor(COLOR_BASE_BG, color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.titleRegion.setForeground(color);
        if (this.messageRegion != null) {
            this.messageRegion.setForeground(color);
        }
    }

    public void setText(String string) {
        this.titleRegion.setText(string);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.titleRegion.setFont(font);
    }

    public void setImage(Image image) {
        this.titleRegion.setImage(image);
        if (this.messageRegion != null) {
            this.titleRegion.updateImage(this.messageRegion.getMessageImage(), true);
        } else {
            this.titleRegion.updateImage(null, true);
        }
    }

    public void setTextBackground(Color[] colorArray, int[] nArray, boolean bl) {
        if (colorArray != null) {
            this.gradientInfo = new GradientInfo();
            this.gradientInfo.gradientColors = colorArray;
            this.gradientInfo.percents = nArray;
            this.gradientInfo.vertical = bl;
            this.setBackground(null);
            this.updateGradientImage();
        } else {
            this.gradientInfo = null;
            if (this.gradientImage != null) {
                FormImages.getInstance().markFinished(this.gradientImage, this.getDisplay());
                this.gradientImage = null;
                this.setBackgroundImage(null);
            }
        }
    }

    public void setHeadingBackgroundImage(Image image) {
        this.backgroundImage = image;
        if (image != null) {
            this.setBackground(null);
        }
        if (this.isBackgroundImageTiled()) {
            this.setBackgroundImage(image);
        } else {
            this.updateGradientImage();
        }
    }

    public Image getHeadingBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImageTiled(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
        this.setHeadingBackgroundImage(this.backgroundImage);
    }

    public boolean isBackgroundImageTiled() {
        return (this.flags & 8) != 0;
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        if (image != null) {
            this.internalSetBackground(null);
        }
    }

    public IToolBarManager getToolBarManager() {
        if (this.toolBarManager == null) {
            this.toolBarManager = new ToolBarManager(0x800000);
            ToolBar toolBar = this.toolBarManager.createControl((Composite)this);
            toolBar.setBackground(this.getBackground());
            toolBar.setForeground(this.getForeground());
            toolBar.setCursor(FormsResources.getHandCursor());
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    if (FormHeading.this.toolBarManager != null) {
                        FormHeading.this.toolBarManager.dispose();
                        FormHeading.this.toolBarManager = null;
                    }
                }
            });
        }
        return this.toolBarManager;
    }

    public IMenuManager getMenuManager() {
        return this.titleRegion.getMenuManager();
    }

    public void updateToolBar() {
        if (this.toolBarManager != null) {
            this.toolBarManager.update(false);
        }
    }

    private void onPaint(GC gC) {
        if (!this.isSeparatorVisible() && this.getBackgroundImage() == null) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        Image image = new Image((Device)this.getDisplay(), rectangle.width, rectangle.height);
        image.setBackground(this.getBackground());
        GC gC2 = new GC((Drawable)image);
        gC2.setBackground(this.getBackground());
        gC2.fillRectangle(0, 0, rectangle.width, rectangle.height);
        if (this.getBackgroundImage() != null) {
            if (this.gradientInfo != null) {
                this.drawBackground(gC2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                Image image2 = this.getBackgroundImage();
                Rectangle rectangle2 = image2.getBounds();
                this.drawBackground(gC2, rectangle.x, rectangle.y, rectangle2.width, rectangle2.height);
            }
        }
        if (this.isSeparatorVisible()) {
            if (this.hasColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1")) {
                gC2.setForeground(this.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
            } else {
                gC2.setForeground(this.getBackground());
            }
            gC2.drawLine(rectangle.x, rectangle.height - 2, rectangle.x + rectangle.width - 1, rectangle.height - 2);
            if (this.hasColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2")) {
                gC2.setForeground(this.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
            } else {
                gC2.setForeground(this.getForeground());
            }
            gC2.drawLine(rectangle.x, rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.height - 1);
        }
        gC2.dispose();
        gC.drawImage(image, rectangle.x, rectangle.y);
        image.dispose();
    }

    private void updateTitleRegionHoverState(MouseEvent mouseEvent) {
        Rectangle rectangle = this.titleRegion.getBounds();
        rectangle.width += rectangle.x + 15;
        rectangle.height += rectangle.y + 15;
        rectangle.x = 0;
        rectangle.y = 0;
        if (rectangle.contains(mouseEvent.x, mouseEvent.y)) {
            this.titleRegion.setHoverState(1);
        } else {
            this.titleRegion.setHoverState(0);
        }
    }

    private void updateGradientImage() {
        Rectangle rectangle = this.getBounds();
        if (this.gradientImage != null) {
            FormImages.getInstance().markFinished(this.gradientImage, this.getDisplay());
            this.gradientImage = null;
        }
        if (this.gradientInfo != null) {
            this.gradientImage = FormImages.getInstance().getGradient(this.gradientInfo.gradientColors, this.gradientInfo.percents, this.gradientInfo.vertical ? rectangle.height : rectangle.width, this.gradientInfo.vertical, this.getColor(COLOR_BASE_BG), this.getDisplay());
        } else if (this.backgroundImage != null && !this.isBackgroundImageTiled()) {
            this.gradientImage = new Image((Device)this.getDisplay(), Math.max(rectangle.width, 1), Math.max(rectangle.height, 1));
            this.gradientImage.setBackground(this.getBackground());
            GC gC = new GC((Drawable)this.gradientImage);
            gC.drawImage(this.backgroundImage, 0, 0);
            gC.dispose();
        }
        this.setBackgroundImage(this.gradientImage);
    }

    public boolean isSeparatorVisible() {
        return (this.flags & 2) != 0;
    }

    public void setSeparatorVisible(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public void setToolBarAlignment(int n) {
        this.flags = n == 1024 ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public int getToolBarAlignment() {
        return (this.flags & 4) != 0 ? 1024 : 128;
    }

    public void addMessageHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
        this.ensureMessageRegionExists();
        this.messageRegion.addMessageHyperlinkListener(iHyperlinkListener);
    }

    public void removeMessageHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
        if (this.messageRegion != null) {
            this.messageRegion.removeMessageHyperlinkListener(iHyperlinkListener);
        }
    }

    public String getMessage() {
        return this.messageRegion != null ? this.messageRegion.getMessage() : null;
    }

    public int getMessageType() {
        return this.messageRegion != null ? this.messageRegion.getMessageType() : 0;
    }

    public IMessage[] getChildrenMessages() {
        return this.messageRegion != null ? this.messageRegion.getChildrenMessages() : NULL_MESSAGE_ARRAY;
    }

    private void ensureMessageRegionExists() {
        if (this.messageRegion == null) {
            this.messageRegion = new MessageRegion();
        }
    }

    public void showMessage(String string, int n, IMessage[] iMessageArray) {
        if (this.messageRegion == null ? string == null : this.messageRegion.isDisposed()) {
            return;
        }
        this.ensureMessageRegionExists();
        this.messageRegion.showMessage(string, n, iMessageArray);
        this.titleRegion.updateImage(this.messageRegion.getMessageImage(), false);
        if (this.messageToolTipManager != null) {
            this.messageToolTipManager.update();
        }
        this.layout();
        this.redraw();
    }

    public boolean isBusy() {
        return this.titleRegion.isBusy();
    }

    public void setBusy(boolean bl) {
        if (this.titleRegion.setBusy(bl)) {
            this.layout();
        }
    }

    public Control getHeadClient() {
        return this.headClient;
    }

    public void setHeadClient(Control control) {
        if (control != null) {
            Assert.isTrue((control.getParent() == this ? 1 : 0) != 0);
        }
        this.headClient = control;
        this.layout();
    }

    public void putColor(String string, Color color) {
        if (color == null) {
            this.colors.remove(string);
        } else {
            this.colors.put(string, color);
        }
    }

    public Color getColor(String string) {
        return (Color)this.colors.get(string);
    }

    public boolean hasColor(String string) {
        return this.colors.containsKey(string);
    }

    public void addDragSupport(int n, Transfer[] transferArray, DragSourceListener dragSourceListener) {
        this.titleRegion.addDragSupport(n, transferArray, dragSourceListener);
    }

    public void addDropSupport(int n, Transfer[] transferArray, DropTargetListener dropTargetListener) {
        this.titleRegion.addDropSupport(n, transferArray, dropTargetListener);
    }

    public IMessageToolTipManager getMessageToolTipManager() {
        return this.messageToolTipManager;
    }

    public void setMessageToolTipManager(IMessageToolTipManager iMessageToolTipManager) {
        this.messageToolTipManager = iMessageToolTipManager;
    }

    private class DefaultMessageToolTipManager
    implements IMessageToolTipManager {
        private DefaultMessageToolTipManager() {
        }

        @Override
        public void createToolTip(Control control, boolean bl) {
        }

        @Override
        public void update() {
            String string;
            String string2 = string = FormHeading.this.getMessageType() == 0 ? null : MessageManager.createDetails(FormHeading.this.getChildrenMessages());
            if (FormHeading.this.messageRegion != null) {
                FormHeading.this.messageRegion.updateToolTip(string);
            }
            if (FormHeading.this.getMessageType() > 0 && (string == null || string.length() == 0)) {
                string = FormHeading.this.getMessage();
            }
            FormHeading.this.titleRegion.updateToolTip(string);
        }
    }

    private class FormHeadingLayout
    extends Layout
    implements ILayoutExtension {
        private FormHeadingLayout() {
        }

        @Override
        public int computeMinimumWidth(Composite composite, boolean bl) {
            return this.computeSize((Composite)composite, (int)5, (int)-1, (boolean)bl).x;
        }

        @Override
        public int computeMaximumWidth(Composite composite, boolean bl) {
            return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)bl).x;
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            return this.layout(composite, false, 0, 0, n, n2, bl);
        }

        protected void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            this.layout(composite, true, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
        }

        private Point layout(Composite composite, boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
            int n5;
            int n6;
            int n7;
            Point point;
            int n8;
            Point point2 = null;
            Point point3 = null;
            Point point4 = null;
            Point point5 = null;
            if (bl2) {
                FormHeading.this.clientCache.flush();
                FormHeading.this.messageCache.flush();
                FormHeading.this.toolbarCache.flush();
            }
            if (FormHeading.this.hasToolBar()) {
                ToolBar toolBar = FormHeading.this.toolBarManager.getControl();
                FormHeading.this.toolbarCache.setControl((Control)toolBar);
                point4 = FormHeading.this.toolbarCache.computeSize(-1, -1);
            }
            if (FormHeading.this.headClient != null) {
                FormHeading.this.clientCache.setControl(FormHeading.this.headClient);
                int n9 = n3;
                if (n9 != -1) {
                    n9 -= 12;
                    if (point4 != null && FormHeading.this.getToolBarAlignment() == 1024) {
                        n9 -= point4.x + 5;
                    }
                }
                point5 = FormHeading.this.clientCache.computeSize(n9, -1);
            }
            int n10 = n8 = n3;
            if (n8 != -1) {
                n8 -= 2;
                if (FormHeading.this.hasToolBar() && FormHeading.this.getToolBarAlignment() == 128 || FormHeading.this.hasMessageRegion()) {
                    n8 -= 5;
                }
                if (FormHeading.this.hasToolBar() && FormHeading.this.getToolBarAlignment() == 128) {
                    n8 -= point4.x + 5;
                }
                n10 = n8;
                if (FormHeading.this.hasMessageRegion()) {
                    n10 -= 5;
                }
            }
            if (!FormHeading.this.hasMessageRegion()) {
                point2 = FormHeading.this.titleRegion.computeSize(n10, -1);
            } else {
                point = FormHeading.this.titleRegion.computeSize(-1, -1);
                FormHeading.this.messageCache.setControl(FormHeading.this.messageRegion.getMessageControl());
                Point point6 = FormHeading.this.messageCache.computeSize(-1, -1);
                point2 = point;
                point3 = point6;
                if (n10 != -1 && (n7 = point.x + point6.x) > n10) {
                    n6 = n10 - point.x;
                    if (n6 >= 50) {
                        point3.x = n6;
                    } else {
                        n5 = n10 - 50;
                        point2 = FormHeading.this.titleRegion.computeSize(n5, -1);
                        point3.x = 50;
                    }
                }
            }
            point = new Point(n3, n4);
            if (!bl) {
                int n11 = 2;
                n11 += point2.x;
                if (point3 != null) {
                    n11 += 5 + point3.x;
                }
                if (point4 != null && FormHeading.this.getToolBarAlignment() == 128) {
                    n11 += 5 + point4.x;
                }
                if (point3 != null || point4 != null && FormHeading.this.getToolBarAlignment() == 128) {
                    n11 += 5;
                }
                point.x = n11;
                if (point5 != null) {
                    n7 = point5.x;
                    if (point4 != null && FormHeading.this.getToolBarAlignment() == 1024) {
                        n7 += 5 + point4.x;
                    }
                    point.x = Math.max(n11, n7 += 12);
                }
                point.y = point2.y;
                if (point3 != null) {
                    point.y = Math.max(point3.y, point.y);
                }
                if (point4 != null && FormHeading.this.getToolBarAlignment() == 128) {
                    point.y = Math.max(point4.y, point.y);
                }
                if (point.y > 0) {
                    point.y += 2;
                }
                n7 = 0;
                if (point4 != null && FormHeading.this.getToolBarAlignment() == 1024) {
                    n7 = point4.y;
                }
                if (point5 != null) {
                    n7 = Math.max(n7, point5.y);
                }
                if (n7 > 0) {
                    point.y += 5 + n7 + 1;
                }
                if (point.y > 0 && FormHeading.this.isSeparatorVisible()) {
                    point.y += 2;
                }
            } else {
                int n12;
                int n13 = n;
                n7 = n2 + 1;
                n6 = point2.y;
                if (FormHeading.this.hasMessageRegion()) {
                    n6 = Math.max(n6, point3.y);
                }
                if (FormHeading.this.hasToolBar() && FormHeading.this.getToolBarAlignment() == 128) {
                    n6 = Math.max(n6, point4.y);
                }
                FormHeading.this.titleRegion.setBounds(n13, n7, point2.x, point2.y);
                n13 += point2.x;
                if (FormHeading.this.hasMessageRegion()) {
                    n13 += 5;
                    n5 = 0;
                    if (point2.y > 0) {
                        n12 = (point2.y - FormHeading.this.titleRegion.getFontHeight()) / 2;
                        int n14 = (point3.y - FormHeading.this.messageRegion.getFontHeight()) / 2;
                        n5 = n12 + FormHeading.this.titleRegion.getFontBaselineHeight() - (n14 + FormHeading.this.messageRegion.getFontBaselineHeight());
                    }
                    FormHeading.this.messageRegion.getMessageControl().setBounds(n13, point2.y > 0 ? n7 + n5 : n7 + n6 / 2 - point3.y / 2, point3.x, point3.y);
                    n13 += point3.x;
                }
                if (FormHeading.this.toolBarManager != null) {
                    FormHeading.this.toolBarManager.getControl().setVisible(!FormHeading.this.toolBarManager.isEmpty());
                }
                if (point4 != null && FormHeading.this.getToolBarAlignment() == 128) {
                    ToolBar toolBar = FormHeading.this.toolBarManager.getControl();
                    toolBar.setBounds(n + n3 - 1 - point4.x - 6, n7 + n6 - 1 - point4.y, point4.x, point4.y);
                }
                n13 = 6;
                n7 += n6 + 5;
                int n15 = 0;
                if (point4 != null && FormHeading.this.getToolBarAlignment() == 1024) {
                    ToolBar toolBar = FormHeading.this.toolBarManager.getControl();
                    toolBar.setBounds(n + n3 - 1 - point4.x - 6, n7, point4.x, point4.y);
                    n15 = point4.x + 5;
                }
                if (FormHeading.this.headClient != null) {
                    n12 = n3 - 12 - n15;
                    FormHeading.this.headClient.setBounds(n13, n7, n12, point5.y);
                }
            }
            return point;
        }
    }

    private class GradientInfo {
        Color[] gradientColors;
        int[] percents;
        boolean vertical;

        private GradientInfo() {
        }
    }

    private class MessageRegion {
        private String message;
        private int messageType;
        private CLabel messageLabel;
        private IMessage[] messages;
        private Hyperlink messageHyperlink;
        private ListenerList listeners;
        private Color fg;
        private int fontHeight = -1;
        private int fontBaselineHeight = -1;

        public boolean isDisposed() {
            Control control = this.getMessageControl();
            return control != null && control.isDisposed();
        }

        public boolean isEmpty() {
            Control control = this.getMessageControl();
            if (control == null) {
                return true;
            }
            return !control.getVisible();
        }

        public int getFontHeight() {
            if (this.fontHeight == -1) {
                Control control = this.getMessageControl();
                if (control == null) {
                    return 0;
                }
                GC gC = new GC((Drawable)control.getDisplay());
                gC.setFont(control.getFont());
                this.fontHeight = gC.getFontMetrics().getHeight();
                gC.dispose();
            }
            return this.fontHeight;
        }

        public int getFontBaselineHeight() {
            if (this.fontBaselineHeight == -1) {
                Control control = this.getMessageControl();
                if (control == null) {
                    return 0;
                }
                GC gC = new GC((Drawable)control.getDisplay());
                gC.setFont(control.getFont());
                FontMetrics fontMetrics = gC.getFontMetrics();
                this.fontBaselineHeight = fontMetrics.getHeight() - fontMetrics.getDescent();
                gC.dispose();
            }
            return this.fontBaselineHeight;
        }

        public void showMessage(String string, int n, IMessage[] iMessageArray) {
            Control control = this.getMessageControl();
            int n2 = this.messageType;
            this.message = string;
            this.messageType = n;
            this.messages = iMessageArray;
            if (string == null) {
                if (control != null && control.getVisible()) {
                    control.setVisible(false);
                }
                if (n2 != n) {
                    this.updateForeground();
                }
                return;
            }
            this.ensureControlExists();
            if (this.needHyperlink()) {
                this.messageHyperlink.setText(string);
                this.messageHyperlink.setHref(iMessageArray);
            } else {
                this.messageLabel.setText(string);
            }
            if (n2 != n) {
                this.updateForeground();
            }
        }

        public void updateToolTip(String string) {
            Control control = this.getMessageControl();
            if (control != null) {
                control.setToolTipText(string);
            }
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.messageType;
        }

        public IMessage[] getChildrenMessages() {
            return this.messages;
        }

        public Control getMessageControl() {
            if (this.needHyperlink() && this.messageHyperlink != null) {
                return this.messageHyperlink;
            }
            return this.messageLabel;
        }

        public Image getMessageImage() {
            switch (this.messageType) {
                case 1: {
                    return JFaceResources.getImage((String)"dialog_messasge_info_image");
                }
                case 2: {
                    return JFaceResources.getImage((String)"dialog_messasge_warning_image");
                }
                case 3: {
                    return JFaceResources.getImage((String)"dialog_message_error_image");
                }
            }
            return null;
        }

        public void addMessageHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
            if (this.listeners == null) {
                this.listeners = new ListenerList();
            }
            this.listeners.add((Object)iHyperlinkListener);
            this.ensureControlExists();
            if (this.messageHyperlink != null) {
                this.messageHyperlink.addHyperlinkListener(iHyperlinkListener);
            }
            if (this.listeners.size() == 1) {
                this.updateForeground();
            }
        }

        private void removeMessageHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
            if (this.listeners != null) {
                this.listeners.remove((Object)iHyperlinkListener);
                if (this.messageHyperlink != null) {
                    this.messageHyperlink.removeHyperlinkListener(iHyperlinkListener);
                }
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
                this.ensureControlExists();
                if (this.listeners == null && !this.isDisposed()) {
                    this.updateForeground();
                }
            }
        }

        private void ensureControlExists() {
            if (this.needHyperlink()) {
                if (this.messageLabel != null) {
                    this.messageLabel.setVisible(false);
                }
                if (this.messageHyperlink == null) {
                    this.messageHyperlink = new Hyperlink((Composite)FormHeading.this, 0);
                    this.messageHyperlink.setUnderlined(true);
                    this.messageHyperlink.setText(this.message);
                    this.messageHyperlink.setHref(this.messages);
                    Object[] objectArray = this.listeners.getListeners();
                    int n = 0;
                    while (n < objectArray.length) {
                        this.messageHyperlink.addHyperlinkListener((IHyperlinkListener)objectArray[n]);
                        ++n;
                    }
                    if (FormHeading.this.messageToolTipManager != null) {
                        FormHeading.this.messageToolTipManager.createToolTip((Control)this.messageHyperlink, false);
                    }
                } else if (!this.messageHyperlink.getVisible()) {
                    this.messageHyperlink.setText(this.message);
                    this.messageHyperlink.setHref(this.messages);
                    this.messageHyperlink.setVisible(true);
                }
            } else {
                if (this.messageHyperlink != null) {
                    this.messageHyperlink.setVisible(false);
                }
                if (this.messageLabel == null) {
                    this.messageLabel = new CLabel((Composite)FormHeading.this, 0);
                    this.messageLabel.setText(this.message);
                    if (FormHeading.this.messageToolTipManager != null) {
                        FormHeading.this.messageToolTipManager.createToolTip((Control)this.messageLabel, false);
                    }
                } else if (!this.messageLabel.getVisible()) {
                    this.messageLabel.setText(this.message);
                    this.messageLabel.setVisible(true);
                }
            }
            FormHeading.this.layout(true);
        }

        private boolean needHyperlink() {
            return this.messageType > 0 && this.listeners != null;
        }

        public void setBackground(Color color) {
            if (this.messageHyperlink != null) {
                this.messageHyperlink.setBackground(color);
            }
            if (this.messageLabel != null) {
                this.messageLabel.setBackground(color);
            }
        }

        public void setForeground(Color color) {
            this.fg = color;
        }

        private void updateForeground() {
            Color color;
            switch (this.messageType) {
                case 3: {
                    color = FormHeading.this.getDisplay().getSystemColor(3);
                    break;
                }
                case 2: {
                    color = FormHeading.this.getDisplay().getSystemColor(8);
                    break;
                }
                default: {
                    color = this.fg;
                }
            }
            this.getMessageControl().setForeground(color);
        }
    }
}

