/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.HashMap;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.ResourceManagerManger;

public class FormFonts {
    private static FormFonts instance;
    private ResourceManagerManger manager = new ResourceManagerManger();
    private HashMap descriptors;

    public static FormFonts getInstance() {
        if (instance == null) {
            instance = new FormFonts();
        }
        return instance;
    }

    private FormFonts() {
    }

    public Font getBoldFont(Display display, Font font) {
        this.checkHashMaps();
        BoldFontDescriptor boldFontDescriptor = new BoldFontDescriptor(font);
        Font font2 = this.manager.getResourceManager(display).createFont((FontDescriptor)boldFontDescriptor);
        this.descriptors.put(font2, boldFontDescriptor);
        return font2;
    }

    public boolean markFinished(Font font, Display display) {
        this.checkHashMaps();
        BoldFontDescriptor boldFontDescriptor = (BoldFontDescriptor)((Object)this.descriptors.get(font));
        if (boldFontDescriptor != null) {
            LocalResourceManager localResourceManager = this.manager.getResourceManager(display);
            localResourceManager.destroyFont((FontDescriptor)boldFontDescriptor);
            if (localResourceManager.find((DeviceResourceDescriptor)boldFontDescriptor) == null) {
                this.descriptors.remove(font);
                this.validateHashMaps();
            }
            return true;
        }
        font.dispose();
        return false;
    }

    private void checkHashMaps() {
        if (this.descriptors == null) {
            this.descriptors = new HashMap();
        }
    }

    private void validateHashMaps() {
        if (this.descriptors.size() == 0) {
            this.descriptors = null;
        }
    }

    private class BoldFontDescriptor
    extends FontDescriptor {
        private FontData[] fFontData;

        BoldFontDescriptor(Font font) {
            this.fFontData = font.getFontData();
            int n = 0;
            while (n < this.fFontData.length) {
                this.fFontData[n].setStyle(this.fFontData[n].getStyle() | 1);
                ++n;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof BoldFontDescriptor) {
                BoldFontDescriptor boldFontDescriptor = (BoldFontDescriptor)((Object)object);
                if (boldFontDescriptor.fFontData.length != this.fFontData.length) {
                    return false;
                }
                int n = 0;
                while (n < this.fFontData.length) {
                    if (!this.fFontData[n].equals((Object)boldFontDescriptor.fFontData[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.fFontData.length) {
                n = n * 7 + this.fFontData[n2].hashCode();
                ++n2;
            }
            return n;
        }

        public Font createFont(Device device) throws DeviceResourceException {
            return new Font(device, this.fFontData);
        }

        public void destroyFont(Font font) {
            font.dispose();
        }
    }
}

