/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Hashtable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.IFocusSelectable;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.ObjectSegment;

public class ControlSegment
extends ObjectSegment
implements IFocusSelectable {
    private boolean fill;
    private int width = -1;
    private int height = -1;

    public void setFill(boolean bl) {
        this.fill = bl;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public Control getControl(Hashtable hashtable) {
        Control control;
        Object v = hashtable.get(this.getObjectId());
        if (v instanceof Control && !(control = (Control)v).isDisposed()) {
            return control;
        }
        return null;
    }

    @Override
    protected Point getObjectSize(Hashtable hashtable, int n) {
        Control control = this.getControl(hashtable);
        if (control == null) {
            return new Point(0, 0);
        }
        int n2 = FormUtil.getWidthHint(n, control);
        Point point = control.computeSize(n2, -1);
        if (n2 != -1 && this.fill) {
            point.x = Math.max(point.x, n2);
        }
        if (this.width != -1) {
            point.x = this.width;
        }
        if (this.height != -1) {
            point.y = this.height;
        }
        return point;
    }

    @Override
    public void layout(GC gC, int n, Locator locator, Hashtable hashtable, boolean bl) {
        super.layout(gC, n, locator, hashtable, bl);
        Control control = this.getControl(hashtable);
        if (control != null) {
            control.setBounds(this.getBounds());
        }
    }

    @Override
    public boolean setFocus(Hashtable hashtable, boolean bl) {
        Control control = this.getControl(hashtable);
        if (control != null) {
            return this.setFocus(control, bl);
        }
        return false;
    }

    private boolean setFocus(Control control, boolean bl) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getTabList();
            if (bl) {
                int n = 0;
                while (n < controlArray.length) {
                    if (this.setFocus(controlArray[n], bl)) {
                        return true;
                    }
                    ++n;
                }
            } else {
                int n = controlArray.length - 1;
                while (n >= 0) {
                    if (this.setFocus(controlArray[n], bl)) {
                        return true;
                    }
                    --n;
                }
            }
            if (!(control instanceof Canvas)) {
                return false;
            }
        }
        return control.setFocus();
    }

    @Override
    public boolean isFocusSelectable(Hashtable hashtable) {
        Control control = this.getControl(hashtable);
        return control != null;
    }
}

