/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public final class BusyIndicator
extends Canvas {
    private static final int MARGIN = 0;
    private static final int IMAGE_COUNT = 8;
    private static final int MILLISECONDS_OF_DELAY = 180;
    private Image[] imageCache;
    private Image image;
    private Display dpy = this.getDisplay();
    private Runnable timer = new Runnable(){

        @Override
        public void run() {
            if (BusyIndicator.this.isDisposed()) {
                return;
            }
            BusyIndicator.this.redraw();
            if (!BusyIndicator.this.busy) {
                return;
            }
            BusyIndicator.this.update();
            if (BusyIndicator.this.isDisposed()) {
                return;
            }
            BusyIndicator.this.imageIndex = (BusyIndicator.this.imageIndex + 1) % 8;
            BusyIndicator.this.dpy.timerExec(180, (Runnable)this);
        }
    };
    private boolean busy;
    private int imageIndex;

    public BusyIndicator(Composite composite, int n) {
        super(composite, n | 0x20000000);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                BusyIndicator.this.onPaint(paintEvent);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                BusyIndicator.this.clearImages();
            }
        });
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Rectangle rectangle;
        Point point = new Point(0, 0);
        if (this.image != null) {
            rectangle = this.image.getBounds();
            point.x = rectangle.width;
            point.y = rectangle.height;
        }
        if (this.isBusy()) {
            rectangle = this.getImage(0).getBounds();
            point.x = Math.max(point.x, rectangle.width);
            point.y = Math.max(point.y, rectangle.height);
        }
        point.x += 0;
        point.y += 0;
        return point;
    }

    public boolean forceFocus() {
        return false;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isBusy() {
        return this.busy;
    }

    void onPaint(PaintEvent paintEvent) {
        Image image;
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        if (this.isBusy()) {
            image = this.getImage(this.imageIndex);
        } else {
            this.clearImages();
            image = this.image;
        }
        if (image != null) {
            GC gC = paintEvent.gc;
            Rectangle rectangle2 = image.getBounds();
            gC.drawImage(image, rectangle.width / 2 - rectangle2.width / 2, rectangle.height / 2 - rectangle2.height / 2);
        }
    }

    public synchronized void setBusy(boolean bl) {
        if (this.busy == bl) {
            return;
        }
        this.busy = bl;
        this.imageIndex = 0;
        this.dpy.asyncExec(this.timer);
    }

    public void setImage(Image image) {
        if (image != this.image && !this.isDisposed()) {
            this.image = image;
            this.redraw();
        }
    }

    private ImageDescriptor createImageDescriptor(String string) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.forms");
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)new Path(string), null);
        if (uRL == null) {
            return null;
        }
        try {
            uRL = FileLocator.resolve((URL)uRL);
            return ImageDescriptor.createFromURL((URL)uRL);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Image getImage(int n) {
        if (this.imageCache == null) {
            this.imageCache = new Image[8];
        }
        if (this.imageCache[n] == null) {
            ImageDescriptor imageDescriptor = this.createImageDescriptor("$nl$/icons/progress/ani/" + (n + 1) + ".png");
            this.imageCache[n] = imageDescriptor.createImage();
        }
        return this.imageCache[n];
    }

    private void clearImages() {
        if (this.imageCache != null) {
            int n = 0;
            while (n < 8) {
                if (this.imageCache[n] != null && !this.imageCache[n].isDisposed()) {
                    this.imageCache[n].dispose();
                    this.imageCache[n] = null;
                }
                ++n;
            }
        }
    }
}

