/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.Paragraph;
import org.eclipse.ui.internal.forms.widgets.SelectionData;

public class BulletParagraph
extends Paragraph {
    public static final int CIRCLE = 1;
    public static final int TEXT = 2;
    public static final int IMAGE = 3;
    private int style = 1;
    private String text;
    private int CIRCLE_DIAM = 5;
    private int SPACING = 10;
    private int indent = -1;
    private int bindent = -1;
    private Rectangle bbounds;

    public BulletParagraph(boolean bl) {
        super(bl);
    }

    @Override
    public int getIndent() {
        int n = this.indent;
        if (n != -1) {
            return n;
        }
        switch (this.style) {
            case 1: {
                n = this.CIRCLE_DIAM + this.SPACING;
                break;
            }
            default: {
                n = 20;
            }
        }
        return this.getBulletIndent() + n;
    }

    public int getBulletIndent() {
        if (this.bindent != -1) {
            return this.bindent;
        }
        return 0;
    }

    public int getBulletStyle() {
        return this.style;
    }

    public void setBulletStyle(int n) {
        this.style = n;
    }

    public void setBulletText(String string) {
        this.text = string;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public void setBulletIndent(int n) {
        this.bindent = n;
    }

    public String getBulletText() {
        return this.text;
    }

    @Override
    public void layout(GC gC, int n, Locator locator, int n2, Hashtable hashtable, IHyperlinkSegment iHyperlinkSegment) {
        this.computeRowHeights(gC, n, locator, n2, hashtable);
        this.layoutBullet(gC, locator, n2, hashtable);
        super.layout(gC, n, locator, n2, hashtable, iHyperlinkSegment);
    }

    @Override
    public void paint(GC gC, Rectangle rectangle, Hashtable hashtable, IHyperlinkSegment iHyperlinkSegment, SelectionData selectionData) {
        this.paintBullet(gC, rectangle, hashtable);
        super.paint(gC, rectangle, hashtable, iHyperlinkSegment, selectionData);
    }

    private void layoutBullet(GC gC, Locator locator, int n, Hashtable hashtable) {
        Image image;
        int n2 = locator.x - this.getIndent() + this.getBulletIndent();
        int n3 = ((int[])locator.heights.get(0))[0];
        if (this.style == 1) {
            int n4 = locator.y + n3 / 2 - this.CIRCLE_DIAM / 2;
            this.bbounds = new Rectangle(n2, n4, this.CIRCLE_DIAM, this.CIRCLE_DIAM);
        } else if (this.style == 2 && this.text != null) {
            Point point = gC.textExtent(this.text);
            this.bbounds = new Rectangle(n2, locator.y, point.x, point.y);
        } else if (this.style == 3 && this.text != null && (image = (Image)hashtable.get(this.text)) != null) {
            Rectangle rectangle = image.getBounds();
            int n5 = locator.y + n3 / 2 - rectangle.height / 2;
            this.bbounds = new Rectangle(n2, n5, rectangle.width, rectangle.height);
        }
    }

    public void paintBullet(GC gC, Rectangle rectangle, Hashtable hashtable) {
        Image image;
        if (this.bbounds == null) {
            return;
        }
        int n = this.bbounds.x;
        int n2 = this.bbounds.y;
        if (rectangle != null) {
            n -= rectangle.x;
            n2 -= rectangle.y;
        }
        if (this.style == 1) {
            Color color = gC.getBackground();
            Color color2 = gC.getForeground();
            gC.setBackground(color2);
            gC.fillRectangle(n, n2 + 1, 5, 3);
            gC.fillRectangle(n + 1, n2, 3, 5);
            gC.setBackground(color);
        } else if (this.style == 2 && this.text != null) {
            gC.drawText(this.text, n, n2);
        } else if (this.style == 3 && this.text != null && (image = (Image)hashtable.get(this.text)) != null) {
            gC.drawImage(image, n, n2);
        }
    }
}

