/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.IMessagePrefixProvider;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.forms.Messages;

public class MessageManager
implements IMessageManager {
    private static final DefaultPrefixProvider DEFAULT_PREFIX_PROVIDER = new DefaultPrefixProvider();
    private ArrayList messages = new ArrayList();
    private ArrayList oldMessages;
    private Hashtable decorators = new Hashtable();
    private Hashtable oldDecorators;
    private boolean autoUpdate = true;
    private Form form;
    private IMessagePrefixProvider prefixProvider = DEFAULT_PREFIX_PROVIDER;
    private int decorationPosition = 17408;
    private static FieldDecoration standardError = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
    private static FieldDecoration standardWarning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
    private static FieldDecoration standardInformation = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
    private static final String[] SINGLE_MESSAGE_SUMMARY_KEYS = new String[]{Messages.MessageManager_sMessageSummary, Messages.MessageManager_sMessageSummary, Messages.MessageManager_sWarningSummary, Messages.MessageManager_sErrorSummary};
    private static final String[] MULTIPLE_MESSAGE_SUMMARY_KEYS = new String[]{Messages.MessageManager_pMessageSummary, Messages.MessageManager_pMessageSummary, Messages.MessageManager_pWarningSummary, Messages.MessageManager_pErrorSummary};

    public MessageManager(ScrolledForm scrolledForm) {
        this.form = scrolledForm.getForm();
    }

    public MessageManager(Form form) {
        this.form = form;
    }

    @Override
    public void addMessage(Object object, String string, Object object2, int n) {
        this.addMessage(null, object, string, object2, n, this.messages);
        if (this.isAutoUpdate()) {
            this.updateForm();
        }
    }

    @Override
    public void addMessage(Object object, String string, Object object2, int n, Control control) {
        ControlDecorator controlDecorator = (ControlDecorator)this.decorators.get(control);
        if (controlDecorator == null) {
            controlDecorator = new ControlDecorator(control);
            this.decorators.put(control, controlDecorator);
        }
        controlDecorator.addMessage(object, string, object2, n);
        if (this.isAutoUpdate()) {
            this.updateForm();
        }
    }

    @Override
    public void removeMessage(Object object) {
        Message message = this.findMessage(object, this.messages);
        if (message != null) {
            this.messages.remove(message);
            if (this.isAutoUpdate()) {
                this.updateForm();
            }
        }
    }

    @Override
    public void removeMessages() {
        if (!this.messages.isEmpty()) {
            this.messages.clear();
            if (this.isAutoUpdate()) {
                this.updateForm();
            }
        }
    }

    @Override
    public void removeMessage(Object object, Control control) {
        ControlDecorator controlDecorator = (ControlDecorator)this.decorators.get(control);
        if (controlDecorator == null) {
            return;
        }
        if (controlDecorator.removeMessage(object) && this.isAutoUpdate()) {
            this.updateForm();
        }
    }

    @Override
    public void removeMessages(Control control) {
        ControlDecorator controlDecorator = (ControlDecorator)this.decorators.get(control);
        if (controlDecorator != null && controlDecorator.removeMessages() && this.isAutoUpdate()) {
            this.updateForm();
        }
    }

    @Override
    public void removeAllMessages() {
        boolean bl = false;
        Enumeration enumeration = this.decorators.elements();
        while (enumeration.hasMoreElements()) {
            ControlDecorator controlDecorator = (ControlDecorator)enumeration.nextElement();
            if (!controlDecorator.removeMessages()) continue;
            bl = true;
        }
        if (!this.messages.isEmpty()) {
            this.messages.clear();
            bl = true;
        }
        if (bl && this.isAutoUpdate()) {
            this.updateForm();
        }
    }

    private Message addMessage(String string, Object object, String string2, Object object2, int n, ArrayList arrayList) {
        Message message = this.findMessage(object, arrayList);
        if (message == null) {
            message = new Message(object, string2, n, object2);
            message.prefix = string;
            arrayList.add(message);
        } else {
            message.message = string2;
            message.type = n;
            message.data = object2;
        }
        return message;
    }

    private Message findMessage(Object object, ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            Message message = (Message)arrayList.get(n);
            if (message.getKey().equals(object)) {
                return message;
            }
            ++n;
        }
        return null;
    }

    @Override
    public void update() {
        for (ControlDecorator controlDecorator : this.decorators.values()) {
            controlDecorator.update();
        }
        this.updateForm();
    }

    private void updateForm() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.messages);
        Enumeration enumeration = this.decorators.elements();
        while (enumeration.hasMoreElements()) {
            ControlDecorator controlDecorator = (ControlDecorator)enumeration.nextElement();
            controlDecorator.addAll(arrayList);
        }
        this.update(arrayList);
    }

    private void update(ArrayList arrayList) {
        this.pruneControlDecorators();
        if (this.form.getHead().getBounds().height == 0 || arrayList.isEmpty() || arrayList == null) {
            this.form.setMessage(null, 0);
            return;
        }
        ArrayList arrayList2 = this.createPeers(arrayList);
        int n = ((IMessage)arrayList2.get(0)).getMessageType();
        IMessage[] iMessageArray = arrayList2.toArray(new IMessage[arrayList2.size()]);
        if (arrayList2.size() == 1 && ((Message)arrayList2.get((int)0)).prefix == null) {
            IMessage iMessage = (IMessage)arrayList2.get(0);
            String string = iMessage.getMessage();
            this.form.setMessage(string, n, iMessageArray);
        } else {
            String string = arrayList2.size() > 1 ? Messages.bind((String)MULTIPLE_MESSAGE_SUMMARY_KEYS[n], (Object[])new String[]{String.valueOf(arrayList2.size())}) : SINGLE_MESSAGE_SUMMARY_KEYS[n];
            this.form.setMessage(string, n, iMessageArray);
        }
    }

    private static String getFullMessage(IMessage iMessage) {
        if (iMessage.getPrefix() == null) {
            return iMessage.getMessage();
        }
        return String.valueOf(iMessage.getPrefix()) + iMessage.getMessage();
    }

    private ArrayList createPeers(ArrayList arrayList) {
        ArrayList<Message> arrayList2 = new ArrayList<Message>();
        int n = 0;
        int n2 = 0;
        while (n2 < arrayList.size()) {
            Message message = (Message)arrayList.get(n2);
            if (message.type > n) {
                arrayList2.clear();
                n = message.type;
            }
            if (message.type == n) {
                arrayList2.add(message);
            }
            ++n2;
        }
        return arrayList2;
    }

    private String createDetails(ArrayList arrayList, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = 0;
        while (n < arrayList.size()) {
            if (n > 0) {
                printWriter.println();
            }
            IMessage iMessage = (IMessage)arrayList.get(n);
            printWriter.print(bl ? iMessage.getMessage() : MessageManager.getFullMessage(iMessage));
            ++n;
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    public static String createDetails(IMessage[] iMessageArray) {
        if (iMessageArray == null || iMessageArray.length == 0) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = 0;
        while (n < iMessageArray.length) {
            if (n > 0) {
                printWriter.println();
            }
            printWriter.print(MessageManager.getFullMessage(iMessageArray[n]));
            ++n;
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    @Override
    public String createSummary(IMessage[] iMessageArray) {
        return MessageManager.createDetails(iMessageArray);
    }

    private void pruneControlDecorators() {
        Iterator iterator = this.decorators.values().iterator();
        while (iterator.hasNext()) {
            ControlDecorator controlDecorator = (ControlDecorator)iterator.next();
            if (!controlDecorator.isDisposed()) continue;
            iterator.remove();
        }
    }

    @Override
    public IMessagePrefixProvider getMessagePrefixProvider() {
        return this.prefixProvider;
    }

    @Override
    public void setMessagePrefixProvider(IMessagePrefixProvider iMessagePrefixProvider) {
        this.prefixProvider = iMessagePrefixProvider;
        for (ControlDecorator controlDecorator : this.decorators.values()) {
            controlDecorator.updatePrefix();
        }
    }

    @Override
    public int getDecorationPosition() {
        return this.decorationPosition;
    }

    @Override
    public void setDecorationPosition(int n) {
        this.decorationPosition = n;
        for (ControlDecorator controlDecorator : this.decorators.values()) {
            controlDecorator.updatePosition();
        }
    }

    @Override
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public void setAutoUpdate(boolean bl) {
        boolean bl2 = this.autoUpdate && !bl;
        boolean bl3 = !this.autoUpdate && bl;
        this.autoUpdate = bl;
        if (bl3 && this.isCacheChanged()) {
            this.update();
        }
        if (bl2) {
            this.oldMessages = new ArrayList();
            Object object = this.messages.iterator();
            while (object.hasNext()) {
                this.oldMessages.add(new Message((Message)object.next()));
            }
            this.oldDecorators = new Hashtable();
            object = this.decorators.keys();
            while (object.hasMoreElements()) {
                Object e = object.nextElement();
                this.oldDecorators.put(e, new ControlDecorator((ControlDecorator)this.decorators.get(e)));
            }
        }
    }

    private boolean isCacheChanged() {
        boolean bl = false;
        bl = this.checkMessageCache() || this.checkDecoratorCache();
        this.oldMessages.clear();
        this.oldMessages = null;
        this.oldDecorators.clear();
        this.oldDecorators = null;
        return bl;
    }

    private boolean checkMessageCache() {
        if (this.oldMessages == null) {
            return false;
        }
        if (this.messages.size() != this.oldMessages.size()) {
            return true;
        }
        return !this.oldMessages.containsAll(this.messages);
    }

    private boolean checkDecoratorCache() {
        if (this.oldDecorators == null) {
            return false;
        }
        for (Map.Entry entry : this.decorators.entrySet()) {
            ControlDecorator controlDecorator = (ControlDecorator)entry.getValue();
            ControlDecorator controlDecorator2 = (ControlDecorator)this.oldDecorators.get(controlDecorator.decoration.getControl());
            if ((controlDecorator2 != null || controlDecorator.controlMessages.size() <= 0) && (controlDecorator2 == null || controlDecorator.hasSameMessages(controlDecorator2))) continue;
            return true;
        }
        return false;
    }

    class ControlDecorator {
        private ControlDecoration decoration;
        private ArrayList controlMessages = new ArrayList();
        private String prefix;

        ControlDecorator(Control control) {
            this.decoration = new ControlDecoration(control, MessageManager.this.decorationPosition, MessageManager.this.form.getBody());
        }

        private ControlDecorator(ControlDecorator controlDecorator) {
            this.decoration = controlDecorator.decoration;
            this.prefix = controlDecorator.prefix;
            Iterator iterator = controlDecorator.controlMessages.iterator();
            while (iterator.hasNext()) {
                this.controlMessages.add(new Message((Message)iterator.next()));
            }
        }

        public boolean isDisposed() {
            return this.decoration.getControl() == null;
        }

        void updatePrefix() {
            this.prefix = null;
        }

        void updatePosition() {
            Control control = this.decoration.getControl();
            this.decoration.dispose();
            this.decoration = new ControlDecoration(control, MessageManager.this.decorationPosition, MessageManager.this.form.getBody());
            this.update();
        }

        String getPrefix() {
            if (this.prefix == null) {
                this.createPrefix();
            }
            return this.prefix;
        }

        private void createPrefix() {
            if (MessageManager.this.prefixProvider == null) {
                this.prefix = "";
                return;
            }
            this.prefix = MessageManager.this.prefixProvider.getPrefix(this.decoration.getControl());
            if (this.prefix == null) {
                this.prefix = "";
            }
        }

        void addAll(ArrayList arrayList) {
            arrayList.addAll(this.controlMessages);
        }

        void addMessage(Object object, String string, Object object2, int n) {
            Message message = MessageManager.this.addMessage(this.getPrefix(), object, string, object2, n, this.controlMessages);
            message.control = this.decoration.getControl();
            if (MessageManager.this.isAutoUpdate()) {
                this.update();
            }
        }

        boolean removeMessage(Object object) {
            Message message = MessageManager.this.findMessage(object, this.controlMessages);
            if (message != null) {
                this.controlMessages.remove(message);
                if (MessageManager.this.isAutoUpdate()) {
                    this.update();
                }
            }
            return message != null;
        }

        boolean removeMessages() {
            if (this.controlMessages.isEmpty()) {
                return false;
            }
            this.controlMessages.clear();
            if (MessageManager.this.isAutoUpdate()) {
                this.update();
            }
            return true;
        }

        public void update() {
            if (this.controlMessages.isEmpty()) {
                this.decoration.setDescriptionText(null);
                this.decoration.hide();
            } else {
                ArrayList arrayList = MessageManager.this.createPeers(this.controlMessages);
                int n = ((IMessage)arrayList.get(0)).getMessageType();
                String string = MessageManager.this.createDetails(MessageManager.this.createPeers(arrayList), true);
                if (n == 3) {
                    this.decoration.setImage(standardError.getImage());
                } else if (n == 2) {
                    this.decoration.setImage(standardWarning.getImage());
                } else if (n == 1) {
                    this.decoration.setImage(standardInformation.getImage());
                }
                this.decoration.setDescriptionText(string);
                this.decoration.show();
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof ControlDecorator)) {
                return false;
            }
            ControlDecorator controlDecorator = (ControlDecorator)object;
            if (!controlDecorator.decoration.equals(this.decoration)) {
                return false;
            }
            return controlDecorator.getPrefix().equals(this.getPrefix());
        }

        boolean hasSameMessages(ControlDecorator controlDecorator) {
            if (controlDecorator.controlMessages.size() != this.controlMessages.size()) {
                return false;
            }
            return controlDecorator.controlMessages.containsAll(this.controlMessages);
        }
    }

    static class DefaultPrefixProvider
    implements IMessagePrefixProvider {
        DefaultPrefixProvider() {
        }

        @Override
        public String getPrefix(Control control) {
            Composite composite = control.getParent();
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == control) {
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        Control control2 = controlArray[n2];
                        String string = null;
                        if (control2 instanceof Label) {
                            string = ((Label)control2).getText();
                        } else if (control2 instanceof Hyperlink) {
                            string = ((Hyperlink)control2).getText();
                        } else if (control2 instanceof CLabel) {
                            string = ((CLabel)control2).getText();
                        }
                        if (string != null) {
                            if (!string.endsWith(":")) {
                                return String.valueOf(string) + ": ";
                            }
                            return String.valueOf(string) + " ";
                        }
                        --n2;
                    }
                    break;
                }
                ++n;
            }
            return null;
        }
    }

    static class Message
    implements IMessage {
        Control control;
        Object data;
        Object key;
        String message;
        int type;
        String prefix;

        Message(Object object, String string, int n, Object object2) {
            this.key = object;
            this.message = string;
            this.type = n;
            this.data = object2;
        }

        private Message(Message message) {
            this.key = message.key;
            this.message = message.message;
            this.type = message.type;
            this.data = message.data;
            this.prefix = message.prefix;
            this.control = message.control;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.type;
        }

        @Override
        public Control getControl() {
            return this.control;
        }

        @Override
        public Object getData() {
            return this.data;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Message)) {
                return false;
            }
            Message message = (Message)object;
            return (message.getPrefix() == null ? this.getPrefix() == null : message.getPrefix().equals(this.getPrefix())) && (message.getControl() == null ? this.getControl() == null : message.getControl().equals(this.getControl())) && message.getMessageType() == this.getMessageType() && (message.getMessage() == null ? this.getMessage() == null : message.getMessage().equals(this.getMessage())) && message.getKey().equals(this.getKey());
        }
    }
}

