/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.internal.forms.Messages;

public abstract class ToggleHyperlink
extends AbstractHyperlink {
    protected int innerWidth;
    protected int innerHeight;
    protected boolean hover;
    private boolean expanded;
    private Color decorationColor;
    private Color hoverColor;

    public ToggleHyperlink(Composite composite, int n) {
        super(composite, n);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 6: {
                        ToggleHyperlink.this.hover = true;
                        ToggleHyperlink.this.redraw();
                        break;
                    }
                    case 7: {
                        ToggleHyperlink.this.hover = false;
                        ToggleHyperlink.this.redraw();
                        break;
                    }
                    case 1: {
                        ToggleHyperlink.this.onKeyDown(event);
                    }
                }
            }
        };
        this.addListener(6, listener);
        this.addListener(7, listener);
        this.addListener(1, listener);
        this.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                ToggleHyperlink.this.setExpanded(!ToggleHyperlink.this.isExpanded());
            }
        });
        this.initAccessible();
    }

    public void setDecorationColor(Color color) {
        this.decorationColor = color;
    }

    public Color getDecorationColor() {
        return this.decorationColor;
    }

    public void setHoverDecorationColor(Color color) {
        this.hoverColor = color;
    }

    public Color getHoverDecorationColor() {
        return this.hoverColor;
    }

    public Color geHoverDecorationColor() {
        return this.hoverColor;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = this.innerWidth + 2 * this.marginWidth;
        int n4 = this.innerHeight + 2 * this.marginHeight;
        return new Point(n3, n4);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
        this.redraw();
    }

    private void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = ToggleHyperlink.this.getToolTipText();
            }

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Messages.ToggleHyperlink_accessibleName;
            }

            public void getDescription(AccessibleEvent accessibleEvent) {
                this.getName(accessibleEvent);
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = ToggleHyperlink.this.toControl(new Point(accessibleControlEvent.x, accessibleControlEvent.y));
                if (ToggleHyperlink.this.getBounds().contains(point)) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = ToggleHyperlink.this.getBounds();
                Point point = ToggleHyperlink.this.toDisplay(new Point(rectangle.x, rectangle.y));
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                if (ToggleHyperlink.this.getSelection()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                if (ToggleHyperlink.this.getSelection()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 35;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = ToggleHyperlink.this.isExpanded() ? 512 : 1024;
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                if (accessibleControlEvent.childID == -1) {
                    int n;
                    String string = Messages.ToggleHyperlink_accessibleName;
                    if (ToggleHyperlink.this.getParent() instanceof ExpandableComposite && (n = (string = String.valueOf(Messages.ToggleHyperlink_accessibleColumn) + ((ExpandableComposite)ToggleHyperlink.this.getParent()).getText()).indexOf(38)) != -1) {
                        string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
                    }
                    accessibleControlEvent.result = string;
                }
            }
        });
    }

    @Override
    void triggerAccessible() {
        this.getAccessible().setFocus(this.getAccessibleChildID());
    }

    private int getAccessibleChildID() {
        return this.isExpanded() ? 1 : 2;
    }

    private void onKeyDown(Event event) {
        if (event.keyCode == 0x1000004) {
            if (!this.isExpanded()) {
                this.handleActivate(event);
            }
            event.doit = false;
        } else if (event.keyCode == 0x1000003) {
            if (this.isExpanded()) {
                this.handleActivate(event);
            }
            event.doit = false;
        }
    }
}

