/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.LayoutCache;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.forms.widgets.TableWrapData;

public final class TableWrapLayout
extends Layout
implements ILayoutExtension {
    public int numColumns = 1;
    public int leftMargin = 5;
    public int rightMargin = 5;
    public int topMargin = 5;
    public int bottomMargin = 5;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    public boolean makeColumnsEqualWidth = false;
    private boolean initialLayout = true;
    private Vector grid = null;
    private Hashtable rowspans;
    private int[] minColumnWidths;
    private int[] maxColumnWidths;
    private int widestColumnWidth;
    private int[] growingColumns;
    private int[] growingRows;
    private LayoutCache cache = new LayoutCache();

    @Override
    public int computeMinimumWidth(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren();
        if (bl) {
            this.cache.flush();
        }
        this.cache.setControls(controlArray);
        bl = true;
        this.initializeIfNeeded(composite, bl);
        if (this.initialLayout) {
            bl = true;
            this.initialLayout = false;
        }
        if (this.grid == null || bl) {
            bl = true;
            this.grid = new Vector();
            this.createGrid(composite);
        }
        if (this.minColumnWidths == null) {
            this.minColumnWidths = new int[this.numColumns];
        }
        int n = 0;
        while (n < this.numColumns) {
            this.minColumnWidths[n] = 0;
            ++n;
        }
        return this.internalGetMinimumWidth(composite, bl);
    }

    @Override
    public int computeMaximumWidth(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren();
        if (bl) {
            this.cache.flush();
        }
        this.cache.setControls(controlArray);
        bl = true;
        this.initializeIfNeeded(composite, bl);
        if (this.initialLayout) {
            bl = true;
            this.initialLayout = false;
        }
        if (this.grid == null || bl) {
            bl = true;
            this.grid = new Vector();
            this.createGrid(composite);
        }
        if (this.maxColumnWidths == null) {
            this.maxColumnWidths = new int[this.numColumns];
        }
        int n = 0;
        while (n < this.numColumns) {
            this.maxColumnWidths[n] = 0;
            ++n;
        }
        return this.internalGetMaximumWidth(composite, bl);
    }

    protected void layout(Composite composite, boolean bl) {
        int n;
        int n2;
        int n3;
        int[] nArray;
        Rectangle rectangle = composite.getClientArea();
        Control[] controlArray = composite.getChildren();
        if (bl) {
            this.cache.flush();
        }
        if (controlArray.length == 0) {
            return;
        }
        this.cache.setControls(controlArray);
        int n4 = rectangle.width;
        bl = true;
        this.initializeIfNeeded(composite, bl);
        if (this.initialLayout) {
            bl = true;
            this.initialLayout = false;
        }
        if (this.grid == null || bl) {
            bl = true;
            this.grid = new Vector();
            this.createGrid(composite);
        }
        this.resetColumnWidths();
        int n5 = this.internalGetMinimumWidth(composite, bl);
        int n6 = this.internalGetMaximumWidth(composite, bl);
        int n7 = n4;
        if (n4 <= n5) {
            n7 = n5;
            if (this.makeColumnsEqualWidth) {
                nArray = new int[this.numColumns];
                n3 = 0;
                while (n3 < this.numColumns) {
                    nArray[n3] = this.widestColumnWidth;
                    ++n3;
                }
            } else {
                nArray = this.minColumnWidths;
            }
        } else if (n4 > n6) {
            if (this.growingColumns.length == 0) {
                n7 = n6;
                nArray = this.maxColumnWidths;
            } else {
                nArray = new int[this.numColumns];
                n3 = n4 - n6;
                n2 = n3 / this.growingColumns.length;
                n = 0;
                while (n < this.numColumns) {
                    nArray[n] = this.maxColumnWidths[n];
                    if (this.isGrowingColumn(n)) {
                        int n8 = n;
                        nArray[n8] = nArray[n8] + n2;
                    }
                    ++n;
                }
            }
        } else {
            nArray = new int[this.numColumns];
            if (this.makeColumnsEqualWidth) {
                n3 = n7 - this.leftMargin - this.rightMargin;
                n2 = (n3 -= (this.numColumns - 1) * this.horizontalSpacing) / this.numColumns;
                n = 0;
                while (n < this.numColumns) {
                    nArray[n] = n2;
                    ++n;
                }
            } else {
                nArray = this.assignExtraSpace(n7, n6, n5);
            }
        }
        n3 = this.topMargin + rectangle.y;
        int[] nArray2 = this.computeRowHeights(controlArray, nArray, bl);
        n = 0;
        while (n < this.grid.size()) {
            int n9 = nArray2[n];
            int n10 = this.leftMargin + rectangle.x;
            TableWrapData[] tableWrapDataArray = (TableWrapData[])this.grid.elementAt(n);
            int n11 = 0;
            while (n11 < this.numColumns) {
                TableWrapData tableWrapData = tableWrapDataArray[n11];
                if (tableWrapData.isItemData) {
                    Control control = controlArray[tableWrapData.childIndex];
                    this.placeControl(control, tableWrapData, n10, n3, nArray2, n);
                }
                n10 += nArray[n11];
                if (n11 < this.numColumns - 1) {
                    n10 += this.horizontalSpacing;
                }
                ++n11;
            }
            n3 += n9 + this.verticalSpacing;
            ++n;
        }
    }

    int[] computeRowHeights(Control[] controlArray, int[] nArray, boolean bl) {
        int n;
        Object object;
        int n2;
        Object object2;
        int[] nArray2 = new int[this.grid.size()];
        int n3 = 0;
        while (n3 < this.grid.size()) {
            object2 = (TableWrapData[])this.grid.elementAt(n3);
            nArray2[n3] = 0;
            n2 = 0;
            while (n2 < this.numColumns) {
                object = object2[n2];
                if (((TableWrapData)object).isItemData) {
                    Control control = controlArray[((TableWrapData)object).childIndex];
                    int n4 = ((TableWrapData)object).colspan;
                    n = 0;
                    int n5 = n2;
                    while (n5 < n2 + n4) {
                        n += nArray[n5];
                        if (n5 < n2 + n4 - 1) {
                            n += this.horizontalSpacing;
                        }
                        ++n5;
                    }
                    Point point = this.computeSize(((TableWrapData)object).childIndex, n, ((TableWrapData)object).indent, ((TableWrapData)object).maxWidth, ((TableWrapData)object).maxHeight);
                    ((TableWrapData)object).compWidth = n;
                    if (((TableWrapData)object).heightHint != -1) {
                        point = new Point(point.x, ((TableWrapData)object).heightHint);
                    }
                    ((TableWrapData)object).compSize = point;
                    RowSpan rowSpan = (RowSpan)this.rowspans.get(control);
                    if (rowSpan == null) {
                        nArray2[n3] = Math.max(nArray2[n3], point.y);
                    } else {
                        rowSpan.height = point.y;
                    }
                }
                ++n2;
            }
            this.updateRowSpans(n3, nArray2[n3]);
            ++n3;
        }
        Enumeration enumeration = this.rowspans.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (RowSpan)enumeration.nextElement();
            n2 = ((RowSpan)object2).getRequiredHeightIncrease();
            if (n2 == 0) continue;
            object = (TableWrapData)((RowSpan)object2).child.getLayoutData();
            int n6 = 0;
            int[] nArray3 = new int[this.grid.size()];
            n = 0;
            while (n < this.growingRows.length) {
                int n7 = this.growingRows[n];
                if (n7 >= ((RowSpan)object2).row && n7 < ((RowSpan)object2).row + ((TableWrapData)object).rowspan) {
                    nArray3[n6++] = n7;
                }
                ++n;
            }
            if (n6 == 0) {
                n6 = 1;
                nArray3[0] = ((RowSpan)object2).row + ((TableWrapData)object).rowspan - 1;
            }
            n2 += n2 % n6;
            n = n2 / n6;
            int n8 = 0;
            while (n8 < n6) {
                int n9;
                int n10 = n9 = nArray3[n8];
                nArray2[n10] = nArray2[n10] + n;
                ++n8;
            }
        }
        return nArray2;
    }

    boolean isGrowingColumn(int n) {
        if (this.growingColumns == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.growingColumns.length) {
            if (n == this.growingColumns[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    int[] assignExtraSpace(int n, int n2, int n3) {
        int n4 = this.leftMargin + this.rightMargin + (this.numColumns - 1) * this.horizontalSpacing;
        int n5 = n2 - n3;
        int n6 = n - n3;
        int[] nArray = new int[this.numColumns];
        int n7 = 0;
        int n8 = 0;
        while (n8 < this.numColumns) {
            int n9;
            int n10 = this.minColumnWidths[n8];
            int n11 = this.maxColumnWidths[n8];
            int n12 = n11 - n10;
            int n13 = n9 = n5 != 0 ? n12 * n6 / n5 : 0;
            if (n8 < this.numColumns - 1) {
                nArray[n8] = n10 + n9;
                n7 += nArray[n8];
            } else {
                nArray[n8] = n - n4 - n7;
            }
            ++n8;
        }
        return nArray;
    }

    Point computeSize(int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 - n3;
        SizeCache sizeCache = this.cache.getCache(n);
        if (!this.isWrap(sizeCache.getControl())) {
            n6 = -1;
        }
        Point point = sizeCache.computeSize(n6, -1);
        if (n4 != -1) {
            point.x = Math.min(point.x, n4);
        }
        if (n5 != -1) {
            point.y = Math.min(point.y, n5);
        }
        point.x += n3;
        return point;
    }

    void placeControl(Control control, TableWrapData tableWrapData, int n, int n2, int[] nArray, int n3) {
        int n4 = n + tableWrapData.indent;
        int n5 = n2;
        int n6 = tableWrapData.compSize.y;
        int n7 = tableWrapData.compWidth - tableWrapData.indent;
        int n8 = tableWrapData.compSize.x - tableWrapData.indent;
        n8 = Math.min(n8, n7);
        int n9 = nArray[n3];
        RowSpan rowSpan = (RowSpan)this.rowspans.get(control);
        if (rowSpan != null) {
            n9 = 0;
            int n10 = n3;
            while (n10 < n3 + tableWrapData.rowspan) {
                if (n10 > n3) {
                    n9 += this.verticalSpacing;
                }
                n9 += nArray[n10];
                ++n10;
            }
        }
        if (tableWrapData.align == 4) {
            n4 = n + n7 / 2 - n8 / 2;
        } else if (tableWrapData.align == 8) {
            n4 = n + n7 - n8;
        } else if (tableWrapData.align == 128) {
            n8 = n7;
        }
        if (tableWrapData.valign == 32) {
            n5 = n2 + n9 / 2 - n6 / 2;
        } else if (tableWrapData.valign == 64) {
            n5 = n2 + n9 - n6;
        } else if (tableWrapData.valign == 128) {
            n6 = n9;
        }
        control.setBounds(n4, n5, n8, n6);
    }

    void createGrid(Composite composite) {
        TableWrapData tableWrapData;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.rowspans = new Hashtable();
        Control[] controlArray = composite.getChildren();
        if (controlArray.length == 0) {
            return;
        }
        this.grid.addElement(this.createEmptyRow());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < controlArray.length) {
            int n4;
            Control control = controlArray[n3];
            TableWrapData tableWrapData2 = (TableWrapData)control.getLayoutData();
            while (((TableWrapData[])this.grid.elementAt(n))[n2] != null) {
                if (++n2 < this.numColumns) continue;
                n2 = 0;
                if (++n < this.grid.size()) continue;
                this.grid.addElement(this.createEmptyRow());
            }
            if (n2 + tableWrapData2.colspan - 1 >= this.numColumns) {
                this.grid.addElement(this.createEmptyRow());
                ++n;
                n2 = 0;
            }
            if (tableWrapData2.rowspan > 1) {
                this.rowspans.put(control, new RowSpan(control, n2, n));
            }
            int n5 = 2;
            while (n5 <= tableWrapData2.rowspan) {
                if (n + n5 > this.grid.size()) {
                    this.grid.addElement(this.createEmptyRow());
                }
                ++n5;
            }
            ((TableWrapData[])this.grid.elementAt((int)n))[n2] = tableWrapData2;
            tableWrapData2.childIndex = n3;
            if (tableWrapData2.grabHorizontal) {
                this.updateGrowingColumns(vector, tableWrapData2, n2);
            }
            if (tableWrapData2.grabVertical) {
                this.updateGrowingRows(vector2, tableWrapData2, n);
            }
            int n6 = tableWrapData2.rowspan - 1;
            int n7 = tableWrapData2.colspan - 1;
            n5 = 1;
            while (n5 <= n6) {
                n4 = 0;
                while (n4 < tableWrapData2.colspan) {
                    tableWrapData = new TableWrapData();
                    tableWrapData.isItemData = false;
                    ((TableWrapData[])this.grid.elementAt((int)(n + n5)))[n2 + n4] = tableWrapData;
                    ++n4;
                }
                ++n5;
            }
            n5 = 1;
            while (n5 <= n7) {
                n4 = 0;
                while (n4 < tableWrapData2.rowspan) {
                    tableWrapData = new TableWrapData();
                    tableWrapData.isItemData = false;
                    ((TableWrapData[])this.grid.elementAt((int)(n + n4)))[n2 + n5] = tableWrapData;
                    ++n4;
                }
                ++n5;
            }
            n2 = n2 + tableWrapData2.colspan - 1;
            ++n3;
        }
        n3 = n2 + 1;
        while (n3 < this.numColumns) {
            tableWrapData = new TableWrapData();
            tableWrapData.isItemData = false;
            ((TableWrapData[])this.grid.elementAt((int)n))[n3] = tableWrapData;
            ++n3;
        }
        n3 = n + 1;
        while (n3 < this.grid.size()) {
            tableWrapData = new TableWrapData();
            tableWrapData.isItemData = false;
            ((TableWrapData[])this.grid.elementAt((int)n3))[n2] = tableWrapData;
            ++n3;
        }
        this.growingColumns = new int[vector.size()];
        n3 = 0;
        while (n3 < vector.size()) {
            this.growingColumns[n3] = (Integer)vector.get(n3);
            ++n3;
        }
        this.growingRows = new int[vector2.size()];
        n3 = 0;
        while (n3 < vector2.size()) {
            this.growingRows[n3] = (Integer)vector2.get(n3);
            ++n3;
        }
    }

    private void updateGrowingColumns(Vector vector, TableWrapData tableWrapData, int n) {
        int n2 = n + tableWrapData.colspan - 1;
        int n3 = 0;
        while (n3 < vector.size()) {
            Integer n4 = (Integer)vector.get(n3);
            if (n4 == n2) {
                return;
            }
            ++n3;
        }
        vector.add(new Integer(n2));
    }

    private void updateGrowingRows(Vector vector, TableWrapData tableWrapData, int n) {
        int n2 = n + tableWrapData.rowspan - 1;
        int n3 = 0;
        while (n3 < vector.size()) {
            Integer n4 = (Integer)vector.get(n3);
            if (n4 == n2) {
                return;
            }
            ++n3;
        }
        vector.add(new Integer(n2));
    }

    private TableWrapData[] createEmptyRow() {
        TableWrapData[] tableWrapDataArray = new TableWrapData[this.numColumns];
        int n = 0;
        while (n < this.numColumns) {
            tableWrapDataArray[n] = null;
            ++n;
        }
        return tableWrapDataArray;
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int[] nArray;
        Control[] controlArray = composite.getChildren();
        if (bl) {
            this.cache.flush();
        }
        if (controlArray.length == 0) {
            return new Point(0, 0);
        }
        this.cache.setControls(controlArray);
        int n6 = n;
        bl = true;
        this.initializeIfNeeded(composite, bl);
        if (this.initialLayout) {
            bl = true;
            this.initialLayout = false;
        }
        if (this.grid == null || bl) {
            bl = true;
            this.grid = new Vector();
            this.createGrid(composite);
        }
        this.resetColumnWidths();
        int n7 = this.internalGetMinimumWidth(composite, bl);
        int n8 = this.internalGetMaximumWidth(composite, bl);
        if (n == -1) {
            n6 = n8;
        }
        int n9 = n6;
        if (n6 <= n7) {
            n9 = n7;
            if (this.makeColumnsEqualWidth) {
                nArray = new int[this.numColumns];
                n5 = 0;
                while (n5 < this.numColumns) {
                    nArray[n5] = this.widestColumnWidth;
                    ++n5;
                }
            } else {
                nArray = this.minColumnWidths;
            }
        } else if (n6 >= n8) {
            if (this.makeColumnsEqualWidth) {
                nArray = new int[this.numColumns];
                n5 = n6 - this.leftMargin - this.rightMargin;
                n4 = (n5 -= (this.numColumns - 1) * this.horizontalSpacing) / this.numColumns;
                n3 = 0;
                while (n3 < this.numColumns) {
                    nArray[n3] = n4;
                    ++n3;
                }
            } else {
                n9 = n8;
                nArray = this.maxColumnWidths;
            }
        } else {
            nArray = new int[this.numColumns];
            if (this.makeColumnsEqualWidth) {
                n5 = n9 - this.leftMargin - this.rightMargin;
                n4 = (n5 -= (this.numColumns - 1) * this.horizontalSpacing) / this.numColumns;
                n3 = 0;
                while (n3 < this.numColumns) {
                    nArray[n3] = n4;
                    ++n3;
                }
            } else {
                nArray = this.assignExtraSpace(n9, n8, n7);
            }
        }
        n5 = 0;
        n4 = 0;
        n3 = 0;
        while (n3 < this.grid.size()) {
            TableWrapData[] tableWrapDataArray = (TableWrapData[])this.grid.elementAt(n3);
            int n10 = 0;
            int n11 = 0;
            while (n11 < this.numColumns) {
                TableWrapData tableWrapData = tableWrapDataArray[n11];
                if (tableWrapData.isItemData) {
                    RowSpan rowSpan;
                    Control control = controlArray[tableWrapData.childIndex];
                    int n12 = tableWrapData.colspan;
                    int n13 = 0;
                    int n14 = n11;
                    while (n14 < n11 + n12) {
                        if (n14 > n11) {
                            n13 += this.horizontalSpacing;
                        }
                        n13 += nArray[n14];
                        ++n14;
                    }
                    n14 = tableWrapData.heightHint;
                    if (n14 == -1) {
                        rowSpan = this.computeSize(tableWrapData.childIndex, n13, tableWrapData.indent, tableWrapData.maxWidth, tableWrapData.maxHeight);
                        n14 = ((Point)rowSpan).y;
                    }
                    if ((rowSpan = (RowSpan)this.rowspans.get(control)) != null) {
                        rowSpan.height = n14;
                    } else {
                        n10 = Math.max(n10, n14);
                    }
                }
                ++n11;
            }
            this.updateRowSpans(n3, n10);
            if (n3 > 0) {
                n4 += this.verticalSpacing;
            }
            n4 += n10;
            ++n3;
        }
        if (!this.rowspans.isEmpty()) {
            n4 = this.compensateForRowSpans(n4);
        }
        n5 = this.topMargin + n4 + this.bottomMargin;
        return new Point(n9, n5);
    }

    private void updateRowSpans(int n, int n2) {
        if (this.rowspans == null || this.rowspans.size() == 0) {
            return;
        }
        Enumeration enumeration = this.rowspans.elements();
        while (enumeration.hasMoreElements()) {
            RowSpan rowSpan = (RowSpan)enumeration.nextElement();
            rowSpan.update(n, n2);
        }
    }

    private int compensateForRowSpans(int n) {
        Enumeration enumeration = this.rowspans.elements();
        while (enumeration.hasMoreElements()) {
            RowSpan rowSpan = (RowSpan)enumeration.nextElement();
            n += rowSpan.getRequiredHeightIncrease();
        }
        return n;
    }

    int internalGetMinimumWidth(Composite composite, boolean bl) {
        int n;
        if (bl) {
            this.calculateColumnWidths(composite, this.minColumnWidths, false, true, this.makeColumnsEqualWidth);
        }
        int n2 = 0;
        this.widestColumnWidth = 0;
        if (this.makeColumnsEqualWidth) {
            n = 0;
            while (n < this.numColumns) {
                this.widestColumnWidth = Math.max(this.widestColumnWidth, this.minColumnWidths[n]);
                ++n;
            }
        }
        n = 0;
        while (n < this.numColumns) {
            if (n > 0) {
                n2 += this.horizontalSpacing;
            }
            n2 = this.makeColumnsEqualWidth ? (n2 += this.widestColumnWidth) : (n2 += this.minColumnWidths[n]);
            ++n;
        }
        return n2 += this.leftMargin + this.rightMargin;
    }

    int internalGetMaximumWidth(Composite composite, boolean bl) {
        if (bl) {
            this.calculateColumnWidths(composite, this.maxColumnWidths, true, true, this.makeColumnsEqualWidth);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.numColumns) {
            if (n2 > 0) {
                n += this.horizontalSpacing;
            }
            n += this.maxColumnWidths[n2];
            ++n2;
        }
        return n += this.leftMargin + this.rightMargin;
    }

    void resetColumnWidths() {
        if (this.minColumnWidths == null) {
            this.minColumnWidths = new int[this.numColumns];
        }
        if (this.maxColumnWidths == null) {
            this.maxColumnWidths = new int[this.numColumns];
        }
        int n = 0;
        while (n < this.numColumns) {
            this.minColumnWidths[n] = 0;
            ++n;
        }
        n = 0;
        while (n < this.numColumns) {
            this.maxColumnWidths[n] = 0;
            ++n;
        }
    }

    void calculateColumnWidths(Composite composite, int[] nArray, boolean bl, boolean bl2, boolean bl3) {
        int n;
        SizeCache sizeCache;
        TableWrapData tableWrapData;
        int n2;
        TableWrapData[] tableWrapDataArray;
        boolean bl4 = false;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.grid.size()) {
            tableWrapDataArray = (TableWrapData[])this.grid.elementAt(n4);
            n2 = 0;
            while (n2 < this.numColumns) {
                tableWrapData = tableWrapDataArray[n2];
                if (tableWrapData.isItemData) {
                    if (tableWrapData.colspan > 1) {
                        bl4 = true;
                        n2 += tableWrapData.colspan - 1;
                    } else {
                        sizeCache = this.cache.getCache(tableWrapData.childIndex);
                        int n5 = n = bl ? sizeCache.computeMaximumWidth() : sizeCache.computeMinimumWidth();
                        if (tableWrapData.maxWidth != -1) {
                            n = Math.min(n, tableWrapData.maxWidth);
                        }
                        nArray[n2] = Math.max(nArray[n2], n += tableWrapData.indent);
                        n3 = Math.max(n3, nArray[n2]);
                    }
                }
                ++n2;
            }
            ++n4;
        }
        if (this.makeColumnsEqualWidth) {
            n4 = 0;
            while (n4 < this.numColumns) {
                nArray[n4] = n3;
                ++n4;
            }
        }
        if (!bl4) {
            return;
        }
        n4 = 0;
        while (n4 < this.grid.size()) {
            tableWrapDataArray = (TableWrapData[])this.grid.elementAt(n4);
            n2 = 0;
            while (n2 < this.numColumns) {
                tableWrapData = tableWrapDataArray[n2];
                if (tableWrapData.isItemData && tableWrapData.colspan != 1) {
                    sizeCache = this.cache.getCache(tableWrapData.childIndex);
                    int n6 = n = bl ? sizeCache.computeMaximumWidth() : sizeCache.computeMinimumWidth();
                    if (tableWrapData.maxWidth != -1) {
                        n = Math.min(n, tableWrapData.maxWidth);
                    }
                    n += tableWrapData.indent;
                    int n7 = 0;
                    int n8 = n2;
                    while (n8 < n2 + tableWrapData.colspan) {
                        if (n8 > n2) {
                            n7 += this.horizontalSpacing;
                        }
                        n7 += nArray[n8];
                        ++n8;
                    }
                    if (n > n7) {
                        int n9;
                        n8 = 0;
                        if (this.growingColumns != null) {
                            n9 = n2;
                            while (n9 < n2 + tableWrapData.colspan) {
                                if (this.isGrowingColumn(n9)) {
                                    ++n8;
                                }
                                ++n9;
                            }
                        }
                        if (n8 == 0) {
                            int n10 = n2 + tableWrapData.colspan - 1;
                            nArray[n10] = nArray[n10] + (n - n7);
                        } else {
                            n9 = (n - n7) / n8;
                            if ((n - n7) % n8 > 0) {
                                ++n9;
                            }
                            int n11 = n2;
                            while (n11 < n2 + tableWrapData.colspan) {
                                if (this.isGrowingColumn(n11)) {
                                    int n12 = n11;
                                    nArray[n12] = nArray[n12] + n9;
                                }
                                ++n11;
                            }
                        }
                    }
                }
                ++n2;
            }
            ++n4;
        }
    }

    boolean isWrap(Control control) {
        if (control instanceof Composite && ((Composite)control).getLayout() instanceof ILayoutExtension) {
            return true;
        }
        return (control.getStyle() & 0x40) != 0;
    }

    private void initializeIfNeeded(Composite composite, boolean bl) {
        if (bl) {
            this.initialLayout = true;
        }
        if (this.initialLayout) {
            this.initializeLayoutData(composite);
            this.initialLayout = false;
        }
    }

    void initializeLayoutData(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control.getLayoutData() == null) {
                control.setLayoutData((Object)new TableWrapData());
            }
            ++n;
        }
    }

    private class RowSpan {
        Control child;
        int row;
        int height;
        int totalHeight;

        public RowSpan(Control control, int n, int n2) {
            this.child = control;
            this.row = n2;
        }

        public void update(int n, int n2) {
            TableWrapData tableWrapData = (TableWrapData)this.child.getLayoutData();
            if (n >= this.row && n < this.row + tableWrapData.rowspan) {
                this.totalHeight += n2;
                if (n > this.row) {
                    this.totalHeight += TableWrapLayout.this.verticalSpacing;
                }
            }
        }

        public int getRequiredHeightIncrease() {
            if (this.totalHeight < this.height) {
                return this.height - this.totalHeight;
            }
            return 0;
        }
    }
}

