/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class SizeCache {
    private Control control;
    private Point preferredSize;
    private int cachedWidthQuery;
    private int cachedWidthResult;
    private int cachedHeightQuery;
    private int cachedHeightResult;
    private int minimumWidth;
    private int heightAtMinimumWidth = -1;
    private int maximumWidth;
    private boolean flushChildren;
    private boolean independentDimensions = false;
    private boolean preferredWidthOrLargerIsMinimumHeight = false;
    private int widthAdjustment = 0;
    private int heightAdjustment = 0;
    private int minimumHeight;
    private int widthAtMinimumHeight = -1;
    private Point dirtySize = null;

    public SizeCache() {
        this(null);
    }

    public SizeCache(Control control) {
        this.setControl(control);
    }

    public void setControl(Control control) {
        if (control != this.control) {
            this.control = control;
            if (this.control == null) {
                this.independentDimensions = true;
                this.preferredWidthOrLargerIsMinimumHeight = false;
                this.widthAdjustment = 0;
                this.heightAdjustment = 0;
            } else {
                this.independentDimensions = SizeCache.independentLengthAndWidth(this.control);
                this.preferredWidthOrLargerIsMinimumHeight = SizeCache.isPreferredWidthMaximum(this.control);
                this.computeHintOffset(this.control);
                this.flush();
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void flush() {
        this.flush(true);
    }

    public void flush(boolean bl) {
        this.preferredSize = null;
        this.cachedWidthQuery = -1;
        this.cachedWidthResult = -1;
        this.cachedHeightQuery = -1;
        this.cachedHeightResult = -1;
        this.minimumWidth = -1;
        this.maximumWidth = -1;
        this.minimumHeight = -1;
        this.heightAtMinimumWidth = -1;
        this.widthAtMinimumHeight = -1;
        if (bl || this.dirtySize != null) {
            if (this.control == null || this.control.isDisposed()) {
                this.dirtySize = new Point(0, 0);
                this.control = null;
            } else {
                this.dirtySize = this.control.getSize();
            }
        }
        this.flushChildren = this.flushChildren || bl;
    }

    private Point getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = this.controlComputeSize(-1, -1);
        }
        return this.preferredSize;
    }

    public Point computeSize(int n, int n2) {
        if (this.control == null || this.control.isDisposed()) {
            return new Point(0, 0);
        }
        int n3 = this.computeMinimumWidth();
        if (n != -1 && n + this.widthAdjustment < n3) {
            if (n2 == -1) {
                return new Point(n3, this.computeHeightAtMinimumWidth());
            }
            n = n3 - this.widthAdjustment;
        }
        int n4 = this.computeMinimumHeight();
        if (n2 != -1 && n2 + this.heightAdjustment < n4) {
            if (n == -1) {
                return new Point(this.computeWidthAtMinimumHeight(), n4);
            }
            n2 = n4 - this.heightAdjustment;
        }
        if (n != -1 && n2 != -1) {
            return new Point(n + this.widthAdjustment, n2 + this.heightAdjustment);
        }
        if (n == -1 && n2 == -1) {
            return Geometry.copy((Point)this.getPreferredSize());
        }
        if (this.independentDimensions) {
            Point point = Geometry.copy((Point)this.getPreferredSize());
            if (n != -1) {
                point.x = n + this.widthAdjustment;
            }
            if (n2 != -1) {
                point.y = n2 + this.heightAdjustment;
            }
            return point;
        }
        if (n2 == -1) {
            if (this.preferredSize != null && n + this.widthAdjustment == this.preferredSize.x) {
                return Geometry.copy((Point)this.preferredSize);
            }
            if (this.cachedHeightQuery != -1 && this.cachedHeightQuery == n) {
                return new Point(n + this.widthAdjustment, this.cachedHeightResult);
            }
            if (this.preferredWidthOrLargerIsMinimumHeight) {
                this.getPreferredSize();
                if (n + this.widthAdjustment >= this.preferredSize.x) {
                    return new Point(n + this.widthAdjustment, this.preferredSize.y);
                }
            }
            Point point = this.controlComputeSize(n - this.widthAdjustment, -1);
            this.cachedHeightQuery = n2;
            this.cachedHeightResult = point.y;
            return point;
        }
        if (n == -1) {
            if (this.preferredSize != null && n2 + this.heightAdjustment == this.preferredSize.y) {
                return Geometry.copy((Point)this.preferredSize);
            }
            if (this.cachedWidthQuery == n2) {
                return new Point(this.cachedWidthResult, n2 + this.heightAdjustment);
            }
            Point point = this.controlComputeSize(-1, n2 - this.heightAdjustment);
            this.cachedWidthQuery = n2;
            this.cachedWidthResult = point.x;
            return point;
        }
        return this.controlComputeSize(n, n2);
    }

    public Point computeAdjustedSize(int n, int n2) {
        int n3 = n == -1 ? -1 : Math.max(0, n - this.widthAdjustment);
        int n4 = n2 == -1 ? -1 : Math.max(0, n2 - this.heightAdjustment);
        Point point = this.computeSize(n3, n4);
        return point;
    }

    static boolean independentLengthAndWidth(Control control) {
        if (control == null || control.isDisposed()) {
            return true;
        }
        if (control instanceof Button || control instanceof ProgressBar || control instanceof Sash || control instanceof Scale || control instanceof Slider || control instanceof List || control instanceof Combo || control instanceof Tree) {
            return true;
        }
        if (control instanceof Label || control instanceof Text) {
            return (control.getStyle() & 0x40) == 0;
        }
        return false;
    }

    private void computeHintOffset(Control control) {
        if (control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)control;
            Rectangle rectangle = scrollable.computeTrim(0, 0, 0, 0);
            this.widthAdjustment = rectangle.width;
            this.heightAdjustment = rectangle.height;
        } else {
            this.heightAdjustment = this.widthAdjustment = control.getBorderWidth() * 2;
        }
    }

    private Point controlComputeSize(int n, int n2) {
        Point point = this.control.computeSize(n, n2, this.flushChildren);
        this.flushChildren = false;
        return point;
    }

    private static boolean isPreferredWidthMaximum(Control control) {
        return control instanceof ToolBar || control instanceof Label;
    }

    public int computeMinimumWidth() {
        Layout layout;
        if (this.minimumWidth == -1 && this.control instanceof Composite && (layout = ((Composite)this.control).getLayout()) instanceof ILayoutExtension) {
            this.minimumWidth = ((ILayoutExtension)layout).computeMinimumWidth((Composite)this.control, this.flushChildren);
            this.flushChildren = false;
        }
        if (this.minimumWidth == -1) {
            layout = this.controlComputeSize(FormUtil.getWidthHint(5, this.control), -1);
            this.minimumWidth = layout.x;
            this.heightAtMinimumWidth = layout.y;
        }
        return this.minimumWidth;
    }

    public int computeMaximumWidth() {
        Layout layout;
        if (this.maximumWidth == -1 && this.control instanceof Composite && (layout = ((Composite)this.control).getLayout()) instanceof ILayoutExtension) {
            this.maximumWidth = ((ILayoutExtension)layout).computeMaximumWidth((Composite)this.control, this.flushChildren);
            this.flushChildren = false;
        }
        if (this.maximumWidth == -1) {
            this.maximumWidth = this.getPreferredSize().x;
        }
        return this.maximumWidth;
    }

    private int computeHeightAtMinimumWidth() {
        int n = this.computeMinimumWidth();
        if (this.heightAtMinimumWidth == -1) {
            this.heightAtMinimumWidth = this.controlComputeSize((int)(n - this.widthAdjustment), (int)-1).y;
        }
        return this.heightAtMinimumWidth;
    }

    private int computeWidthAtMinimumHeight() {
        int n = this.computeMinimumHeight();
        if (this.widthAtMinimumHeight == -1) {
            this.widthAtMinimumHeight = this.controlComputeSize((int)-1, (int)(n - this.heightAdjustment)).x;
        }
        return this.widthAtMinimumHeight;
    }

    private int computeMinimumHeight() {
        if (this.minimumHeight == -1) {
            Point point = this.controlComputeSize(-1, 0);
            this.minimumHeight = point.y;
            this.widthAtMinimumHeight = point.x;
        }
        return this.minimumHeight;
    }

    public Point computeMinimumSize() {
        return new Point(this.computeMinimumWidth(), this.computeMinimumHeight());
    }

    public void setSize(Point point) {
        if (this.control != null) {
            this.control.setSize(point);
        }
        this.layoutIfNecessary();
    }

    public void setSize(int n, int n2) {
        if (this.control != null) {
            this.control.setSize(n, n2);
        }
        this.layoutIfNecessary();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.control != null) {
            this.control.setBounds(n, n2, n3, n4);
        }
        this.layoutIfNecessary();
    }

    public void setBounds(Rectangle rectangle) {
        if (this.control != null) {
            this.control.setBounds(rectangle);
        }
        this.layoutIfNecessary();
    }

    public void layoutIfNecessary() {
        if (this.dirtySize != null && this.control != null && this.control instanceof Composite && this.control.getSize().equals((Object)this.dirtySize)) {
            ((Composite)this.control).layout(this.flushChildren);
            this.flushChildren = false;
        }
        this.dirtySize = null;
    }
}

