/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public abstract class SharedScrolledComposite
extends ScrolledComposite {
    private static final int H_SCROLL_INCREMENT = 5;
    private static final int V_SCROLL_INCREMENT = 64;
    private boolean ignoreLayouts = true;
    private boolean ignoreResizes = false;
    private boolean expandHorizontal = false;
    private boolean expandVertical = false;
    private SizeCache contentCache = new SizeCache();
    private boolean reflowPending = false;
    private boolean delayedReflow = false;

    public SharedScrolledComposite(Composite composite, int n) {
        super(composite, n);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (!SharedScrolledComposite.this.ignoreResizes) {
                    SharedScrolledComposite.this.scheduleReflow(false);
                }
            }
        });
        this.initializeScrollBars();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.getContent() != null) {
            this.getContent().setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.getContent() != null) {
            this.getContent().setBackground(color);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.getContent() != null) {
            this.getContent().setFont(font);
        }
    }

    public void setContent(Control control) {
        super.setContent(control);
        if (control != null) {
            control.setForeground(this.getForeground());
            control.setBackground(this.getBackground());
            control.setFont(this.getFont());
        }
    }

    public boolean setFocus() {
        FormUtil.setFocusScrollingEnabled((Control)this, false);
        boolean bl = this.getContent() != null ? this.getContent().setFocus() : super.setFocus();
        FormUtil.setFocusScrollingEnabled((Control)this, true);
        return bl;
    }

    public void layout(boolean bl) {
        if (this.ignoreLayouts) {
            return;
        }
        this.ignoreLayouts = true;
        this.ignoreResizes = true;
        super.layout(bl);
        this.ignoreResizes = false;
    }

    public void setExpandHorizontal(boolean bl) {
        this.expandHorizontal = bl;
        super.setExpandHorizontal(bl);
    }

    public void setExpandVertical(boolean bl) {
        this.expandVertical = bl;
        super.setExpandVertical(bl);
    }

    public void reflow(boolean bl) {
        ScrollBar scrollBar;
        Composite composite = (Composite)this.getContent();
        Rectangle rectangle = this.getClientArea();
        if (composite == null) {
            return;
        }
        if (rectangle.width == this.getSize().x && (scrollBar = this.getVerticalBar()) != null) {
            rectangle.width -= scrollBar.getSize().x;
        }
        this.contentCache.setControl((Control)composite);
        if (bl) {
            this.contentCache.flush();
        }
        scrollBar = this.contentCache.computeSize(FormUtil.getWidthHint(rectangle.width, (Control)composite), FormUtil.getHeightHint(rectangle.height, (Control)composite));
        if (!this.expandHorizontal || !this.expandVertical) {
            composite.setSize((Point)scrollBar);
        }
        this.setMinSize((Point)scrollBar);
        FormUtil.updatePageIncrement(this);
        ScrollBar scrollBar2 = this.getVerticalBar();
        if (scrollBar2 != null) {
            if (this.getClientArea().height - 5 < 64) {
                this.getVerticalBar().setIncrement(this.getClientArea().height - 5);
            } else {
                this.getVerticalBar().setIncrement(64);
            }
        }
        this.ignoreLayouts = false;
        this.layout(bl);
        this.ignoreLayouts = true;
        this.contentCache.layoutIfNecessary();
    }

    private void updateSizeWhilePending() {
        Control control = this.getContent();
        Rectangle rectangle = this.getClientArea();
        this.setMinSize(rectangle.width, control.getSize().y);
    }

    private void scheduleReflow(final boolean bl) {
        if (this.delayedReflow) {
            if (this.reflowPending) {
                this.updateSizeWhilePending();
                return;
            }
            this.reflowPending = true;
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SharedScrolledComposite.this.reflowPending = false;
                    if (!SharedScrolledComposite.this.isDisposed()) {
                        SharedScrolledComposite.this.reflow(bl);
                    }
                }
            });
        } else {
            this.reflow(bl);
        }
    }

    private void initializeScrollBars() {
        ScrollBar scrollBar;
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.setIncrement(5);
        }
        if ((scrollBar = this.getVerticalBar()) != null) {
            scrollBar.setIncrement(64);
        }
        FormUtil.updatePageIncrement(this);
    }

    public boolean isDelayedReflow() {
        return this.delayedReflow;
    }

    public void setDelayedReflow(boolean bl) {
        this.delayedReflow = bl;
    }
}

