/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.internal.forms.widgets.FormImages;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class Section
extends ExpandableComposite {
    public static final int DESCRIPTION = 128;
    private Control descriptionControl;
    private Control separator;
    private Hashtable titleColors;
    private static final String COLOR_BG = "bg";
    private static final String COLOR_GBG = "gbg";
    private static final String COLOR_BORDER = "border";

    public Section(Composite composite, int n) {
        this(composite, 0, n);
    }

    Section(Composite composite, int n, int n2) {
        super(composite, n | Section.getBackgroundStyle(n2), n2);
        int n3 = n & 0x4000000;
        if ((n2 & 0x80) != 0) {
            this.descriptionControl = new Text((Composite)this, 0x48 | n3);
        }
        if ((n2 & 0x100) != 0) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    Image image = Section.super.getBackgroundImage();
                    if (image != null) {
                        FormImages.getInstance().markFinished(image, Section.this.getDisplay());
                    }
                    Section.super.setBackgroundImage(null);
                }
            };
            this.addListener(12, listener);
            this.addListener(11, listener);
        }
    }

    private static int getBackgroundStyle(int n) {
        return (n & 0x100) != 0 ? 262144 : 0;
    }

    @Override
    protected void internalSetExpanded(boolean bl) {
        super.internalSetExpanded(bl);
        if ((this.getExpansionStyle() & 0x100) != 0 && !bl) {
            super.setBackgroundImage(null);
        }
        this.reflow();
    }

    protected void reflow() {
        Section section = this;
        while (section != null) {
            section.setRedraw(false);
            section = section.getParent();
            if (section instanceof SharedScrolledComposite || section instanceof Shell) break;
        }
        for (section = this; section != null; section = section.getParent()) {
            section.layout(true);
            if (!(section instanceof SharedScrolledComposite)) continue;
            ((SharedScrolledComposite)((Object)section)).reflow(true);
            break;
        }
        section = this;
        while (section != null) {
            section.setRedraw(true);
            section = section.getParent();
            if (section instanceof SharedScrolledComposite || section instanceof Shell) break;
        }
    }

    public void setDescription(String string) {
        if (this.descriptionControl instanceof Text) {
            ((Text)this.descriptionControl).setText(string);
        }
    }

    public String getDescription() {
        if (this.descriptionControl instanceof Text) {
            return ((Text)this.descriptionControl).getText();
        }
        return null;
    }

    public void setSeparatorControl(Control control) {
        Assert.isTrue((control != null && control.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.separator = control;
    }

    @Override
    public Control getSeparatorControl() {
        return this.separator;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.descriptionControl != null && (this.getExpansionStyle() & 0x80) != 0) {
            this.descriptionControl.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.descriptionControl != null && (this.getExpansionStyle() & 0x80) != 0) {
            this.descriptionControl.setForeground(color);
        }
    }

    @Override
    public Control getDescriptionControl() {
        return this.descriptionControl;
    }

    public void setDescriptionControl(Control control) {
        Assert.isTrue(((this.getExpansionStyle() & 0x80) == 0 ? 1 : 0) != 0);
        Assert.isTrue((control != null && control.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.descriptionControl = control;
    }

    public void setTitleBarBorderColor(Color color) {
        this.putTitleBarColor(COLOR_BORDER, color);
    }

    public void setTitleBarBackground(Color color) {
        this.putTitleBarColor(COLOR_BG, color);
    }

    public void setTitleBarGradientBackground(Color color) {
        this.putTitleBarColor(COLOR_GBG, color);
    }

    public Color getTitleBarBorderColor() {
        if (this.titleColors == null) {
            return null;
        }
        return (Color)this.titleColors.get(COLOR_BORDER);
    }

    public Color getTitleBarGradientBackground() {
        if (this.titleColors == null) {
            return null;
        }
        if ((this.getExpansionStyle() & 0x200) != 0) {
            return this.getBackground();
        }
        return (Color)this.titleColors.get(COLOR_GBG);
    }

    public Color getTitleBarBackground() {
        if (this.titleColors == null) {
            return null;
        }
        return (Color)this.titleColors.get(COLOR_BG);
    }

    private void putTitleBarColor(String string, Color color) {
        if (color == null) {
            return;
        }
        if (this.titleColors == null) {
            this.titleColors = new Hashtable();
        }
        this.titleColors.put(string, color);
    }

    @Override
    protected void onPaint(PaintEvent paintEvent) {
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        GC gC = paintEvent.gc;
        Image image = null;
        Rectangle rectangle = this.getClientArea();
        if ((this.getExpansionStyle() & 0x100) != 0) {
            image = new Image((Device)this.getDisplay(), rectangle.width, rectangle.height);
            image.setBackground(this.getBackground());
            gC = new GC((Drawable)image);
        }
        if (this.titleColors != null) {
            color = (Color)this.titleColors.get(COLOR_BG);
            color2 = this.getTitleBarForeground();
            color3 = (Color)this.titleColors.get(COLOR_BORDER);
        }
        if (color == null) {
            color = this.getBackground();
        }
        if (color2 == null) {
            color2 = this.getForeground();
        }
        if (color3 == null) {
            color3 = color2;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 4;
        if ((this.getExpansionStyle() & 0x100) != 0) {
            Point point;
            Point point2 = null;
            Point point3 = null;
            if (this.toggle != null) {
                point2 = this.toggle.getSize();
            }
            if (this.getTextClient() != null) {
                point3 = this.getTextClient().getSize();
            }
            Point point4 = point = this.textLabel == null ? new Point(0, 0) : this.textLabel.getSize();
            if (point2 != null) {
                n += Math.max(n, point2.y);
            }
            n2 = n;
            if (point3 != null) {
                n = Math.max(n, point3.y);
            }
            n = Math.max(n, point.y);
            n2 = Math.max(n2, point.y);
            n += n3 + n3;
            n2 += n3 + n3;
        } else {
            n = 5;
        }
        if ((this.getExpansionStyle() & 0x100) != 0) {
            if (this.getBackgroundImage() == null) {
                this.updateHeaderImage(color, rectangle, n2, n);
            }
            gC.setBackground(this.getBackground());
            gC.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.drawBackground(gC, rectangle.x, rectangle.y, rectangle.width, n);
            if (this.marginWidth > 0) {
                gC.setBackground(this.getBackground());
                gC.fillRectangle(0, 0, this.marginWidth, n);
                gC.fillRectangle(rectangle.x + rectangle.width - this.marginWidth, 0, this.marginWidth, n);
            }
        } else if (this.isExpanded()) {
            gC.setForeground(color);
            gC.setBackground(this.getBackground());
            gC.fillGradientRectangle(this.marginWidth, this.marginHeight, rectangle.width - this.marginWidth - this.marginWidth, n, true);
        }
        gC.setBackground(this.getBackground());
        FormUtil.setAntialias(gC, 1);
        gC.fillPolygon(new int[]{this.marginWidth, this.marginHeight, this.marginWidth, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight});
        gC.fillPolygon(new int[]{rectangle.width - this.marginWidth - 3, this.marginHeight, rectangle.width - this.marginWidth, this.marginHeight, rectangle.width - this.marginWidth, this.marginHeight + 3});
        gC.setForeground(color3);
        if (this.isExpanded() || (this.getExpansionStyle() & 0x100) != 0) {
            gC.drawLine(this.marginWidth, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight);
            gC.drawLine(this.marginWidth + 2, this.marginHeight, rectangle.width - this.marginWidth - 3, this.marginHeight);
            gC.drawLine(rectangle.width - this.marginWidth - 3, this.marginHeight, rectangle.width - this.marginWidth - 1, this.marginHeight + 2);
        } else {
            gC.drawLine(this.marginWidth, this.marginHeight, rectangle.width - 1, this.marginHeight);
        }
        if ((this.getExpansionStyle() & 0x100) != 0 || this.isExpanded()) {
            gC.fillGradientRectangle(this.marginWidth, this.marginHeight + 2, 1, n2 - 2, true);
            gC.fillGradientRectangle(rectangle.width - this.marginWidth - 1, this.marginHeight + 2, 1, n2 - 2, true);
        }
        if ((this.getExpansionStyle() & 0x100) != 0) {
            gC.setForeground(this.getBackground());
            gC.drawPolyline(new int[]{this.marginWidth + 1, this.marginHeight + n2 - 1, this.marginWidth + 1, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight + 1, rectangle.width - this.marginWidth - 3, this.marginHeight + 1, rectangle.width - this.marginWidth - 3, this.marginHeight + 2, rectangle.width - this.marginWidth - 2, this.marginHeight + 2, rectangle.width - this.marginWidth - 2, this.marginHeight + n2 - 1});
        }
        if (image != null) {
            gC.dispose();
            paintEvent.gc.drawImage(image, 0, 0);
            image.dispose();
        }
    }

    private void updateHeaderImage(Color color, Rectangle rectangle, int n, int n2) {
        Image image = FormImages.getInstance().getGradient(this.getBackground(), color, n2, n, this.marginHeight, this.getDisplay());
        super.setBackgroundImage(image);
    }

    public final void setBackgroundImage(Image image) {
    }
}

