/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.LayoutComposite;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.internal.forms.widgets.WrappedPageBook;

public class ScrolledPageBook
extends SharedScrolledComposite {
    private WrappedPageBook pageBook = new WrappedPageBook((Composite)this, 0);
    private Hashtable pages;
    private Composite emptyPage;
    private Control currentPage;

    public ScrolledPageBook(Composite composite) {
        this(composite, 768);
    }

    public ScrolledPageBook(Composite composite, int n) {
        super(composite, n);
        this.setContent((Control)this.pageBook);
        this.pages = new Hashtable();
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        event.doit = true;
                    }
                }
            }
        });
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Rectangle rectangle = this.computeTrim(0, 0, 10, 10);
        return new Point(rectangle.width, rectangle.height);
    }

    public boolean hasPage(Object object) {
        return this.pages.containsKey(object);
    }

    public Composite createPage(Object object) {
        Composite composite = this.createPage();
        this.pages.put(object, composite);
        return composite;
    }

    public Composite getContainer() {
        return this.pageBook;
    }

    public void registerPage(Object object, Control control) {
        this.pages.put(object, control);
    }

    public void removePage(Object object) {
        this.removePage(object, true);
    }

    public void removePage(Object object, boolean bl) {
        Control control = (Control)this.pages.get(object);
        if (control != null) {
            this.pages.remove(object);
            control.dispose();
            if (bl) {
                this.showEmptyPage();
            }
        }
    }

    public void showPage(Object object) {
        Control control = (Control)this.pages.get(object);
        if (control != null) {
            this.pageBook.showPage(control);
            if (this.currentPage != null && this.currentPage != control && control instanceof Composite) {
                ((Composite)control).layout(false);
            }
            this.currentPage = control;
        } else {
            this.showEmptyPage();
        }
        this.reflow(true);
    }

    public void showEmptyPage() {
        if (this.emptyPage == null) {
            this.emptyPage = this.createPage();
            this.emptyPage.setLayout((Layout)new GridLayout());
        }
        this.pageBook.showPage((Control)this.emptyPage);
        this.currentPage = this.emptyPage;
        this.reflow(true);
    }

    @Override
    public boolean setFocus() {
        if (this.currentPage != null) {
            return this.currentPage.setFocus();
        }
        return super.setFocus();
    }

    public Control getCurrentPage() {
        return this.currentPage;
    }

    private Composite createPage() {
        LayoutComposite layoutComposite = new LayoutComposite(this.pageBook, 0);
        layoutComposite.setBackground(this.getBackground());
        layoutComposite.setForeground(this.getForeground());
        layoutComposite.setMenu(this.pageBook.getMenu());
        return layoutComposite;
    }
}

