/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.io.InputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class ScrolledFormText
extends SharedScrolledComposite {
    private FormText content;
    private String text;

    public ScrolledFormText(Composite composite, boolean bl) {
        this(composite, 768, bl);
    }

    public ScrolledFormText(Composite composite, int n, boolean bl) {
        super(composite, n);
        if (bl) {
            this.setFormText(new FormText((Composite)this, 0));
        }
    }

    public void setFormText(FormText formText) {
        this.content = formText;
        super.setContent((Control)this.content);
        this.content.setMenu(this.getMenu());
        if (this.text != null) {
            this.loadText(this.text);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.content != null) {
            this.content.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.content != null) {
            this.content.setBackground(color);
        }
    }

    @Override
    public final void setContent(Control control) {
    }

    public void setText(String string) {
        this.text = string;
        this.loadText(string);
        this.reflow(true);
    }

    public void setContents(InputStream inputStream) {
        this.loadContents(inputStream);
    }

    public FormText getFormText() {
        return this.content;
    }

    private void loadText(String string) {
        if (this.content != null) {
            String string2 = string;
            if (!string2.startsWith("<form>")) {
                string2 = "<form>" + string + "</form>";
            }
            this.content.setText(string2, true, false);
        }
    }

    private void loadContents(InputStream inputStream) {
        if (this.content != null) {
            this.content.setContents(inputStream, false);
        }
    }
}

