/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ImageHyperlink
extends Hyperlink {
    public int textSpacing = 5;
    private Image image;
    private Image hoverImage;
    private Image activeImage;
    private Image disabledImage;
    private int state;
    private static final int HOVER = 2;
    private static final int ACTIVE = 4;
    private int verticalAlignment = 0x1000000;
    private int horizontalAlignment = 16384;

    public ImageHyperlink(Composite composite, int n) {
        super(composite, ImageHyperlink.removeAlignment(n));
        this.extractAlignment(n);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ImageHyperlink.this.disabledImage != null) {
                    ImageHyperlink.this.disabledImage.dispose();
                }
            }
        });
    }

    @Override
    protected void paintHyperlink(GC gC) {
        this.paintHyperlink(gC, this.getClientArea());
    }

    protected void paintHyperlink(GC gC, Rectangle rectangle) {
        Image image = null;
        if (!this.isEnabled()) {
            image = this.disabledImage;
        } else {
            if ((this.state & 4) != 0) {
                image = this.activeImage;
            } else if ((this.state & 2) != 0) {
                image = this.hoverImage;
            }
            if (image == null) {
                image = this.image;
            }
        }
        Rectangle rectangle2 = image != null ? image.getBounds() : new Rectangle(0, 0, 0, 0);
        Point point = this.computeMaxImageSize();
        int n = image != null ? this.textSpacing : 0;
        int n2 = rectangle.width - point.x - n - this.marginWidth - this.marginWidth;
        int n3 = rectangle.y + this.marginHeight + point.y / 2 - rectangle2.height / 2;
        if (this.horizontalAlignment == 16384) {
            int n4 = rectangle.x + this.marginWidth + point.x / 2 - rectangle2.width / 2;
            int n5 = rectangle.x + this.marginWidth + point.x + n;
            if (image != null) {
                gC.drawImage(image, n4, n3);
            }
            if (this.getText() != null) {
                this.drawText(gC, rectangle, n5, n2);
            }
        } else if (this.horizontalAlignment == 131072) {
            int n6 = rectangle.x + this.marginWidth;
            if (this.getText() != null) {
                n6 += this.drawText(gC, rectangle, n6, n2);
            }
            n6 += point.x / 2 - rectangle2.width / 2 + n;
            if (image != null) {
                gC.drawImage(image, n6, n3);
            }
        }
    }

    private int drawText(GC gC, Rectangle rectangle, int n, int n2) {
        Point point = this.computeTextSize(n2, -1);
        int n3 = rectangle.height - this.marginHeight - this.marginHeight;
        n2 = point.x;
        int n4 = point.y;
        int n5 = this.verticalAlignment == 1024 ? this.marginHeight + n3 - n4 : (this.verticalAlignment == 0x1000000 ? this.marginHeight + n3 / 2 - n4 / 2 : this.marginHeight);
        this.paintText(gC, new Rectangle(n, n5, n2, n4));
        return n2;
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        this.checkWidget();
        Point point = this.computeMaxImageSize();
        int n4 = point.x > 0 ? this.textSpacing : 0;
        Point point2 = null;
        if (this.getText() != null) {
            n3 = n;
            if (n != -1) {
                n3 = n - 2 * this.marginWidth - point.x - n4;
            }
            point2 = super.computeSize(n3, n2, bl);
        }
        n3 = point.x;
        int n5 = point.y;
        if (point2 != null) {
            n3 += n4;
            n3 += point2.x;
            n5 = Math.max(n5, point2.y);
        }
        return new Point(n3 += 2 * this.marginWidth, n5 += 2 * this.marginHeight);
    }

    @Override
    protected void handleEnter(Event event) {
        this.state = 2;
        super.handleEnter(event);
    }

    @Override
    protected void handleExit(Event event) {
        this.state = 0;
        super.handleExit(event);
    }

    @Override
    protected void handleActivate(Event event) {
        this.state &= 4;
        this.redraw();
        super.handleActivate(event);
        this.state &= 0xFFFFFFFB;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public Image getActiveImage() {
        return this.activeImage;
    }

    public void setActiveImage(Image image) {
        this.activeImage = image;
    }

    public Image getHoverImage() {
        return this.hoverImage;
    }

    public void setHoverImage(Image image) {
        this.hoverImage = image;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
        }
        if (image != null && !image.isDisposed()) {
            this.disabledImage = new Image(image.getDevice(), image, 1);
        }
        if (image == null) {
            this.disabledImage = null;
        }
    }

    private Point computeMaxImageSize() {
        int n = 0;
        int n2 = 0;
        if (this.image != null) {
            n = Math.max(this.image.getBounds().width, n);
            n2 = Math.max(this.image.getBounds().height, n2);
        }
        if (this.hoverImage != null) {
            n = Math.max(this.hoverImage.getBounds().width, n);
            n2 = Math.max(this.hoverImage.getBounds().height, n2);
        }
        if (this.activeImage != null) {
            n = Math.max(this.activeImage.getBounds().width, n);
            n2 = Math.max(this.activeImage.getBounds().height, n2);
        }
        return new Point(n, n2);
    }

    private static int removeAlignment(int n) {
        int n2 = n;
        if ((n & 0x1000000) != 0) {
            n2 &= 0xFEFFFFFF;
        }
        if ((n & 0x80) != 0) {
            n2 &= 0xFFFFFF7F;
        }
        if ((n & 0x400) != 0) {
            n2 &= 0xFFFFFBFF;
        }
        if ((n & 0x4000) != 0) {
            n2 &= 0xFFFFBFFF;
        }
        if ((n & 0x20000) != 0) {
            n2 &= 0xFFFDFFFF;
        }
        return n2;
    }

    private void extractAlignment(int n) {
        if ((n & 0x1000000) != 0) {
            this.verticalAlignment = 0x1000000;
        } else if ((n & 0x80) != 0) {
            this.verticalAlignment = 128;
        } else if ((n & 0x400) != 0) {
            this.verticalAlignment = 1024;
        }
        if ((n & 0x4000) != 0) {
            this.horizontalAlignment = 16384;
        } else if ((n & 0x20000) != 0) {
            this.horizontalAlignment = 131072;
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (!(bl || this.disabledImage != null && !this.disabledImage.isDisposed() || this.image == null || this.image.isDisposed())) {
            this.disabledImage = new Image(this.image.getDevice(), this.image, 1);
        }
        super.setEnabled(bl);
        if (bl && this.disabledImage != null) {
            this.disabledImage.dispose();
            this.disabledImage = null;
        }
    }
}

