/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class Hyperlink
extends AbstractHyperlink {
    private String text;
    private static final String ELLIPSIS = "...";
    private boolean underlined;
    private String appToolTipText;

    public Hyperlink(Composite composite, int n) {
        super(composite, n);
        this.initAccessible();
    }

    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Hyperlink.this.getText();
                if (accessibleEvent.result == null) {
                    this.getHelp(accessibleEvent);
                }
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Hyperlink.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = Hyperlink.this.toControl(new Point(accessibleControlEvent.x, accessibleControlEvent.y));
                accessibleControlEvent.childID = Hyperlink.this.getBounds().contains(point) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = Hyperlink.this.getBounds();
                Point point = Hyperlink.this.toDisplay(new Point(rectangle.x, rectangle.y));
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 30;
            }

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = SWT.getMessage((String)"SWT_Press");
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                if (Hyperlink.this.getSelection()) {
                    n = 6;
                }
                accessibleControlEvent.detail = n;
            }
        });
    }

    public void setUnderlined(boolean bl) {
        this.underlined = bl;
        this.redraw();
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = n;
        if (n3 != -1) {
            n3 -= this.marginWidth * 2;
        }
        Point point = this.computeTextSize(n3, n2);
        int n4 = point.x + 2 * this.marginWidth;
        int n5 = point.y + 2 * this.marginHeight;
        return new Point(n4, n5);
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    public void setText(String string) {
        this.text = string != null ? string : "";
        this.redraw();
    }

    @Override
    protected void paintHyperlink(GC gC) {
        Rectangle rectangle = this.getClientArea();
        Rectangle rectangle2 = new Rectangle(this.marginWidth, this.marginHeight, rectangle.width - this.marginWidth - this.marginWidth, rectangle.height - this.marginHeight - this.marginHeight);
        this.paintText(gC, rectangle2);
    }

    protected void paintText(GC gC, Rectangle rectangle) {
        gC.setFont(this.getFont());
        Color color = this.isEnabled() ? this.getForeground() : new Color(gC.getDevice(), FormColors.blend(this.getBackground().getRGB(), this.getForeground().getRGB(), 70));
        try {
            gC.setForeground(color);
            if ((this.getStyle() & 0x40) != 0) {
                FormUtil.paintWrapText(gC, this.text, rectangle, this.underlined);
            } else {
                Point point = this.computeTextSize(-1, -1);
                boolean bl = false;
                if (rectangle.width < point.x) {
                    bl = true;
                }
                int n = Math.min(rectangle.width, point.x);
                int n2 = point.y;
                String string = this.getText();
                if (bl) {
                    string = this.shortenText(gC, this.getText(), rectangle.width);
                    if (this.appToolTipText == null) {
                        super.setToolTipText(this.getText());
                    }
                } else {
                    super.setToolTipText(this.appToolTipText);
                }
                gC.drawText(string, rectangle.x, rectangle.y, true);
                if (this.underlined) {
                    int n3 = gC.getFontMetrics().getDescent();
                    int n4 = rectangle.y + n2 - n3 + 1;
                    gC.drawLine(rectangle.x, n4, rectangle.x + n, n4);
                }
            }
        }
        finally {
            if (!this.isEnabled() && color != null) {
                color.dispose();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected String shortenText(GC var1_1, String var2_2, int var3_3) {
        if (var2_2 == null) {
            return null;
        }
        var4_4 = var1_1.textExtent((String)"...").x;
        if (var3_3 <= var4_4) {
            return var2_2;
        }
        var5_5 = var2_2.length();
        var6_6 = var5_5 / 2;
        var8_8 = (var6_6 + (var7_7 = 0)) / 2 - 1;
        if (var8_8 > 0) ** GOTO lbl24
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var9_9 = var2_2.substring(0, var8_8);
            var10_10 = var2_2.substring(var5_5 - var8_8, var5_5);
            var11_11 = var1_1.textExtent((String)var9_9).x;
            var12_12 = var1_1.textExtent((String)var10_10).x;
            if (var11_11 + var4_4 + var12_12 > var3_3) {
                var6_6 = var8_8;
                var8_8 = (var6_6 + var7_7) / 2;
                continue;
            }
            if (var11_11 + var4_4 + var12_12 < var3_3) {
                var7_7 = var8_8;
                var8_8 = (var6_6 + var7_7) / 2;
                continue;
            }
            var7_7 = var6_6;
lbl24:
            // 4 sources

            ** while (var7_7 < var8_8 && var8_8 < var6_6)
        }
lbl25:
        // 1 sources

        if (var8_8 == 0) {
            return var2_2;
        }
        return String.valueOf(var2_2.substring(0, var8_8)) + "..." + var2_2.substring(var5_5 - var8_8, var5_5);
    }

    protected Point computeTextSize(int n, int n2) {
        Point point;
        GC gC = new GC((Drawable)this);
        gC.setFont(this.getFont());
        if ((this.getStyle() & 0x40) != 0 && n != -1) {
            point = FormUtil.computeWrapSize(gC, this.getText(), n);
        } else {
            point = gC.textExtent(this.getText());
            if ((this.getStyle() & 0x40) == 0 && n != -1) {
                point.x = n;
            }
        }
        gC.dispose();
        return point;
    }
}

