/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.LayoutComposite;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.forms.widgets.FormFonts;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class FormToolkit {
    public static final String KEY_DRAW_BORDER = "FormWidgetFactory.drawBorder";
    public static final String TREE_BORDER = "treeBorder";
    public static final String TEXT_BORDER = "textBorder";
    private int borderStyle = 0;
    private FormColors colors;
    private int orientation = Window.getDefaultOrientation();
    private BorderPainter borderPainter;
    private BoldFontHolder boldFontHolder;
    private HyperlinkGroup hyperlinkGroup;
    private boolean isDisposed = false;
    VisibilityHandler visibilityHandler;
    KeyboardHandler keyboardHandler;

    public FormToolkit(Display display) {
        this(new FormColors(display));
    }

    public FormToolkit(FormColors formColors) {
        this.colors = formColors;
        this.initialize();
    }

    public Button createButton(Composite composite, String string, int n) {
        Button button = new Button(composite, n | 0x800000 | this.orientation);
        if (string != null) {
            button.setText(string);
        }
        this.adapt((Control)button, true, true);
        return button;
    }

    public Composite createComposite(Composite composite) {
        return this.createComposite(composite, 0);
    }

    public Composite createComposite(Composite composite, int n) {
        LayoutComposite layoutComposite = new LayoutComposite(composite, n | this.orientation);
        this.adapt(layoutComposite);
        return layoutComposite;
    }

    public Composite createCompositeSeparator(Composite composite) {
        final Composite composite2 = new Composite(composite, this.orientation);
        composite2.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                if (composite2.isDisposed()) {
                    return;
                }
                Rectangle rectangle = composite2.getBounds();
                GC gC = event.gc;
                gC.setForeground(FormToolkit.this.colors.getColor("org.eclipse.ui.forms.SEPARATOR"));
                if (FormToolkit.this.colors.getBackground() != null) {
                    gC.setBackground(FormToolkit.this.colors.getBackground());
                }
                gC.fillGradientRectangle(0, 0, rectangle.width, rectangle.height, false);
            }
        });
        if (composite instanceof Section) {
            ((Section)composite).setSeparatorControl((Control)composite2);
        }
        return composite2;
    }

    public Label createLabel(Composite composite, String string) {
        return this.createLabel(composite, string, 0);
    }

    public Label createLabel(Composite composite, String string, int n) {
        Label label = new Label(composite, n | this.orientation);
        if (string != null) {
            label.setText(string);
        }
        this.adapt((Control)label, false, false);
        return label;
    }

    public Hyperlink createHyperlink(Composite composite, String string, int n) {
        Hyperlink hyperlink = new Hyperlink(composite, n | this.orientation);
        if (string != null) {
            hyperlink.setText(string);
        }
        hyperlink.addFocusListener((FocusListener)this.visibilityHandler);
        hyperlink.addKeyListener((KeyListener)this.keyboardHandler);
        this.hyperlinkGroup.add(hyperlink);
        return hyperlink;
    }

    public ImageHyperlink createImageHyperlink(Composite composite, int n) {
        ImageHyperlink imageHyperlink = new ImageHyperlink(composite, n | this.orientation);
        imageHyperlink.addFocusListener((FocusListener)this.visibilityHandler);
        imageHyperlink.addKeyListener((KeyListener)this.keyboardHandler);
        this.hyperlinkGroup.add(imageHyperlink);
        return imageHyperlink;
    }

    public FormText createFormText(Composite composite, boolean bl) {
        FormText formText = new FormText(composite, 0x40 | this.orientation);
        formText.marginWidth = 1;
        formText.marginHeight = 0;
        formText.setHyperlinkSettings(this.getHyperlinkGroup());
        this.adapt((Control)formText, bl, true);
        formText.setMenu(composite.getMenu());
        return formText;
    }

    public void adapt(Control control, boolean bl, boolean bl2) {
        control.setBackground(this.colors.getBackground());
        control.setForeground(this.colors.getForeground());
        if (control instanceof ExpandableComposite) {
            ExpandableComposite expandableComposite = (ExpandableComposite)control;
            if (expandableComposite.toggle != null) {
                if (bl) {
                    expandableComposite.toggle.addFocusListener((FocusListener)this.visibilityHandler);
                }
                if (bl2) {
                    expandableComposite.toggle.addKeyListener((KeyListener)this.keyboardHandler);
                }
            }
            if (expandableComposite.textLabel != null) {
                if (bl) {
                    expandableComposite.textLabel.addFocusListener((FocusListener)this.visibilityHandler);
                }
                if (bl2) {
                    expandableComposite.textLabel.addKeyListener((KeyListener)this.keyboardHandler);
                }
            }
            return;
        }
        if (bl) {
            control.addFocusListener((FocusListener)this.visibilityHandler);
        }
        if (bl2) {
            control.addKeyListener((KeyListener)this.keyboardHandler);
        }
    }

    public void adapt(Composite composite) {
        composite.setBackground(this.colors.getBackground());
        composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                ((Control)mouseEvent.widget).setFocus();
            }
        });
        if (composite.getParent() != null) {
            composite.setMenu(composite.getParent().getMenu());
        }
    }

    public static void ensureVisible(Control control) {
        FormUtil.ensureVisible(control);
    }

    public Section createSection(Composite composite, int n) {
        Section section = new Section(composite, this.orientation, n);
        section.setMenu(composite.getMenu());
        this.adapt((Control)section, true, true);
        if (section.toggle != null) {
            section.toggle.setHoverDecorationColor(this.colors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
            section.toggle.setDecorationColor(this.colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        }
        section.setFont(this.boldFontHolder.getBoldFont(composite.getFont()));
        if ((n & 0x100) != 0 || (n & 0x200) != 0) {
            this.colors.initializeSectionToolBarColors();
            section.setTitleBarBackground(this.colors.getColor("org.eclipse.ui.forms.TB_BG"));
            section.setTitleBarBorderColor(this.colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        }
        section.setTitleBarForeground(this.colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        return section;
    }

    public ExpandableComposite createExpandableComposite(Composite composite, int n) {
        ExpandableComposite expandableComposite = new ExpandableComposite(composite, this.orientation, n);
        expandableComposite.setMenu(composite.getMenu());
        this.adapt((Control)expandableComposite, true, true);
        expandableComposite.setFont(this.boldFontHolder.getBoldFont(expandableComposite.getFont()));
        return expandableComposite;
    }

    public Label createSeparator(Composite composite, int n) {
        Label label = new Label(composite, 2 | n | this.orientation);
        label.setBackground(this.colors.getBackground());
        label.setForeground(this.colors.getBorderColor());
        return label;
    }

    public Table createTable(Composite composite, int n) {
        Table table = new Table(composite, n | this.borderStyle | this.orientation);
        this.adapt((Control)table, false, false);
        return table;
    }

    public Text createText(Composite composite, String string) {
        return this.createText(composite, string, 4);
    }

    public Text createText(Composite composite, String string, int n) {
        Text text = new Text(composite, this.borderStyle | n | this.orientation);
        if (string != null) {
            text.setText(string);
        }
        text.setForeground(this.colors.getForeground());
        text.setBackground(this.colors.getBackground());
        text.addFocusListener((FocusListener)this.visibilityHandler);
        return text;
    }

    public Tree createTree(Composite composite, int n) {
        Tree tree = new Tree(composite, this.borderStyle | n | this.orientation);
        this.adapt((Control)tree, false, false);
        return tree;
    }

    public ScrolledForm createScrolledForm(Composite composite) {
        ScrolledForm scrolledForm = new ScrolledForm(composite, 0x300 | this.orientation);
        scrolledForm.setExpandHorizontal(true);
        scrolledForm.setExpandVertical(true);
        scrolledForm.setBackground(this.colors.getBackground());
        scrolledForm.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        scrolledForm.setFont(JFaceResources.getHeaderFont());
        return scrolledForm;
    }

    public Form createForm(Composite composite) {
        Form form = new Form(composite, this.orientation);
        form.setBackground(this.colors.getBackground());
        form.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        form.setFont(JFaceResources.getHeaderFont());
        return form;
    }

    public void decorateFormHeading(Form form) {
        Color color = this.colors.getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color color2 = this.colors.getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        form.setTextBackground(new Color[]{color, color2}, new int[]{100}, true);
        form.setHeadColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", this.colors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        form.setHeadColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", this.colors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
        form.setHeadColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT", this.colors.getColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT"));
        form.setHeadColor("org.eclipse.ui.forms.H_H_HOVER_FULL", this.colors.getColor("org.eclipse.ui.forms.H_H_HOVER_FULL"));
        form.setHeadColor("org.eclipse.ui.forms.TB_TOGGLE", this.colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        form.setHeadColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER", this.colors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
        form.setSeparatorVisible(true);
    }

    public ScrolledPageBook createPageBook(Composite composite, int n) {
        ScrolledPageBook scrolledPageBook = new ScrolledPageBook(composite, n | this.orientation);
        this.adapt((Control)scrolledPageBook, true, true);
        scrolledPageBook.setMenu(composite.getMenu());
        return scrolledPageBook;
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.boldFontHolder.dispose();
        if (!this.colors.isShared()) {
            this.colors.dispose();
            this.colors = null;
        }
    }

    public HyperlinkGroup getHyperlinkGroup() {
        return this.hyperlinkGroup;
    }

    public void setBackground(Color color) {
        this.hyperlinkGroup.setBackground(color);
        this.colors.setBackground(color);
    }

    public void refreshHyperlinkColors() {
        this.hyperlinkGroup.initializeDefaultForegrounds(this.colors.getDisplay());
    }

    public void paintBordersFor(Composite composite) {
        if (this.borderPainter == null) {
            this.borderPainter = new BorderPainter();
        }
        composite.addPaintListener((PaintListener)this.borderPainter);
    }

    public FormColors getColors() {
        return this.colors;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public int getBorderMargin() {
        return this.getBorderStyle() == 2048 ? 0 : 2;
    }

    public void setBorderStyle(int n) {
        this.borderStyle = n;
    }

    public static void setControlVisible(Control control, boolean bl) {
        ScrolledComposite scrolledComposite = FormUtil.getScrolledComposite(control);
        if (scrolledComposite == null) {
            return;
        }
        Point point = FormUtil.getControlLocation(scrolledComposite, control);
        scrolledComposite.setOrigin(point);
    }

    private void initialize() {
        this.initializeBorderStyle();
        this.hyperlinkGroup = new HyperlinkGroup(this.colors.getDisplay());
        this.hyperlinkGroup.setBackground(this.colors.getBackground());
        this.visibilityHandler = new VisibilityHandler();
        this.keyboardHandler = new KeyboardHandler();
        this.boldFontHolder = new BoldFontHolder();
    }

    private void initializeBorderStyle() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        if (string.startsWith("Windows") && "5.1".compareTo(string2) <= 0) {
            RGB rGB = this.colors.getSystemColor(22);
            if (rGB.red != 212 || rGB.green != 208 || rGB.blue != 200) {
                this.borderStyle = 2048;
            }
        } else if (string.startsWith("Mac")) {
            this.borderStyle = 2048;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    private class BoldFontHolder {
        private Map fontMap;

        public Font getBoldFont(Font font) {
            if (font == null) {
                return null;
            }
            if (this.fontMap == null) {
                this.fontMap = new HashMap();
            }
            if (this.fontMap.containsKey(font)) {
                return (Font)this.fontMap.get(font);
            }
            Font font2 = FormFonts.getInstance().getBoldFont(FormToolkit.this.colors.getDisplay(), font);
            this.fontMap.put(font, font2);
            return font2;
        }

        public void dispose() {
            if (this.fontMap == null) {
                return;
            }
            for (Font font : this.fontMap.values()) {
                if (font == null || FormToolkit.this.colors.getDisplay() == null) continue;
                FormFonts.getInstance().markFinished(font, FormToolkit.this.colors.getDisplay());
                font = null;
            }
        }
    }

    private class BorderPainter
    implements PaintListener {
        private BorderPainter() {
        }

        public void paintControl(PaintEvent paintEvent) {
            Composite composite = (Composite)paintEvent.widget;
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                block13: {
                    boolean bl;
                    boolean bl2;
                    Control control;
                    block14: {
                        control = controlArray[n];
                        bl2 = false;
                        bl = false;
                        if (!control.isVisible() || control instanceof Hyperlink) break block13;
                        Object object = control.getData(FormToolkit.KEY_DRAW_BORDER);
                        if (object == null) break block14;
                        if (object.equals(Boolean.FALSE)) break block13;
                        if (object.equals(FormToolkit.TREE_BORDER)) {
                            bl2 = true;
                        } else if (object.equals(FormToolkit.TEXT_BORDER)) {
                            bl = true;
                        }
                    }
                    if (FormToolkit.this.getBorderStyle() != 2048 || (bl2 || bl) && !(control instanceof Text) && !(control instanceof Table) && !(control instanceof Tree)) {
                        GC gC;
                        Rectangle rectangle;
                        if (!bl2 && (control instanceof Text || control instanceof CCombo || bl)) {
                            rectangle = control.getBounds();
                            gC = paintEvent.gc;
                            gC.setForeground(control.getBackground());
                            gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                            gC.setForeground(FormToolkit.this.colors.getBorderColor());
                            if (control instanceof CCombo) {
                                gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                            } else {
                                gC.drawRectangle(rectangle.x - 1, rectangle.y - 2, rectangle.width + 1, rectangle.height + 3);
                            }
                        } else if (bl2 || control instanceof Table || control instanceof Tree) {
                            rectangle = control.getBounds();
                            gC = paintEvent.gc;
                            gC.setForeground(FormToolkit.this.colors.getBorderColor());
                            gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                        }
                    }
                }
                ++n;
            }
        }
    }

    private static class KeyboardHandler
    extends KeyAdapter {
        private KeyboardHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Widget widget = keyEvent.widget;
            if (widget instanceof Control && keyEvent.doit) {
                FormUtil.processKey(keyEvent.keyCode, (Control)widget);
            }
        }
    }

    private static class VisibilityHandler
    extends FocusAdapter {
        private boolean handleNextFocusGained = true;

        private VisibilityHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!this.handleNextFocusGained) {
                this.handleNextFocusGained = true;
            } else {
                Widget widget = focusEvent.widget;
                if (widget instanceof Control) {
                    FormUtil.ensureVisible((Control)widget);
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Widget widget = focusEvent.widget;
            if (widget instanceof Control) {
                this.handleNextFocusGained = widget.getDisplay().getActiveShell() == ((Control)widget).getShell();
            }
        }
    }
}

