/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.internal.forms.Messages;
import org.eclipse.ui.internal.forms.widgets.ControlSegment;
import org.eclipse.ui.internal.forms.widgets.FormFonts;
import org.eclipse.ui.internal.forms.widgets.FormTextModel;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.IFocusSelectable;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.Paragraph;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.SelectionData;
import org.eclipse.ui.internal.forms.widgets.TextSegment;

public class FormText
extends Canvas {
    public static final String URL_HANDLER_ID = "urlHandler";
    public int marginWidth = 0;
    public int marginHeight = 1;
    private static final boolean DEBUG_TEXT = false;
    private static final boolean DEBUG_TEXTSIZE = false;
    private static final boolean DEBUG_FOCUS = false;
    private boolean hasFocus;
    private boolean paragraphsSeparated = true;
    private FormTextModel model;
    private ListenerList listeners;
    private Hashtable resourceTable = new Hashtable();
    private IHyperlinkSegment entered;
    private IHyperlinkSegment armed;
    private boolean mouseFocus = false;
    private boolean controlFocusTransfer = false;
    private boolean inSelection = false;
    private SelectionData selData;
    private static final String INTERNAL_MENU = "__internal_menu__";
    private static final String CONTROL_KEY = "__segment__";

    public FormText(Composite composite, int n) {
        super(composite, 0x40040 | n);
        this.setLayout(new FormTextLayout());
        this.model = new FormTextModel();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FormText.this.model.dispose();
                FormText.this.disposeResourceTable(true);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                FormText.this.paint(paintEvent);
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\r') {
                    FormText.this.activateSelectedLink();
                    return;
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        event.doit = false;
                        return;
                    }
                }
                if (!FormText.this.model.hasFocusSegments()) {
                    event.doit = true;
                    return;
                }
                if (event.detail == 16) {
                    event.doit = FormText.this.advance(true);
                } else if (event.detail == 8) {
                    event.doit = FormText.this.advance(false);
                } else if (event.detail != 4) {
                    event.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (!FormText.this.hasFocus) {
                    FormText.this.hasFocus = true;
                    if (!FormText.this.mouseFocus && !FormText.this.controlFocusTransfer) {
                        FormText.this.handleFocusChange();
                    }
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (FormText.this.hasFocus) {
                    FormText.this.hasFocus = false;
                    if (!FormText.this.controlFocusTransfer) {
                        FormText.this.handleFocusChange();
                    }
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                FormText.this.handleMouseClick(mouseEvent, true);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                FormText.this.handleMouseClick(mouseEvent, false);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
                FormText.this.handleMouseMove(mouseEvent);
            }

            public void mouseExit(MouseEvent mouseEvent) {
                if (FormText.this.entered != null) {
                    FormText.this.exitLink(FormText.this.entered, mouseEvent.stateMask);
                    FormText.this.paintLinkHover(FormText.this.entered, false);
                    FormText.this.entered = null;
                    FormText.this.setCursor(null);
                }
            }

            public void mouseHover(MouseEvent mouseEvent) {
                FormText.this.handleMouseHover(mouseEvent);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                FormText.this.handleMouseMove(mouseEvent);
            }
        });
        this.initAccessible();
        this.ensureBoldFontPresent(this.getFont());
        this.createMenu();
        this.setTabList(new Control[0]);
    }

    public boolean getFocus() {
        return this.hasFocus;
    }

    public boolean isLoading() {
        return false;
    }

    public String getLoadingText() {
        return null;
    }

    public void setLoadingText(String string) {
        this.setText(string, false, false);
    }

    public void setParagraphsSeparated(boolean bl) {
        this.paragraphsSeparated = bl;
    }

    public boolean getParagraphsSeparated() {
        return this.paragraphsSeparated;
    }

    public void setImage(String string, Image image) {
        this.resourceTable.put("i." + string, image);
    }

    public void setColor(String string, Color color) {
        String string2 = "c." + string;
        if (color == null) {
            this.resourceTable.remove(string2);
        } else {
            this.resourceTable.put(string2, color);
        }
    }

    public void setFont(String string, Font font) {
        String string2 = "f." + string;
        if (font == null) {
            this.resourceTable.remove(string2);
        } else {
            this.resourceTable.put(string2, font);
        }
        this.model.clearCache(string2);
    }

    public void setControl(String string, Control control) {
        String string2 = "o." + string;
        if (control == null) {
            this.resourceTable.remove(string2);
        } else {
            this.resourceTable.put(string2, control);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.model.clearCache(null);
        Font font2 = (Font)this.resourceTable.get("f.____bold");
        if (font2 != null) {
            FormFonts.getInstance().markFinished(font2, this.getDisplay());
            this.resourceTable.remove("f.____bold");
        }
        this.ensureBoldFontPresent(this.getFont());
    }

    public void setText(String string, boolean bl, boolean bl2) {
        this.disposeResourceTable(false);
        this.entered = null;
        if (bl) {
            this.model.parseTaggedText(string, bl2);
        } else {
            this.model.parseRegularText(string, bl2);
        }
        this.hookControlSegmentFocus();
        this.layout();
        this.redraw();
    }

    public void setContents(InputStream inputStream, boolean bl) {
        this.entered = null;
        this.disposeResourceTable(false);
        this.model.parseInputStream(inputStream, bl);
        this.hookControlSegmentFocus();
        this.layout();
        this.redraw();
    }

    private void hookControlSegmentFocus() {
        Paragraph[] paragraphArray = this.model.getParagraphs();
        if (paragraphArray == null) {
            return;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 15: {
                        if (FormText.this.controlFocusTransfer) break;
                        FormText.this.syncControlSegmentFocus((Control)event.widget);
                        break;
                    }
                    case 31: {
                        switch (event.detail) {
                            case 32: 
                            case 64: 
                            case 256: 
                            case 512: {
                                event.doit = false;
                                return;
                            }
                        }
                        Control control = (Control)event.widget;
                        ControlSegment controlSegment = (ControlSegment)control.getData(FormText.CONTROL_KEY);
                        if (event.detail == 16) {
                            event.doit = FormText.this.advanceControl(control, controlSegment, true);
                        } else if (event.detail == 8) {
                            event.doit = FormText.this.advanceControl(control, controlSegment, false);
                        }
                        if (event.doit) break;
                        event.detail = 0;
                    }
                }
            }
        };
        int n = 0;
        while (n < paragraphArray.length) {
            Paragraph paragraph = paragraphArray[n];
            ParagraphSegment[] paragraphSegmentArray = paragraph.getSegments();
            int n2 = 0;
            while (n2 < paragraphSegmentArray.length) {
                ControlSegment controlSegment;
                Control control;
                if (paragraphSegmentArray[n2] instanceof ControlSegment && (control = (controlSegment = (ControlSegment)paragraphSegmentArray[n2]).getControl(this.resourceTable)) != null && control.getData(CONTROL_KEY) == null) {
                    control.setData(CONTROL_KEY, (Object)controlSegment);
                    this.attachTraverseListener(control, listener);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void attachTraverseListener(Control control, Listener listener) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                this.attachTraverseListener(controlArray[n], listener);
                ++n;
            }
            if (control instanceof Canvas) {
                control.addListener(31, listener);
                control.addListener(15, listener);
            }
        } else {
            control.addListener(31, listener);
            control.addListener(15, listener);
        }
    }

    private void syncControlSegmentFocus(Control control) {
        ControlSegment controlSegment = null;
        while (control != null) {
            controlSegment = (ControlSegment)control.getData(CONTROL_KEY);
            if (controlSegment != null) break;
            control = control.getParent();
        }
        if (controlSegment == null) {
            return;
        }
        IFocusSelectable iFocusSelectable = this.model.getSelectedSegment();
        if (iFocusSelectable == controlSegment) {
            return;
        }
        IHyperlinkSegment iHyperlinkSegment = null;
        if (iFocusSelectable != null && iFocusSelectable instanceof IHyperlinkSegment) {
            iHyperlinkSegment = (IHyperlinkSegment)iFocusSelectable;
            this.exitLink(iHyperlinkSegment, 0);
        }
        this.model.select(controlSegment);
        if (iHyperlinkSegment != null) {
            this.paintFocusTransfer(iHyperlinkSegment, null);
        }
    }

    private boolean advanceControl(Control control, ControlSegment controlSegment, boolean bl) {
        Composite composite = control.getParent();
        if (composite == this) {
            IFocusSelectable iFocusSelectable = this.model.getNextFocusSegment(bl);
            if (iFocusSelectable != null) {
                this.controlFocusTransfer = true;
                super.forceFocus();
                this.controlFocusTransfer = false;
                this.model.select(controlSegment);
                return this.advance(bl);
            }
            return this.setFocusToNextSibling((Control)this, bl);
        }
        if (this.setFocusToNextSibling(control, bl)) {
            return true;
        }
        controlSegment = (ControlSegment)composite.getData(CONTROL_KEY);
        return this.advanceControl((Control)composite, controlSegment, bl);
    }

    private boolean setFocusToNextSibling(Control control, boolean bl) {
        Composite composite = control.getParent();
        Control[] controlArray = composite.getTabList();
        int n = 0;
        while (n < controlArray.length) {
            Control control2 = controlArray[n];
            if (control2 == control) {
                Control control3;
                int n2;
                if (bl) {
                    n2 = n + 1;
                    while (n2 < controlArray.length) {
                        control3 = controlArray[n2];
                        if (control3.setFocus()) {
                            return false;
                        }
                        ++n2;
                    }
                } else {
                    n2 = n - 1;
                    while (n2 >= 0) {
                        control3 = controlArray[n2];
                        if (control3.setFocus()) {
                            return false;
                        }
                        --n2;
                    }
                }
            }
            ++n;
        }
        return false;
    }

    public void setWhitespaceNormalized(boolean bl) {
        this.model.setWhitespaceNormalized(bl);
    }

    public boolean isWhitespaceNormalized() {
        return this.model.isWhitespaceNormalized();
    }

    public void setMenu(Menu menu) {
        Menu menu2 = super.getMenu();
        if (menu2 != null && INTERNAL_MENU.equals(menu2.getData())) {
            if (menu != null) {
                menu2.dispose();
                super.setMenu(menu);
            }
        } else {
            super.setMenu(menu);
        }
    }

    private void createMenu() {
        Menu menu = new Menu((Control)this);
        final MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(Messages.FormText_copy);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget == menuItem) {
                    FormText.this.copy();
                }
            }
        };
        menuItem.addSelectionListener((SelectionListener)selectionAdapter);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent menuEvent) {
                menuItem.setEnabled(FormText.this.canCopy());
            }

            public void menuHidden(MenuEvent menuEvent) {
            }
        });
        menu.setData((Object)INTERNAL_MENU);
        super.setMenu(menu);
    }

    public HyperlinkSettings getHyperlinkSettings() {
        return this.model.getHyperlinkSettings();
    }

    public void setHyperlinkSettings(HyperlinkSettings hyperlinkSettings) {
        this.model.setHyperlinkSettings(hyperlinkSettings);
    }

    public void addHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add((Object)iHyperlinkListener);
    }

    public void removeHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove((Object)iHyperlinkListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.addListener(13, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)selectionListener);
    }

    public String getSelectionText() {
        this.checkWidget();
        if (this.selData != null) {
            return this.selData.getSelectionText();
        }
        return "";
    }

    public boolean canCopy() {
        return this.selData != null && this.selData.canCopy();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        Clipboard clipboard = new Clipboard(this.getDisplay());
        Object[] objectArray = new Object[]{this.getSelectionText()};
        Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance()};
        clipboard.setContents(objectArray, transferArray);
        clipboard.dispose();
    }

    public Object getSelectedLinkHref() {
        IHyperlinkSegment iHyperlinkSegment = this.getSelectedLink();
        return iHyperlinkSegment != null ? iHyperlinkSegment.getHref() : null;
    }

    public String getSelectedLinkText() {
        IHyperlinkSegment iHyperlinkSegment = this.getSelectedLink();
        return iHyperlinkSegment != null ? iHyperlinkSegment.getText() : null;
    }

    private IHyperlinkSegment getSelectedLink() {
        IFocusSelectable iFocusSelectable = this.model.getSelectedSegment();
        if (iFocusSelectable != null && iFocusSelectable instanceof IHyperlinkSegment) {
            return (IHyperlinkSegment)iFocusSelectable;
        }
        return null;
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (accessibleEvent.childID == -1) {
                    accessibleEvent.result = FormText.this.model.getAccessibleText();
                } else {
                    int n = FormText.this.model.getHyperlinkCount();
                    if (accessibleEvent.childID >= 0 && accessibleEvent.childID < n) {
                        IHyperlinkSegment iHyperlinkSegment = FormText.this.model.getHyperlink(accessibleEvent.childID);
                        accessibleEvent.result = iHyperlinkSegment.getText();
                    }
                }
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = FormText.this.getToolTipText();
                int n = FormText.this.model.getHyperlinkCount();
                if (accessibleEvent.result == null && accessibleEvent.childID >= 0 && accessibleEvent.childID < n) {
                    IHyperlinkSegment iHyperlinkSegment = FormText.this.model.getHyperlink(accessibleEvent.childID);
                    accessibleEvent.result = iHyperlinkSegment.getText();
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = FormText.this.toControl(new Point(accessibleControlEvent.x, accessibleControlEvent.y));
                IHyperlinkSegment iHyperlinkSegment = FormText.this.model.findHyperlinkAt(point.x, point.y);
                accessibleControlEvent.childID = iHyperlinkSegment != null ? FormText.this.model.indexOf(iHyperlinkSegment) : -1;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = null;
                if (accessibleControlEvent.childID != -1 && accessibleControlEvent.childID != -2) {
                    int n = accessibleControlEvent.childID;
                    IHyperlinkSegment iHyperlinkSegment = FormText.this.model.getHyperlink(n);
                    if (iHyperlinkSegment != null) {
                        rectangle = iHyperlinkSegment.getBounds();
                    }
                }
                if (rectangle == null) {
                    rectangle = FormText.this.getBounds();
                }
                Point point = FormText.this.toDisplay(new Point(rectangle.x, rectangle.y));
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                int n;
                int n2 = -2;
                if (FormText.this.model.hasFocusSegments() && (n = FormText.this.model.getSelectedSegmentIndex()) != -1) {
                    n2 = n;
                }
                accessibleControlEvent.childID = n2;
            }

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                if (FormText.this.model.getHyperlinkCount() > 0) {
                    accessibleControlEvent.result = SWT.getMessage((String)"SWT_Press");
                }
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = FormText.this.model.getHyperlinkCount();
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                int n2 = accessibleControlEvent.childID;
                int n3 = FormText.this.model.getHyperlinkCount();
                if (n2 == -1) {
                    n = n3 > 0 ? 30 : 42;
                } else if (n2 >= 0 && n2 < n3) {
                    n = 30;
                }
                accessibleControlEvent.detail = n;
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                int n = FormText.this.model.getSelectedSegmentIndex();
                accessibleControlEvent.childID = n == -1 ? -2 : n;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                int n = FormText.this.model.getHyperlinkCount();
                int n2 = FormText.this.model.getSelectedSegmentIndex();
                int n3 = 0;
                int n4 = accessibleControlEvent.childID;
                if (n4 == -1) {
                    n3 = 0;
                } else if (n4 >= 0 && n4 < n) {
                    n3 = 0x200000;
                    if (FormText.this.isFocusControl()) {
                        n3 |= 0x100000;
                    }
                    if (n2 == n4) {
                        n3 |= 2;
                        if (FormText.this.isFocusControl()) {
                            n3 |= 4;
                        }
                    }
                }
                accessibleControlEvent.detail = n3 |= 0x40;
            }

            public void getChildren(AccessibleControlEvent accessibleControlEvent) {
                int n = FormText.this.model.getHyperlinkCount();
                Object[] objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = new Integer(n2);
                    ++n2;
                }
                accessibleControlEvent.children = objectArray;
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
            }
        });
    }

    private void startSelection(MouseEvent mouseEvent) {
        this.inSelection = true;
        this.selData = new SelectionData(mouseEvent);
        this.redraw();
        Form form = FormUtil.getForm((Control)this);
        if (form != null) {
            form.setSelectionText(this);
        }
    }

    private void endSelection(MouseEvent mouseEvent) {
        this.inSelection = false;
        if (this.selData != null) {
            if (!this.selData.isEnclosed()) {
                this.selData = null;
            } else {
                this.computeSelection();
            }
        }
        this.notifySelectionChanged();
    }

    private void computeSelection() {
        GC gC = new GC((Drawable)this);
        Paragraph[] paragraphArray = this.model.getParagraphs();
        IHyperlinkSegment iHyperlinkSegment = this.getSelectedLink();
        if (this.getDisplay().getFocusControl() != this) {
            iHyperlinkSegment = null;
        }
        int n = 0;
        while (n < paragraphArray.length) {
            Paragraph paragraph = paragraphArray[n];
            if (n > 0) {
                this.selData.markNewLine();
            }
            paragraph.computeSelection(gC, this.resourceTable, iHyperlinkSegment, this.selData);
            ++n;
        }
        gC.dispose();
    }

    void clearSelection() {
        this.selData = null;
        if (!this.isDisposed()) {
            this.redraw();
            this.notifySelectionChanged();
        }
    }

    private void notifySelectionChanged() {
        Event event = new Event();
        event.widget = this;
        event.display = this.getDisplay();
        event.type = 13;
        this.notifyListeners(13, event);
        if (!this.isDisposed()) {
            this.getAccessible().selectionChanged();
        }
    }

    private void handleDrag(MouseEvent mouseEvent) {
        if (this.selData != null) {
            ScrolledComposite scrolledComposite = FormUtil.getScrolledComposite((Control)this);
            if (scrolledComposite != null) {
                FormUtil.ensureVisible(scrolledComposite, (Control)this, mouseEvent);
            }
            this.selData.update(mouseEvent);
            this.redraw();
        }
    }

    private void handleMouseClick(MouseEvent mouseEvent, boolean bl) {
        if (bl) {
            this.mouseFocus = true;
            IHyperlinkSegment iHyperlinkSegment = this.model.findHyperlinkAt(mouseEvent.x, mouseEvent.y);
            if (iHyperlinkSegment != null) {
                IHyperlinkSegment iHyperlinkSegment2 = this.getSelectedLink();
                if (this.getDisplay().getFocusControl() != this) {
                    this.setFocus();
                }
                this.model.selectLink(iHyperlinkSegment);
                this.enterLink(iHyperlinkSegment, mouseEvent.stateMask);
                this.paintFocusTransfer(iHyperlinkSegment2, iHyperlinkSegment);
            }
            if (mouseEvent.button == 1) {
                this.startSelection(mouseEvent);
                this.armed = iHyperlinkSegment;
            }
        } else {
            if (mouseEvent.button == 1) {
                this.endSelection(mouseEvent);
                if (this.isDisposed()) {
                    return;
                }
                IHyperlinkSegment iHyperlinkSegment = this.model.findHyperlinkAt(mouseEvent.x, mouseEvent.y);
                if (iHyperlinkSegment != null && this.armed == iHyperlinkSegment && this.selData == null) {
                    this.activateLink(iHyperlinkSegment, mouseEvent.stateMask);
                    this.armed = null;
                }
            }
            this.mouseFocus = false;
        }
    }

    private void handleMouseHover(MouseEvent mouseEvent) {
    }

    private void updateTooltipText(ParagraphSegment paragraphSegment) {
        String string;
        String string2 = null;
        if (paragraphSegment != null) {
            string2 = paragraphSegment.getTooltipText();
        }
        if ((string = this.getToolTipText()) != null && string2 == null || string == null && string2 != null) {
            this.setToolTipText(string2);
        }
    }

    private void handleMouseMove(MouseEvent mouseEvent) {
        if (this.inSelection) {
            this.handleDrag(mouseEvent);
            return;
        }
        ParagraphSegment paragraphSegment = this.model.findSegmentAt(mouseEvent.x, mouseEvent.y);
        this.updateTooltipText(paragraphSegment);
        if (paragraphSegment == null) {
            if (this.entered != null) {
                this.exitLink(this.entered, mouseEvent.stateMask);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            this.setCursor(null);
        } else if (paragraphSegment instanceof IHyperlinkSegment) {
            IHyperlinkSegment iHyperlinkSegment = (IHyperlinkSegment)((Object)paragraphSegment);
            if (this.entered != null && iHyperlinkSegment != this.entered) {
                this.exitLink(this.entered, mouseEvent.stateMask);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            if (this.entered == null) {
                this.entered = iHyperlinkSegment;
                this.enterLink(iHyperlinkSegment, mouseEvent.stateMask);
                this.paintLinkHover(this.entered, true);
                this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
            }
        } else {
            if (this.entered != null) {
                this.exitLink(this.entered, mouseEvent.stateMask);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            if (paragraphSegment instanceof TextSegment) {
                this.setCursor(this.model.getHyperlinkSettings().getTextCursor());
            } else {
                this.setCursor(null);
            }
        }
    }

    private boolean advance(boolean bl) {
        IHyperlinkSegment iHyperlinkSegment;
        IHyperlinkSegment iHyperlinkSegment2;
        IFocusSelectable iFocusSelectable = this.model.getSelectedSegment();
        if (iFocusSelectable != null && iFocusSelectable instanceof IHyperlinkSegment) {
            this.exitLink((IHyperlinkSegment)iFocusSelectable, 0);
        }
        IFocusSelectable iFocusSelectable2 = null;
        boolean bl2 = false;
        while (!bl2) {
            if (!this.model.traverseFocusSelectableObjects(bl) || (iFocusSelectable2 = this.model.getSelectedSegment()) == null) break;
            bl2 = this.setControlFocus(bl, iFocusSelectable2);
        }
        IHyperlinkSegment iHyperlinkSegment3 = iHyperlinkSegment2 = iFocusSelectable2 instanceof IHyperlinkSegment ? (IHyperlinkSegment)iFocusSelectable2 : null;
        if (bl2) {
            this.enterLink(iHyperlinkSegment2, 0);
        }
        IHyperlinkSegment iHyperlinkSegment4 = iHyperlinkSegment = iFocusSelectable instanceof IHyperlinkSegment ? (IHyperlinkSegment)iFocusSelectable : null;
        if (iHyperlinkSegment != null || iHyperlinkSegment2 != null) {
            this.paintFocusTransfer(iHyperlinkSegment, iHyperlinkSegment2);
        }
        if (iHyperlinkSegment2 != null) {
            this.ensureVisible(iHyperlinkSegment2);
        }
        if (iHyperlinkSegment2 != null) {
            this.getAccessible().setFocus(this.model.getSelectedSegmentIndex());
        }
        return !bl2;
    }

    private boolean setControlFocus(boolean bl, IFocusSelectable iFocusSelectable) {
        this.controlFocusTransfer = true;
        boolean bl2 = iFocusSelectable.setFocus(this.resourceTable, bl);
        this.controlFocusTransfer = false;
        return bl2;
    }

    private void handleFocusChange() {
        if (this.hasFocus) {
            boolean bl = true;
            if (!this.mouseFocus) {
                boolean bl2 = false;
                IFocusSelectable iFocusSelectable = null;
                while (!bl2) {
                    if (!this.model.traverseFocusSelectableObjects(bl) || (iFocusSelectable = this.model.getSelectedSegment()) == null) break;
                    bl2 = this.setControlFocus(bl, iFocusSelectable);
                }
                if (iFocusSelectable != null) {
                    this.ensureVisible(iFocusSelectable);
                }
                if (iFocusSelectable instanceof IHyperlinkSegment) {
                    this.enterLink((IHyperlinkSegment)iFocusSelectable, 0);
                    this.paintFocusTransfer(null, (IHyperlinkSegment)iFocusSelectable);
                }
            }
        } else {
            this.paintFocusTransfer(this.getSelectedLink(), null);
            this.model.selectLink(null);
        }
        if (!this.model.hasFocusSegments()) {
            this.redraw();
        }
    }

    private void enterLink(IHyperlinkSegment iHyperlinkSegment, int n) {
        if (iHyperlinkSegment == null || this.listeners == null) {
            return;
        }
        int n2 = this.listeners.size();
        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent((Widget)this, iHyperlinkSegment.getHref(), iHyperlinkSegment.getText(), n);
        Object[] objectArray = this.listeners.getListeners();
        int n3 = 0;
        while (n3 < n2) {
            IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)objectArray[n3];
            iHyperlinkListener.linkEntered(hyperlinkEvent);
            ++n3;
        }
    }

    private void exitLink(IHyperlinkSegment iHyperlinkSegment, int n) {
        if (iHyperlinkSegment == null || this.listeners == null) {
            return;
        }
        int n2 = this.listeners.size();
        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent((Widget)this, iHyperlinkSegment.getHref(), iHyperlinkSegment.getText(), n);
        Object[] objectArray = this.listeners.getListeners();
        int n3 = 0;
        while (n3 < n2) {
            IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)objectArray[n3];
            iHyperlinkListener.linkExited(hyperlinkEvent);
            ++n3;
        }
    }

    private void paintLinkHover(IHyperlinkSegment iHyperlinkSegment, boolean bl) {
        Color color;
        GC gC = new GC((Drawable)this);
        HyperlinkSettings hyperlinkSettings = this.getHyperlinkSettings();
        Color color2 = color = bl ? hyperlinkSettings.getActiveForeground() : hyperlinkSettings.getForeground();
        if (color != null) {
            gC.setForeground(color);
        }
        gC.setBackground(this.getBackground());
        gC.setFont(this.getFont());
        boolean bl2 = iHyperlinkSegment == this.getSelectedLink();
        ((ParagraphSegment)((Object)iHyperlinkSegment)).paint(gC, bl, this.resourceTable, bl2, this.selData, null);
        gC.dispose();
    }

    private void activateSelectedLink() {
        IHyperlinkSegment iHyperlinkSegment = this.getSelectedLink();
        if (iHyperlinkSegment != null) {
            this.activateLink(iHyperlinkSegment, 0);
        }
    }

    private void activateLink(IHyperlinkSegment iHyperlinkSegment, int n) {
        this.setCursor(this.model.getHyperlinkSettings().getBusyCursor());
        if (this.listeners != null) {
            int n2 = this.listeners.size();
            HyperlinkEvent hyperlinkEvent = new HyperlinkEvent((Widget)this, iHyperlinkSegment.getHref(), iHyperlinkSegment.getText(), n);
            Object[] objectArray = this.listeners.getListeners();
            int n3 = 0;
            while (n3 < n2) {
                IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)objectArray[n3];
                iHyperlinkListener.linkActivated(hyperlinkEvent);
                ++n3;
            }
        }
        if (!this.isDisposed() && this.model.linkExists(iHyperlinkSegment)) {
            this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
        }
    }

    private void ensureBoldFontPresent(Font font) {
        Font font2 = (Font)this.resourceTable.get("f.____bold");
        if (font2 != null) {
            return;
        }
        font2 = FormFonts.getInstance().getBoldFont(this.getDisplay(), font);
        this.resourceTable.put("f.____bold", font2);
    }

    private void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        gC.setFont(this.getFont());
        this.ensureBoldFontPresent(this.getFont());
        gC.setForeground(this.getForeground());
        gC.setBackground(this.getBackground());
        this.repaint(gC, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
    }

    private void repaint(GC gC, int n, int n2, int n3, int n4) {
        Image image = new Image((Device)this.getDisplay(), n3, n4);
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (!this.getEnabled()) {
            color = this.getDisplay().getSystemColor(22);
            color2 = this.getDisplay().getSystemColor(18);
        }
        GC gC2 = new GC((Drawable)image, gC.getStyle());
        gC2.setForeground(color2);
        gC2.setBackground(color);
        gC2.setFont(this.getFont());
        gC2.fillRectangle(0, 0, n3, n4);
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Paragraph[] paragraphArray = this.model.getParagraphs();
        IHyperlinkSegment iHyperlinkSegment = this.getSelectedLink();
        if (this.getDisplay().getFocusControl() != this) {
            iHyperlinkSegment = null;
        }
        int n5 = 0;
        while (n5 < paragraphArray.length) {
            Paragraph paragraph = paragraphArray[n5];
            paragraph.paint(gC2, rectangle, this.resourceTable, iHyperlinkSegment, this.selData);
            ++n5;
        }
        gC2.dispose();
        gC.drawImage(image, n, n2);
        image.dispose();
    }

    private int getParagraphSpacing(int n) {
        return n / 2;
    }

    private void paintFocusTransfer(IHyperlinkSegment iHyperlinkSegment, IHyperlinkSegment iHyperlinkSegment2) {
        Rectangle rectangle;
        if (iHyperlinkSegment != null) {
            rectangle = iHyperlinkSegment.getBounds();
            this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            this.update();
        }
        if (iHyperlinkSegment2 != null) {
            rectangle = new GC((Drawable)this);
            Color color = this.getBackground();
            Color color2 = this.getForeground();
            rectangle.setFont(this.getFont());
            rectangle.setBackground(color);
            rectangle.setForeground(color2);
            iHyperlinkSegment2.paintFocus((GC)rectangle, color, color2, true, null);
            rectangle.dispose();
        }
    }

    private void ensureVisible(IFocusSelectable iFocusSelectable) {
        if (this.mouseFocus) {
            this.mouseFocus = false;
            return;
        }
        if (iFocusSelectable == null) {
            return;
        }
        Rectangle rectangle = iFocusSelectable.getBounds();
        ScrolledComposite scrolledComposite = FormUtil.getScrolledComposite((Control)this);
        if (scrolledComposite == null) {
            return;
        }
        Point point = FormUtil.getControlLocation(scrolledComposite, (Control)this);
        point.x += rectangle.x;
        point.y += rectangle.y;
        FormUtil.ensureVisible(scrolledComposite, point, new Point(rectangle.width, rectangle.height));
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        FormTextLayout formTextLayout = (FormTextLayout)this.getLayout();
        Point point = n == -1 || n2 == -1 ? formTextLayout.computeSize((Composite)this, n, n2, bl) : new Point(n, n2);
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    private void disposeResourceTable(boolean bl) {
        Font font;
        if (bl && (font = (Font)this.resourceTable.get("f.____bold")) != null) {
            FormFonts.getInstance().markFinished(font, this.getDisplay());
            this.resourceTable.remove("f.____bold");
        }
        font = new ArrayList();
        Enumeration enumeration = this.resourceTable.keys();
        while (enumeration.hasMoreElements()) {
            Image image;
            Object v;
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("isel.") || !((v = this.resourceTable.get(string)) instanceof Image) || (image = (Image)v).isDisposed()) continue;
            image.dispose();
            font.add(string);
        }
        int n = 0;
        while (n < font.size()) {
            this.resourceTable.remove(font.get(n));
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.redraw();
    }

    public boolean setFocus() {
        this.mouseFocus = true;
        FormUtil.setFocusScrollingEnabled((Control)this, false);
        boolean bl = super.setFocus();
        this.mouseFocus = false;
        FormUtil.setFocusScrollingEnabled((Control)this, true);
        return bl;
    }

    private class FormTextLayout
    extends Layout
    implements ILayoutExtension {
        @Override
        public int computeMaximumWidth(Composite composite, boolean bl) {
            return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)bl).x;
        }

        @Override
        public int computeMinimumWidth(Composite composite, boolean bl) {
            return this.computeSize((Composite)composite, (int)5, (int)-1, (boolean)true).x;
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            long l = 0L;
            int n3 = n;
            if (n3 != -1) {
                n3 -= FormText.this.marginWidth * 2;
            }
            Point point = this.computeTextSize(n3);
            int n4 = point.x + 2 * FormText.this.marginWidth;
            int n5 = point.y + 2 * FormText.this.marginHeight;
            Point point2 = new Point(n4, n5);
            return point2;
        }

        private Point computeTextSize(int n) {
            Paragraph[] paragraphArray = FormText.this.model.getParagraphs();
            GC gC = new GC((Drawable)FormText.this);
            gC.setFont(FormText.this.getFont());
            Locator locator = new Locator();
            int n2 = n != -1 ? n : 0;
            FontMetrics fontMetrics = gC.getFontMetrics();
            int n3 = fontMetrics.getHeight();
            boolean bl = false;
            int n4 = 0;
            while (n4 < paragraphArray.length) {
                Paragraph paragraph = paragraphArray[n4];
                if (n4 > 0 && FormText.this.getParagraphsSeparated() && paragraph.getAddVerticalSpace()) {
                    locator.y += FormText.this.getParagraphSpacing(n3);
                }
                locator.rowHeight = 0;
                locator.indent = paragraph.getIndent();
                locator.x = paragraph.getIndent();
                ParagraphSegment[] paragraphSegmentArray = paragraph.getSegments();
                if (paragraphSegmentArray.length > 0) {
                    bl = false;
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < paragraphSegmentArray.length) {
                        ParagraphSegment paragraphSegment = paragraphSegmentArray[n6];
                        paragraphSegment.advanceLocator(gC, n, locator, FormText.this.resourceTable, false);
                        if (n != -1) {
                            n2 = Math.max(n2, locator.width);
                        } else {
                            n5 = Math.max(n5, locator.width);
                        }
                        if (paragraphSegment instanceof IFocusSelectable) {
                            bl = true;
                        }
                        ++n6;
                    }
                    if (n == -1) {
                        n2 = Math.max(n2, n5);
                    }
                    locator.y += locator.rowHeight;
                } else {
                    locator.y += n3;
                }
                ++n4;
            }
            gC.dispose();
            if (bl) {
                ++locator.y;
            }
            return new Point(n2, locator.y);
        }

        protected void layout(Composite composite, boolean bl) {
            long l = 0L;
            FormText.this.selData = null;
            Rectangle rectangle = composite.getClientArea();
            GC gC = new GC((Drawable)composite);
            gC.setFont(FormText.this.getFont());
            FormText.this.ensureBoldFontPresent(FormText.this.getFont());
            gC.setForeground(FormText.this.getForeground());
            gC.setBackground(FormText.this.getBackground());
            Locator locator = new Locator();
            locator.marginWidth = FormText.this.marginWidth;
            locator.marginHeight = FormText.this.marginHeight;
            locator.y = FormText.this.marginHeight;
            FontMetrics fontMetrics = gC.getFontMetrics();
            int n = fontMetrics.getHeight();
            Paragraph[] paragraphArray = FormText.this.model.getParagraphs();
            IHyperlinkSegment iHyperlinkSegment = FormText.this.getSelectedLink();
            int n2 = 0;
            while (n2 < paragraphArray.length) {
                Paragraph paragraph = paragraphArray[n2];
                if (n2 > 0 && FormText.this.paragraphsSeparated && paragraph.getAddVerticalSpace()) {
                    locator.y += FormText.this.getParagraphSpacing(n);
                }
                locator.indent = paragraph.getIndent();
                locator.resetCaret();
                locator.rowHeight = 0;
                paragraph.layout(gC, rectangle.width, locator, n, FormText.this.resourceTable, iHyperlinkSegment);
                ++n2;
            }
            gC.dispose();
        }
    }
}

