/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.forms.widgets.ToggleHyperlink;
import org.eclipse.ui.forms.widgets.TreeNode;
import org.eclipse.ui.forms.widgets.Twistie;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.FormsResources;

public class ExpandableComposite
extends Canvas {
    public static final int TWISTIE = 2;
    public static final int TREE_NODE = 4;
    public static final int FOCUS_TITLE = 8;
    public static final int CLIENT_INDENT = 16;
    public static final int COMPACT = 32;
    public static final int EXPANDED = 64;
    public static final int TITLE_BAR = 256;
    public static final int SHORT_TITLE_BAR = 512;
    public static final int NO_TITLE = 4096;
    public static final int LEFT_TEXT_CLIENT_ALIGNMENT = 8192;
    public static final int NO_TITLE_FOCUS_BOX = 16384;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int clientVerticalSpacing = 3;
    public int descriptionVerticalSpacing = 0;
    public int titleBarTextMarginWidth = 6;
    protected ToggleHyperlink toggle;
    protected Control textLabel;
    protected int VGAP = 3;
    protected int GAP = 4;
    static final int IGAP = 4;
    static final int IVGAP = 3;
    private static final Point NULL_SIZE = new Point(0, 0);
    private static final int VSPACE = 3;
    private static final int SEPARATOR_HEIGHT = 2;
    private int expansionStyle = 74;
    private boolean expanded;
    private Control textClient;
    private Control client;
    private ListenerList listeners = new ListenerList();
    private Color titleBarForeground;

    public ExpandableComposite(Composite composite, int n) {
        this(composite, n, 2);
    }

    public ExpandableComposite(Composite composite, int n, int n2) {
        super(composite, n);
        this.expansionStyle = n2;
        if ((n2 & 0x100) != 0) {
            this.setBackgroundMode(1);
        }
        super.setLayout((Layout)new ExpandableLayout());
        if (this.hasTitleBar()) {
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    ExpandableComposite.this.onPaint(paintEvent);
                }
            });
        }
        if ((n2 & 2) != 0) {
            this.toggle = new Twistie((Composite)this, 0);
        } else if ((n2 & 4) != 0) {
            this.toggle = new TreeNode((Composite)this, 0);
        } else {
            this.expanded = true;
        }
        if ((n2 & 0x40) != 0) {
            this.expanded = true;
        }
        if (this.toggle != null) {
            this.toggle.setExpanded(this.expanded);
            this.toggle.addHyperlinkListener(new HyperlinkAdapter(){

                @Override
                public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                    ExpandableComposite.this.toggleState();
                }
            });
            this.toggle.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    if (ExpandableComposite.this.textLabel instanceof Label && !ExpandableComposite.this.isFixedStyle()) {
                        ExpandableComposite.this.textLabel.setForeground(ExpandableComposite.this.toggle.hover ? ExpandableComposite.this.toggle.getHoverDecorationColor() : ExpandableComposite.this.getTitleBarForeground());
                    }
                }
            });
            this.toggle.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.keyCode == 0x1000001) {
                        ExpandableComposite.this.verticalMove(false);
                        keyEvent.doit = false;
                    } else if (keyEvent.keyCode == 0x1000002) {
                        ExpandableComposite.this.verticalMove(true);
                        keyEvent.doit = false;
                    }
                }
            });
            if ((this.getExpansionStyle() & 8) == 0) {
                this.toggle.paintFocus = false;
                this.toggle.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent focusEvent) {
                        if (ExpandableComposite.this.textLabel != null) {
                            ExpandableComposite.this.textLabel.redraw();
                        }
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        if (ExpandableComposite.this.textLabel != null) {
                            ExpandableComposite.this.textLabel.redraw();
                        }
                    }
                });
            }
        }
        if ((n2 & 8) != 0) {
            Hyperlink hyperlink = new Hyperlink((Composite)this, 64);
            hyperlink.addHyperlinkListener(new HyperlinkAdapter(){

                @Override
                public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                    ExpandableComposite.this.programmaticToggleState();
                }
            });
            this.textLabel = hyperlink;
        } else if ((n2 & 0x1000) == 0) {
            final Label label = new Label((Composite)this, 64);
            if (!this.isFixedStyle()) {
                label.setCursor(FormsResources.getHandCursor());
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.type) {
                            case 3: {
                                if (ExpandableComposite.this.toggle == null) break;
                                ExpandableComposite.this.toggle.setFocus();
                                break;
                            }
                            case 4: {
                                label.setCursor(FormsResources.getBusyCursor());
                                ExpandableComposite.this.programmaticToggleState();
                                label.setCursor(FormsResources.getHandCursor());
                                break;
                            }
                            case 6: {
                                if (ExpandableComposite.this.toggle == null) break;
                                label.setForeground(ExpandableComposite.this.toggle.getHoverDecorationColor());
                                ExpandableComposite.this.toggle.hover = true;
                                ExpandableComposite.this.toggle.redraw();
                                break;
                            }
                            case 7: {
                                if (ExpandableComposite.this.toggle == null) break;
                                label.setForeground(ExpandableComposite.this.getTitleBarForeground());
                                ExpandableComposite.this.toggle.hover = false;
                                ExpandableComposite.this.toggle.redraw();
                                break;
                            }
                            case 9: {
                                if (ExpandableComposite.this.toggle == null) break;
                                ExpandableComposite.this.getExpansionStyle();
                            }
                        }
                    }
                };
                label.addListener(3, listener);
                label.addListener(4, listener);
                label.addListener(6, listener);
                label.addListener(7, listener);
                label.addListener(9, listener);
            }
            this.textLabel = label;
        }
        if (this.textLabel != null) {
            this.textLabel.setMenu(this.getMenu());
            this.textLabel.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent traverseEvent) {
                    if (traverseEvent.detail == 128) {
                        if (!ExpandableComposite.this.isVisible() || !ExpandableComposite.this.isEnabled()) {
                            return;
                        }
                        if (FormUtil.mnemonicMatch(ExpandableComposite.this.getText(), traverseEvent.character)) {
                            traverseEvent.doit = false;
                            if (!ExpandableComposite.this.isFixedStyle()) {
                                ExpandableComposite.this.programmaticToggleState();
                            }
                            ExpandableComposite.this.setFocus();
                        }
                    }
                }
            });
        }
    }

    public boolean forceFocus() {
        return false;
    }

    public void setMenu(Menu menu) {
        if (this.textLabel != null) {
            this.textLabel.setMenu(menu);
        }
        super.setMenu(menu);
    }

    public final void setLayout(Layout layout) {
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if ((this.getExpansionStyle() & 0x100) == 0) {
            if (this.textLabel != null) {
                this.textLabel.setBackground(color);
            }
            if (this.toggle != null) {
                this.toggle.setBackground(color);
            }
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.textLabel != null) {
            this.textLabel.setForeground(color);
        }
        if (this.toggle != null) {
            this.toggle.setForeground(color);
        }
    }

    public void setToggleColor(Color color) {
        if (this.toggle != null) {
            this.toggle.setDecorationColor(color);
        }
    }

    public void setActiveToggleColor(Color color) {
        if (this.toggle != null) {
            this.toggle.setHoverDecorationColor(color);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.textLabel != null) {
            this.textLabel.setFont(font);
        }
        if (this.toggle != null) {
            this.toggle.setFont(font);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.textLabel != null) {
            this.textLabel.setEnabled(bl);
        }
        if (this.toggle != null) {
            this.toggle.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public void setClient(Control control) {
        Assert.isTrue((control != null && control.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.client = control;
    }

    public Control getClient() {
        return this.client;
    }

    public void setText(String string) {
        if (this.textLabel instanceof Label) {
            ((Label)this.textLabel).setText(string);
        } else if (this.textLabel instanceof Hyperlink) {
            ((Hyperlink)this.textLabel).setText(string);
        } else {
            return;
        }
        this.layout();
    }

    public String getText() {
        if (this.textLabel instanceof Label) {
            return ((Label)this.textLabel).getText();
        }
        if (this.textLabel instanceof Hyperlink) {
            return ((Hyperlink)this.textLabel).getText();
        }
        return "";
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int getExpansionStyle() {
        return this.expansionStyle;
    }

    public void setExpanded(boolean bl) {
        this.internalSetExpanded(bl);
        if (this.toggle != null) {
            this.toggle.setExpanded(bl);
        }
    }

    protected void internalSetExpanded(boolean bl) {
        if (this.expanded != bl) {
            this.expanded = bl;
            if (this.getDescriptionControl() != null) {
                this.getDescriptionControl().setVisible(bl);
            }
            if (this.client != null) {
                this.client.setVisible(bl);
            }
            this.layout();
        }
    }

    public void addExpansionListener(IExpansionListener iExpansionListener) {
        this.listeners.add((Object)iExpansionListener);
    }

    public void removeExpansionListener(IExpansionListener iExpansionListener) {
        this.listeners.remove((Object)iExpansionListener);
    }

    protected void onPaint(PaintEvent paintEvent) {
    }

    protected Control getDescriptionControl() {
        return null;
    }

    protected Control getSeparatorControl() {
        return null;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        ExpandableLayout expandableLayout = (ExpandableLayout)this.getLayout();
        Point point = n == -1 || n2 == -1 ? expandableLayout.computeSize((Composite)this, n, n2, bl) : new Point(n, n2);
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    protected boolean isFixedStyle() {
        return (this.expansionStyle & 2) == 0 && (this.expansionStyle & 4) == 0;
    }

    public Control getTextClient() {
        return this.textClient;
    }

    public void setTextClient(Control control) {
        if (this.textClient != null) {
            this.textClient.dispose();
        }
        this.textClient = control;
    }

    public int getTextClientHeightDifference() {
        if (this.textClient == null || this.textLabel == null) {
            return 0;
        }
        int n = this.textLabel.computeSize((int)-1, (int)-1).y;
        int n2 = this.textClient.computeSize((int)-1, (int)-1).y;
        return Math.max(n2 - n, 0);
    }

    protected boolean hasTitleBar() {
        return (this.getExpansionStyle() & 0x100) != 0 || (this.getExpansionStyle() & 0x200) != 0;
    }

    public void setTitleBarForeground(Color color) {
        if (this.hasTitleBar()) {
            this.titleBarForeground = color;
        }
        if (this.textLabel != null) {
            this.textLabel.setForeground(color);
        }
    }

    public Color getTitleBarForeground() {
        return this.titleBarForeground;
    }

    private void toggleState() {
        boolean bl = !this.isExpanded();
        this.fireExpanding(bl, true);
        this.internalSetExpanded(bl);
        this.fireExpanding(bl, false);
        if (bl) {
            FormUtil.ensureVisible((Control)this);
        }
    }

    private void fireExpanding(boolean bl, boolean bl2) {
        int n = this.listeners.size();
        if (n == 0) {
            return;
        }
        ExpansionEvent expansionEvent = new ExpansionEvent((Object)this, bl);
        Object[] objectArray = this.listeners.getListeners();
        int n2 = 0;
        while (n2 < n) {
            IExpansionListener iExpansionListener = (IExpansionListener)objectArray[n2];
            if (bl2) {
                iExpansionListener.expansionStateChanging(expansionEvent);
            } else {
                iExpansionListener.expansionStateChanged(expansionEvent);
            }
            ++n2;
        }
    }

    private void verticalMove(boolean bl) {
        Composite composite = this.getParent();
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control == this) {
                ExpandableComposite expandableComposite = this.getSibling(controlArray, n, bl);
                if (expandableComposite == null || expandableComposite.toggle == null) break;
                expandableComposite.setFocus();
                break;
            }
            ++n;
        }
    }

    private ExpandableComposite getSibling(Control[] controlArray, int n, boolean bl) {
        int n2 = bl ? n + 1 : n - 1;
        while (n2 >= 0 && n2 < controlArray.length) {
            Control control = controlArray[n2];
            if (control instanceof ExpandableComposite && control.isVisible()) {
                return (ExpandableComposite)control;
            }
            int n3 = n2 = bl ? n2 + 1 : n2 - 1;
        }
        return null;
    }

    private void programmaticToggleState() {
        if (this.toggle != null) {
            this.toggle.setExpanded(!this.toggle.isExpanded());
        }
        this.toggleState();
    }

    private void paintTitleFocus(GC gC) {
        Point point = this.textLabel.getSize();
        gC.setBackground(this.textLabel.getBackground());
        gC.setForeground(this.textLabel.getForeground());
        if (this.toggle.isFocusControl()) {
            gC.drawFocus(0, 0, point.x, point.y);
        }
    }

    private class ExpandableLayout
    extends Layout
    implements ILayoutExtension {
        private SizeCache toggleCache = new SizeCache();
        private SizeCache textClientCache = new SizeCache();
        private SizeCache textLabelCache = new SizeCache();
        private SizeCache descriptionCache = new SizeCache();
        private SizeCache clientCache = new SizeCache();

        private ExpandableLayout() {
        }

        private void initCache(boolean bl) {
            this.toggleCache.setControl((Control)ExpandableComposite.this.toggle);
            this.textClientCache.setControl(ExpandableComposite.this.textClient);
            this.textLabelCache.setControl(ExpandableComposite.this.textLabel);
            this.descriptionCache.setControl(ExpandableComposite.this.getDescriptionControl());
            this.clientCache.setControl(ExpandableComposite.this.client);
            if (bl) {
                this.toggleCache.flush();
                this.textClientCache.flush();
                this.textLabelCache.flush();
                this.descriptionCache.flush();
                this.clientCache.flush();
            }
        }

        protected void layout(Composite composite, boolean bl) {
            int n;
            String string;
            Point point;
            this.initCache(bl);
            Rectangle rectangle = composite.getClientArea();
            int n2 = 0;
            int n3 = 0;
            if (ExpandableComposite.this.hasTitleBar()) {
                n2 = ExpandableComposite.this.titleBarTextMarginWidth;
                n3 = 3;
            }
            int n4 = ExpandableComposite.this.marginWidth + n2;
            int n5 = ExpandableComposite.this.marginHeight + n3;
            Point point2 = NULL_SIZE;
            Point point3 = NULL_SIZE;
            if (ExpandableComposite.this.toggle != null) {
                point2 = this.toggleCache.computeSize(-1, -1);
            }
            int n6 = rectangle.width - ExpandableComposite.this.marginWidth - ExpandableComposite.this.marginWidth - n2 - n2;
            if (point2.x > 0) {
                n6 -= point2.x + 4;
            }
            if (ExpandableComposite.this.textClient != null) {
                point3 = this.textClientCache.computeSize(-1, -1);
            }
            Point point4 = NULL_SIZE;
            if (ExpandableComposite.this.textLabel != null) {
                if (point3.x > 0 && FormUtil.isWrapControl(ExpandableComposite.this.textClient)) {
                    point4 = this.textLabelCache.computeSize(-1, -1);
                    if (n6 < point4.x + 4 + point3.x) {
                        n6 -= 4;
                        if (ExpandableComposite.this.textLabel instanceof Label) {
                            point = new GC((Drawable)ExpandableComposite.this.textLabel);
                            point4 = FormUtil.computeWrapSize((GC)point, ((Label)ExpandableComposite.this.textLabel).getText(), Math.round((float)n6 * ((float)point4.x / (float)(point4.x + point3.x))));
                            point.dispose();
                        } else {
                            point4 = this.textLabelCache.computeSize(Math.round((float)n6 * ((float)point4.x / (float)(point4.x + point3.x))), -1);
                        }
                        point3 = this.textClientCache.computeSize(n6 - point4.x, -1);
                    }
                } else {
                    if (point3.x > 0) {
                        n6 -= point3.x + 4;
                    }
                    point4 = this.textLabelCache.computeSize(n6, -1);
                }
            }
            if (ExpandableComposite.this.textLabel instanceof Label) {
                point = this.textLabelCache.computeSize(-1, -1);
                if (point.y == point4.y) {
                    point4.x = Math.min(point.x, point4.x);
                }
            }
            if (ExpandableComposite.this.toggle != null) {
                point = new GC((Drawable)ExpandableComposite.this);
                point.setFont(ExpandableComposite.this.getFont());
                string = point.getFontMetrics();
                n = string.getHeight();
                point.dispose();
                if (ExpandableComposite.this.textClient != null && (ExpandableComposite.this.expansionStyle & 0x2000) != 0) {
                    n = Math.max(n, point3.y);
                }
                int n7 = n / 2 - point2.y / 2 + 1;
                n7 = Math.max(n7, 0);
                ExpandableComposite.this.toggle.setLocation(n4, n7 += ExpandableComposite.this.marginHeight + n3);
                ExpandableComposite.this.toggle.setSize(point2);
                n4 += point2.x + 4;
            }
            if (ExpandableComposite.this.textLabel != null) {
                int n8 = n5;
                if (ExpandableComposite.this.textClient != null && (ExpandableComposite.this.expansionStyle & 0x2000) != 0 && point4.y < point3.y) {
                    n8 = point3.y / 2 - point4.y / 2 + ExpandableComposite.this.marginHeight + n3;
                }
                if ("linux".equalsIgnoreCase(string = System.getProperty("os.name"))) {
                    ++point4.x;
                }
                this.textLabelCache.setBounds(n4, n8, point4.x, point4.y);
            }
            if (ExpandableComposite.this.textClient != null) {
                int n9 = (ExpandableComposite.this.expansionStyle & 0x2000) != 0 ? n4 + point4.x + ExpandableComposite.this.GAP : rectangle.width - point3.x - ExpandableComposite.this.marginWidth - n2;
                this.textClientCache.setBounds(n9, n5, point3.x, point3.y);
            }
            int n10 = 0;
            if (point4.y > 0) {
                n10 = point4.y;
            }
            if (point3.y > 0) {
                n10 = Math.max(n10, point3.y);
            }
            n5 += n10;
            if (ExpandableComposite.this.hasTitleBar()) {
                n5 += n3;
            }
            if (ExpandableComposite.this.getSeparatorControl() != null) {
                ExpandableComposite.this.getSeparatorControl().setBounds(ExpandableComposite.this.marginWidth, n5 += 3, rectangle.width - ExpandableComposite.this.marginWidth - ExpandableComposite.this.marginWidth, 2);
                n5 += 2;
                if (ExpandableComposite.this.expanded) {
                    n5 += 3;
                }
            }
            if (ExpandableComposite.this.expanded) {
                int n11 = rectangle.width - ExpandableComposite.this.marginWidth - n2;
                n = ExpandableComposite.this.marginWidth + n2;
                if ((ExpandableComposite.this.expansionStyle & 0x10) != 0) {
                    n = n4;
                }
                n11 -= n;
                if (ExpandableComposite.this.client != null) {
                    Point point5 = null;
                    Control control = ExpandableComposite.this.getDescriptionControl();
                    if (control != null) {
                        point5 = this.descriptionCache.computeSize(n11, -1);
                        this.descriptionCache.setBounds(n, n5 += ExpandableComposite.this.descriptionVerticalSpacing, n11, point5.y);
                        n5 += point5.y + ExpandableComposite.this.clientVerticalSpacing;
                    } else {
                        n5 += ExpandableComposite.this.clientVerticalSpacing;
                        if (ExpandableComposite.this.getSeparatorControl() != null) {
                            n5 -= 3;
                        }
                    }
                    int n12 = n11;
                    int n13 = rectangle.height - ExpandableComposite.this.marginHeight - ExpandableComposite.this.marginHeight - n5;
                    this.clientCache.setBounds(n, n5, n12, n13);
                }
            }
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Point point;
            int n3;
            this.initCache(bl);
            int n4 = 0;
            int n5 = 0;
            Point point2 = NULL_SIZE;
            int n6 = 0;
            if (ExpandableComposite.this.toggle != null) {
                point2 = this.toggleCache.computeSize(-1, -1);
                n6 = point2.x + 4;
            }
            int n7 = 0;
            int n8 = 0;
            if (ExpandableComposite.this.hasTitleBar()) {
                n7 = ExpandableComposite.this.titleBarTextMarginWidth;
                n8 = 3;
            }
            if ((n3 = n) != -1) {
                n3 -= n6 + ExpandableComposite.this.marginWidth + ExpandableComposite.this.marginWidth + n7 + n7;
            }
            int n9 = n3;
            Point point3 = NULL_SIZE;
            if (ExpandableComposite.this.textClient != null) {
                point3 = this.textClientCache.computeSize(-1, -1);
            }
            Point point4 = NULL_SIZE;
            if (ExpandableComposite.this.textLabel != null) {
                if (point3.x > 0 && FormUtil.isWrapControl(ExpandableComposite.this.textClient)) {
                    point4 = this.textLabelCache.computeSize(-1, -1);
                    if (n9 != -1 && n9 < point4.x + 4 + point3.x) {
                        n9 -= 4;
                        if (ExpandableComposite.this.textLabel instanceof Label) {
                            point = new GC((Drawable)ExpandableComposite.this.textLabel);
                            point4 = FormUtil.computeWrapSize((GC)point, ((Label)ExpandableComposite.this.textLabel).getText(), Math.round((float)n9 * ((float)point4.x / (float)(point4.x + point3.x))));
                            point.dispose();
                        } else {
                            point4 = this.textLabelCache.computeSize(Math.round((float)n9 * ((float)point4.x / (float)(point4.x + point3.x))), -1);
                        }
                        point3 = this.textClientCache.computeSize(n9 - point4.x, -1);
                    }
                } else {
                    if (n9 != -1 && point3.x > 0) {
                        n9 -= 4 + point3.x;
                    }
                    point4 = this.textLabelCache.computeSize(n9, -1);
                }
            }
            if (ExpandableComposite.this.textLabel instanceof Label) {
                point = this.textLabelCache.computeSize(-1, -1);
                if (point.y == point4.y) {
                    point4.x = Math.min(point.x, point4.x);
                }
            }
            if (point4.x > 0) {
                n4 = point4.x;
            }
            if (point3.x > 0) {
                n4 += 4 + point3.x;
            }
            if (ExpandableComposite.this.toggle != null) {
                n4 += n6;
            }
            int n10 = n5 = point3.y > 0 ? Math.max(point3.y, point4.y) : point4.y;
            if (ExpandableComposite.this.getSeparatorControl() != null) {
                n5 += 5;
                if (ExpandableComposite.this.expanded && ExpandableComposite.this.client != null) {
                    n5 += 3;
                }
            }
            if ((ExpandableComposite.this.expanded || (ExpandableComposite.this.expansionStyle & 0x20) == 0) && ExpandableComposite.this.client != null) {
                int n11 = n;
                int n12 = 0;
                if ((ExpandableComposite.this.expansionStyle & 0x10) != 0) {
                    n12 = n6;
                }
                if (n11 != -1) {
                    n11 -= ExpandableComposite.this.marginWidth + ExpandableComposite.this.marginWidth + n7 + n7;
                    if ((ExpandableComposite.this.expansionStyle & 0x10) != 0 && point3.x > 0) {
                        n11 -= n6;
                    }
                }
                Point point5 = null;
                Point point6 = this.clientCache.computeSize(FormUtil.getWidthHint(n11, ExpandableComposite.this.client), -1);
                if (ExpandableComposite.this.getDescriptionControl() != null) {
                    int n13 = n11;
                    if (n13 == -1) {
                        n13 = point6.x;
                        if ((ExpandableComposite.this.expansionStyle & 0x10) != 0) {
                            n13 -= n6;
                        }
                    }
                    point5 = this.descriptionCache.computeSize(n13, -1);
                }
                if (point5 != null) {
                    n4 = Math.max(n4, point5.x + n12);
                    if (ExpandableComposite.this.expanded) {
                        n5 += ExpandableComposite.this.descriptionVerticalSpacing + point5.y + ExpandableComposite.this.clientVerticalSpacing;
                    }
                } else {
                    n5 += ExpandableComposite.this.clientVerticalSpacing;
                    if (ExpandableComposite.this.getSeparatorControl() != null) {
                        n5 -= 3;
                    }
                }
                n4 = Math.max(n4, point6.x + n12);
                if (ExpandableComposite.this.expanded) {
                    n5 += point6.y;
                }
            }
            if (ExpandableComposite.this.toggle != null) {
                n5 = n5 - point4.y + Math.max(point4.y, point2.y);
            }
            Point point7 = new Point(n4 + ExpandableComposite.this.marginWidth + ExpandableComposite.this.marginWidth + n7 + n7, n5 + ExpandableComposite.this.marginHeight + ExpandableComposite.this.marginHeight + n8 + n8);
            return point7;
        }

        @Override
        public int computeMinimumWidth(Composite composite, boolean bl) {
            return this.computeSize((Composite)composite, (int)0, (int)-1, (boolean)bl).x;
        }

        @Override
        public int computeMaximumWidth(Composite composite, boolean bl) {
            return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)bl).x;
        }
    }
}

