/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.internal.forms.widgets.ColumnLayoutUtils;

public final class ColumnLayout
extends Layout
implements ILayoutExtension {
    public int minNumColumns = 1;
    public int maxNumColumns = 3;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    public int topMargin = 5;
    public int leftMargin = 5;
    public int bottomMargin = 5;
    public int rightMargin = 5;

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        if (n == 0) {
            return this.computeSize(composite, n, n2, this.minNumColumns);
        }
        if (n == -1) {
            return this.computeSize(composite, n, n2, this.maxNumColumns);
        }
        return this.computeSize(composite, n, n2, -1);
    }

    private Point computeSize(Composite composite, int n, int n2, int n3) {
        int n4;
        Control[] controlArray = composite.getChildren();
        int n5 = 0;
        int n6 = 0;
        Point[] pointArray = new Point[controlArray.length];
        int n7 = -1;
        if (n3 != -1) {
            n7 = n - this.leftMargin - this.rightMargin - (n3 - 1) * this.horizontalSpacing;
            n7 = n7 <= 0 ? 0 : (n7 /= n3);
        }
        int n8 = 0;
        while (n8 < controlArray.length) {
            pointArray[n8] = this.computeControlSize(controlArray[n8], n7);
            n5 = Math.max(n5, pointArray[n8].x);
            n6 += pointArray[n8].y;
            ++n8;
        }
        if (n3 == -1) {
            n3 = (n - this.leftMargin - this.rightMargin - this.horizontalSpacing) / (n5 + this.horizontalSpacing);
            n3 = Math.min(n3, controlArray.length);
            n3 = Math.max(n3, this.minNumColumns);
            n3 = Math.min(n3, this.maxNumColumns);
        }
        n8 = ColumnLayoutUtils.computeColumnHeight(n3, pointArray, n6, this.verticalSpacing);
        int n9 = 0;
        int[] nArray = new int[n3];
        int n10 = 0;
        boolean bl = false;
        int n11 = 0;
        while (n11 < pointArray.length) {
            n4 = pointArray[n11].y;
            if (n11 > 0 && n9 + n4 > n8) {
                nArray[n10] = n9;
                if (++n10 == n3 || bl) {
                    bl = true;
                    n10 = this.findShortestColumn(nArray);
                }
                n9 = nArray[n10];
            }
            if (n9 > 0) {
                n9 += this.verticalSpacing;
            }
            n9 += n4;
            ++n11;
        }
        nArray[n10] = Math.max(nArray[n10], n9);
        Point point = new Point(0, 0);
        n4 = 0;
        while (n4 < n3) {
            point.y = Math.max(point.y, nArray[n4]);
            ++n4;
        }
        point.x = n5 * n3 + (n3 - 1) * this.horizontalSpacing;
        point.x += this.leftMargin + this.rightMargin;
        point.y += this.topMargin + this.bottomMargin;
        return point;
    }

    private Point computeControlSize(Control control, int n) {
        ColumnLayoutData columnLayoutData = (ColumnLayoutData)control.getLayoutData();
        int n2 = columnLayoutData != null ? columnLayoutData.widthHint : n;
        int n3 = columnLayoutData != null ? columnLayoutData.heightHint : -1;
        return control.computeSize(n2, n3);
    }

    private int findShortestColumn(int[] nArray) {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n2 > nArray[n3]) {
                n2 = nArray[n3];
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    protected void layout(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren();
        Rectangle rectangle = composite.getClientArea();
        int n = 0;
        int n2 = 0;
        Point[] pointArray = new Point[controlArray.length];
        int n3 = 0;
        while (n3 < controlArray.length) {
            pointArray[n3] = this.computeControlSize(controlArray[n3], -1);
            n = Math.max(n, pointArray[n3].x);
            n2 += pointArray[n3].y;
            ++n3;
        }
        n3 = (rectangle.width - this.leftMargin - this.rightMargin + this.horizontalSpacing) / (n + this.horizontalSpacing);
        n3 = Math.min(n3, controlArray.length);
        n3 = Math.max(n3, this.minNumColumns);
        n3 = Math.min(n3, this.maxNumColumns);
        int n4 = (rectangle.width - this.leftMargin - this.rightMargin + this.horizontalSpacing) / n3 - this.horizontalSpacing;
        int n5 = Math.max(n, n4);
        int n6 = ColumnLayoutUtils.computeColumnHeight(n3, pointArray, n2, this.verticalSpacing);
        int n7 = 0;
        int[] nArray = new int[n3];
        int n8 = 0;
        int n9 = this.leftMargin;
        boolean bl2 = false;
        int n10 = 0;
        while (n10 < pointArray.length) {
            int n11;
            Control control = controlArray[n10];
            Point point = pointArray[n10];
            ColumnLayoutData columnLayoutData = (ColumnLayoutData)control.getLayoutData();
            int n12 = columnLayoutData != null ? columnLayoutData.horizontalAlignment : 4;
            int n13 = n11 = n12 == 4 ? n5 : point.x;
            if (n10 > 0 && n7 + point.y > n6) {
                nArray[n8] = n7;
                if (bl2 || n8 == n3 - 1) {
                    bl2 = true;
                    n8 = this.findShortestColumn(nArray);
                    n9 = this.leftMargin + n8 * (n5 + this.horizontalSpacing);
                } else {
                    ++n8;
                    n9 += n5 + this.horizontalSpacing;
                }
                n7 = nArray[n8];
            }
            if (n7 > 0) {
                n7 += this.verticalSpacing;
            }
            switch (n12) {
                case 1: 
                case 4: {
                    control.setBounds(n9, this.topMargin + n7, n11, point.y);
                    break;
                }
                case 3: {
                    control.setBounds(n9 + n5 - n11, this.topMargin + n7, n11, point.y);
                    break;
                }
                case 2: {
                    control.setBounds(n9 + n5 / 2 - n11 / 2, this.topMargin + n7, n11, point.y);
                }
            }
            n7 += point.y;
            ++n10;
        }
    }

    @Override
    public int computeMaximumWidth(Composite composite, boolean bl) {
        return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)bl).x;
    }

    @Override
    public int computeMinimumWidth(Composite composite, boolean bl) {
        return this.computeSize((Composite)composite, (int)0, (int)-1, (boolean)bl).x;
    }
}

