/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.internal.forms.widgets.FormsResources;

public abstract class AbstractHyperlink
extends Canvas {
    private boolean hasFocus;
    boolean paintFocus = true;
    private boolean armed;
    private ListenerList listeners;
    protected int marginWidth = 1;
    protected int marginHeight = 1;

    public AbstractHyperlink(Composite composite, int n) {
        super(composite, n);
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\r') {
                    AbstractHyperlink.this.handleActivate(event);
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                AbstractHyperlink.this.paint(paintEvent);
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        event.doit = false;
                        return;
                    }
                }
                event.doit = true;
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 15: {
                        AbstractHyperlink.this.hasFocus = true;
                        AbstractHyperlink.this.handleEnter(event);
                        break;
                    }
                    case 16: {
                        AbstractHyperlink.this.hasFocus = false;
                        AbstractHyperlink.this.handleExit(event);
                        break;
                    }
                    case 14: {
                        AbstractHyperlink.this.handleActivate(event);
                        break;
                    }
                    case 6: {
                        AbstractHyperlink.this.handleEnter(event);
                        break;
                    }
                    case 7: {
                        AbstractHyperlink.this.handleExit(event);
                        break;
                    }
                    case 3: {
                        AbstractHyperlink.this.handleMouseDown(event);
                        break;
                    }
                    case 4: {
                        AbstractHyperlink.this.handleMouseUp(event);
                        break;
                    }
                    case 5: {
                        AbstractHyperlink.this.handleMouseMove(event);
                    }
                }
            }
        };
        this.addListener(6, listener);
        this.addListener(7, listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(5, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
        this.setCursor(FormsResources.getHandCursor());
    }

    public void addHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add((Object)iHyperlinkListener);
    }

    public void removeHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove((Object)iHyperlinkListener);
    }

    public boolean getSelection() {
        return this.hasFocus;
    }

    protected void handleEnter(Event event) {
        this.redraw();
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), event.stateMask);
        Object[] objectArray = this.listeners.getListeners();
        int n2 = 0;
        while (n2 < n) {
            IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)objectArray[n2];
            iHyperlinkListener.linkEntered(hyperlinkEvent);
            ++n2;
        }
    }

    protected void handleExit(Event event) {
        this.armed = false;
        this.redraw();
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), event.stateMask);
        Object[] objectArray = this.listeners.getListeners();
        int n2 = 0;
        while (n2 < n) {
            IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)objectArray[n2];
            iHyperlinkListener.linkExited(hyperlinkEvent);
            ++n2;
        }
    }

    protected void handleActivate(Event event) {
        this.armed = false;
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        this.setCursor(FormsResources.getBusyCursor());
        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), event.stateMask);
        Object[] objectArray = this.listeners.getListeners();
        int n2 = 0;
        while (n2 < n) {
            IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)objectArray[n2];
            iHyperlinkListener.linkActivated(hyperlinkEvent);
            ++n2;
        }
        if (!this.isDisposed()) {
            this.setCursor(FormsResources.getHandCursor());
            this.triggerAccessible();
        }
    }

    void triggerAccessible() {
        this.getAccessible().setFocus(-1);
    }

    public void setHref(Object object) {
        this.setData("href", object);
    }

    public Object getHref() {
        return this.getData("href");
    }

    public String getText() {
        return this.getToolTipText();
    }

    protected abstract void paintHyperlink(GC var1);

    protected void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        this.paintHyperlink(gC);
        if (this.paintFocus && this.hasFocus) {
            Rectangle rectangle2 = this.getClientArea();
            gC.setForeground(this.getForeground());
            gC.drawFocus(0, 0, rectangle2.width, rectangle2.height);
        }
    }

    private void handleMouseDown(Event event) {
        if (event.button != 1) {
            return;
        }
        this.armed = true;
    }

    private void handleMouseUp(Event event) {
        if (!this.armed || event.button != 1) {
            return;
        }
        Point point = this.getSize();
        if (event.x < 0) {
            return;
        }
        if (event.y < 0) {
            return;
        }
        if (event.x >= point.x) {
            return;
        }
        if (event.y >= point.y) {
            return;
        }
        this.handleActivate(event);
    }

    private void handleMouseMove(Event event) {
        if (this.armed) {
            Point point = this.getSize();
            this.armed = event.x >= 0 && event.y >= 0 && event.x < point.x && event.y < point.y;
        }
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = bl ^ this.getEnabled();
        super.setEnabled(bl);
        if (bl2) {
            this.redraw();
        }
    }
}

