/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.editor;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class SharedHeaderFormEditor
extends FormEditor {
    private HeaderForm headerForm;
    private boolean wasHeaderActive = true;
    private Listener activationListener = null;

    @Override
    protected Composite createPageContainer(Composite composite) {
        composite = super.createPageContainer(composite);
        composite.setLayout((Layout)new FillLayout());
        ScrolledForm scrolledForm = this.getToolkit().createScrolledForm(composite);
        scrolledForm.getForm().setData("__ignore_body__", Boolean.TRUE);
        this.headerForm = new HeaderForm(this, scrolledForm);
        this.createHeaderContents(this.headerForm);
        return this.headerForm.getForm().getBody();
    }

    public IManagedForm getHeaderForm() {
        return this.headerForm;
    }

    @Override
    protected void createPages() {
        super.createPages();
        if (this.getActivePage() == -1) {
            super.setActivePage(0);
        }
    }

    @Override
    protected void setActivePage(int n) {
        this.wasHeaderActive = false;
        super.setActivePage(n);
    }

    public void setFocus() {
        this.installActivationListener();
        if (this.wasHeaderActive) {
            ((ManagedForm)this.getHeaderForm()).setFocus();
        } else {
            int n = this.getActivePage();
            if (n == -1) {
                ((ManagedForm)this.getHeaderForm()).setFocus();
            } else {
                super.setFocus();
            }
        }
    }

    private void installActivationListener() {
        if (this.activationListener == null) {
            this.activationListener = new Listener(){

                public void handleEvent(Event event) {
                    boolean bl = event.widget != SharedHeaderFormEditor.this.getContainer();
                    int n = SharedHeaderFormEditor.this.getActivePage();
                    if (SharedHeaderFormEditor.this.wasHeaderActive != bl && n != -1 && SharedHeaderFormEditor.this.pages.get(n) instanceof IEditorPart) {
                        if (bl) {
                            SharedHeaderFormEditor.this.deactivateSite(true, true);
                        } else {
                            SharedHeaderFormEditor.this.activateSite();
                        }
                    }
                    SharedHeaderFormEditor.this.wasHeaderActive = bl;
                }
            };
            this.getContainer().addListener(26, this.activationListener);
            this.getHeaderForm().getForm().getForm().getHead().addListener(26, this.activationListener);
        }
    }

    @Override
    public void dispose() {
        if (this.headerForm != null) {
            this.headerForm.dispose();
            this.headerForm = null;
        }
        super.dispose();
    }

    @Override
    public boolean isDirty() {
        if (this.headerForm != null && this.headerForm.isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    @Override
    protected void commitPages(boolean bl) {
        if (this.headerForm != null && this.headerForm.isDirty()) {
            this.headerForm.commit(bl);
        }
        super.commitPages(bl);
    }

    protected void createHeaderContents(IManagedForm iManagedForm) {
    }

    private static class HeaderForm
    extends ManagedForm {
        public HeaderForm(FormEditor formEditor, ScrolledForm scrolledForm) {
            super(formEditor.getToolkit(), scrolledForm);
            this.setContainer((Object)formEditor);
            if (formEditor.getEditorInput() != null) {
                this.setInput(formEditor.getEditorInput());
            }
        }

        private FormEditor getEditor() {
            return (FormEditor)((Object)this.getContainer());
        }

        @Override
        public void dirtyStateChanged() {
            this.getEditor().editorDirtyStateChanged();
        }

        @Override
        public void staleStateChanged() {
            this.refresh();
        }
    }
}

