/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.EditorPart;

public class FormPage
extends EditorPart
implements IFormPage {
    private FormEditor editor;
    private PageForm mform;
    private int index;
    private String id;

    public FormPage(FormEditor formEditor, String string, String string2) {
        this(string, string2);
        this.initialize(formEditor);
    }

    public FormPage(String string, String string2) {
        this.id = string;
        this.setPartName(string2);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
    }

    @Override
    public void initialize(FormEditor formEditor) {
        this.editor = formEditor;
    }

    @Override
    public FormEditor getEditor() {
        return this.editor;
    }

    @Override
    public IManagedForm getManagedForm() {
        return this.mform;
    }

    @Override
    public void setActive(boolean bl) {
        if (bl && this.mform != null) {
            this.mform.refresh();
        }
    }

    @Override
    public boolean isActive() {
        return this.equals(this.editor.getActivePageInstance());
    }

    public void createPartControl(Composite composite) {
        ScrolledForm scrolledForm = this.editor.getToolkit().createScrolledForm(composite);
        this.mform = new PageForm(this, scrolledForm);
        BusyIndicator.showWhile((Display)composite.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                FormPage.this.createFormContent(FormPage.this.mform);
            }
        });
    }

    protected void createFormContent(IManagedForm iManagedForm) {
    }

    @Override
    public Control getPartControl() {
        return this.mform != null ? this.mform.getForm() : null;
    }

    public void dispose() {
        if (this.mform != null) {
            this.mform.dispose();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Image getTitleImage() {
        return null;
    }

    public void setFocus() {
        if (this.mform != null) {
            this.mform.setFocus();
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.mform != null) {
            this.mform.commit(true);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.mform != null ? this.mform.isDirty() : false;
    }

    @Override
    public void setIndex(int n) {
        this.index = n;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isEditor() {
        return false;
    }

    @Override
    public boolean selectReveal(Object object) {
        if (this.mform != null) {
            return this.mform.setInput(object);
        }
        return false;
    }

    @Override
    public boolean canLeaveThePage() {
        return true;
    }

    private static class PageForm
    extends ManagedForm {
        public PageForm(FormPage formPage, ScrolledForm scrolledForm) {
            super(formPage.getEditor().getToolkit(), scrolledForm);
            this.setContainer(formPage);
        }

        public FormPage getPage() {
            return (FormPage)this.getContainer();
        }

        @Override
        public void dirtyStateChanged() {
            this.getPage().getEditor().editorDirtyStateChanged();
        }

        @Override
        public void staleStateChanged() {
            if (this.getPage().isActive()) {
                this.refresh();
            }
        }
    }
}

