/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.editor;

import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;

public abstract class FormEditor
extends MultiPageEditorPart {
    protected Vector pages = new Vector();
    private FormToolkit toolkit;
    private int currentPage = -1;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        iEditorSite.setSelectionProvider((ISelectionProvider)new FormEditorSelectionProvider(this));
    }

    protected void createPages() {
        this.addPages();
    }

    protected Composite createPageContainer(Composite composite) {
        composite = super.createPageContainer(composite);
        this.toolkit = this.createToolkit(composite.getDisplay());
        return composite;
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(display);
    }

    protected abstract void addPages();

    public Object getSelectedPage() {
        return this.getActivePageInstance();
    }

    public int addPage(IFormPage iFormPage) throws PartInitException {
        int n = super.addPage(iFormPage.getPartControl());
        this.configurePage(n, iFormPage);
        return n;
    }

    public void addPage(int n, IFormPage iFormPage) throws PartInitException {
        super.addPage(n, iFormPage.getPartControl());
        this.configurePage(n, iFormPage);
        this.updatePageIndices(n + 1);
    }

    public int addPage(Control control) {
        int n = super.addPage(control);
        try {
            this.registerPage(-1, control);
        }
        catch (PartInitException partInitException) {}
        return n;
    }

    public void addPage(int n, Control control) {
        super.addPage(n, control);
        try {
            this.registerPage(n, control);
        }
        catch (PartInitException partInitException) {}
        this.updatePageIndices(n + 1);
    }

    public boolean isDirty() {
        if (this.pages != null) {
            int n = 0;
            while (n < this.pages.size()) {
                IFormPage iFormPage;
                Object e = this.pages.get(n);
                if (e instanceof IFormPage ? (iFormPage = (IFormPage)e).isDirty() : e instanceof IEditorPart && (iFormPage = (IEditorPart)e).isDirty()) {
                    return true;
                }
                ++n;
            }
        }
        return super.isDirty();
    }

    protected void commitPages(boolean bl) {
        if (this.pages != null) {
            int n = 0;
            while (n < this.pages.size()) {
                IFormPage iFormPage;
                IManagedForm iManagedForm;
                Object e = this.pages.get(n);
                if (e instanceof IFormPage && (iManagedForm = (iFormPage = (IFormPage)e).getManagedForm()) != null && iManagedForm.isDirty()) {
                    iManagedForm.commit(bl);
                }
                ++n;
            }
        }
    }

    public int addPage(IEditorPart iEditorPart, IEditorInput iEditorInput) throws PartInitException {
        int n = super.addPage(iEditorPart, iEditorInput);
        if (iEditorPart instanceof IFormPage) {
            this.configurePage(n, (IFormPage)iEditorPart);
        } else {
            this.registerPage(-1, iEditorPart);
        }
        return n;
    }

    public void addPage(int n, IEditorPart iEditorPart, IEditorInput iEditorInput) throws PartInitException {
        super.addPage(n, iEditorPart, iEditorInput);
        if (iEditorPart instanceof IFormPage) {
            this.configurePage(n, (IFormPage)iEditorPart);
        } else {
            this.registerPage(n, iEditorPart);
        }
        this.updatePageIndices(n + 1);
    }

    protected void configurePage(int n, IFormPage iFormPage) throws PartInitException {
        this.setPageText(n, iFormPage.getTitle());
        iFormPage.setIndex(n);
        this.registerPage(n, iFormPage);
    }

    public void removePage(int n) {
        if (n >= 0 && n < this.pages.size()) {
            IFormPage iFormPage;
            Object e = this.pages.get(n);
            this.pages.remove(e);
            if (e instanceof IFormPage && !(iFormPage = (IFormPage)e).isEditor()) {
                iFormPage.dispose();
            }
            this.updatePageIndices(n);
        }
        super.removePage(n);
    }

    private void updatePageIndices(int n) {
        int n2 = n;
        while (n2 < this.pages.size()) {
            Object e = this.pages.get(n2);
            if (e instanceof IFormPage) {
                IFormPage iFormPage = (IFormPage)e;
                iFormPage.setIndex(n2);
            }
            ++n2;
        }
    }

    public void editorDirtyStateChanged() {
        this.firePropertyChange(257);
    }

    public void dispose() {
        super.dispose();
        int n = 0;
        while (n < this.pages.size()) {
            IFormPage iFormPage;
            Object e = this.pages.get(n);
            if (e instanceof IFormPage && !(iFormPage = (IFormPage)e).isEditor()) {
                iFormPage.dispose();
            }
            ++n;
        }
        this.pages = null;
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    protected int getCurrentPage() {
        return this.currentPage;
    }

    protected void pageChange(int n) {
        IManagedForm iManagedForm;
        IFormPage iFormPage;
        Object object;
        int n2 = this.getCurrentPage();
        if (n2 != -1 && this.pages.size() > n2 && this.pages.get(n2) instanceof IFormPage && n2 != n && !(object = (IFormPage)this.pages.get(n2)).canLeaveThePage()) {
            this.setActivePage(n2);
            return;
        }
        object = this.pages.get(n);
        if (object instanceof IFormPage && (iFormPage = (IFormPage)object).getPartControl() == null) {
            iFormPage.createPartControl(this.getContainer());
            this.setControl(n, iFormPage.getPartControl());
            iFormPage.getPartControl().setMenu(this.getContainer().getMenu());
        }
        if (n2 != -1 && this.pages.size() > n2 && this.pages.get(n2) instanceof IFormPage && (iManagedForm = (iFormPage = (IFormPage)this.pages.get(n2)).getManagedForm()) != null) {
            iManagedForm.commit(false);
        }
        if (this.pages.size() > n && this.pages.get(n) instanceof IFormPage) {
            ((IFormPage)this.pages.get(n)).setActive(true);
        }
        if (n2 != -1 && this.pages.size() > n2 && n != n2 && this.pages.get(n2) instanceof IFormPage) {
            ((IFormPage)this.pages.get(n2)).setActive(false);
        }
        super.pageChange(n);
        this.currentPage = n;
    }

    public IFormPage setActivePage(String string) {
        int n = 0;
        while (n < this.pages.size()) {
            IFormPage iFormPage;
            Object e = this.pages.get(n);
            if (e instanceof IFormPage && (iFormPage = (IFormPage)e).getId().equals(string)) {
                this.setActivePage(n);
                return iFormPage;
            }
            ++n;
        }
        return null;
    }

    public IFormPage findPage(String string) {
        int n = 0;
        while (n < this.pages.size()) {
            IFormPage iFormPage;
            Object e = this.pages.get(n);
            if (e instanceof IFormPage && (iFormPage = (IFormPage)this.pages.get(n)).getId().equals(string)) {
                return iFormPage;
            }
            ++n;
        }
        return null;
    }

    public IFormPage setActivePage(String string, Object object) {
        IManagedForm iManagedForm;
        IFormPage iFormPage = this.setActivePage(string);
        if (iFormPage != null && (iManagedForm = iFormPage.getManagedForm()) != null) {
            iManagedForm.setInput(object);
        }
        return iFormPage;
    }

    public IFormPage selectReveal(Object object) {
        int n = 0;
        while (n < this.pages.size()) {
            IFormPage iFormPage;
            Object e = this.pages.get(n);
            if (e instanceof IFormPage && (iFormPage = (IFormPage)e).selectReveal(object)) {
                return iFormPage;
            }
            ++n;
        }
        return null;
    }

    public IFormPage getActivePageInstance() {
        Object e;
        int n = this.getActivePage();
        if (n != -1 && (e = this.pages.get(n)) instanceof IFormPage) {
            return (IFormPage)e;
        }
        return null;
    }

    protected void setActivePage(int n) {
        if (this.pages.size() > n && this.pages.get(n) instanceof IFormPage) {
            super.setActivePage(n);
            IFormPage iFormPage = (IFormPage)this.pages.get(n);
            iFormPage.setActive(true);
        } else {
            super.setActivePage(n);
        }
        this.updateActionBarContributor(n);
    }

    protected void updateActionBarContributor(int n) {
        IEditorActionBarContributor iEditorActionBarContributor = this.getEditorSite().getActionBarContributor();
        if (iEditorActionBarContributor != null && iEditorActionBarContributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)iEditorActionBarContributor).setActivePage(this.getEditor(n));
        }
    }

    public void close(final boolean bl) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (FormEditor.this.toolkit != null) {
                    FormEditor.this.getSite().getPage().closeEditor((IEditorPart)FormEditor.this, bl);
                }
            }
        });
    }

    private void registerPage(int n, Object object) throws PartInitException {
        IFormPage iFormPage;
        if (!this.pages.contains(object)) {
            if (n == -1) {
                this.pages.add(object);
            } else {
                this.pages.add(n, object);
            }
        }
        if (object instanceof IFormPage && !(iFormPage = (IFormPage)object).isEditor()) {
            iFormPage.init(this.getEditorSite(), this.getEditorInput());
        }
    }

    private static class FormEditorSelectionProvider
    extends MultiPageSelectionProvider {
        private ISelection globalSelection;

        public FormEditorSelectionProvider(FormEditor formEditor) {
            super((MultiPageEditorPart)formEditor);
        }

        public ISelection getSelection() {
            ISelectionProvider iSelectionProvider;
            IEditorPart iEditorPart = ((FormEditor)this.getMultiPageEditor()).getActiveEditor();
            if (iEditorPart != null && (iSelectionProvider = iEditorPart.getSite().getSelectionProvider()) != null) {
                return iSelectionProvider.getSelection();
            }
            if (this.globalSelection != null) {
                return this.globalSelection;
            }
            return StructuredSelection.EMPTY;
        }

        public void setSelection(ISelection iSelection) {
            IEditorPart iEditorPart = ((FormEditor)this.getMultiPageEditor()).getActiveEditor();
            if (iEditorPart != null) {
                ISelectionProvider iSelectionProvider = iEditorPart.getSite().getSelectionProvider();
                if (iSelectionProvider != null) {
                    iSelectionProvider.setSelection(iSelection);
                }
            } else {
                this.globalSelection = iSelection;
                this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.globalSelection));
            }
        }
    }
}

