/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class MasterDetailsBlock {
    protected DetailsPart detailsPart;
    protected SashForm sashForm;
    static final int DRAGGER_SIZE = 40;

    public void createContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        this.createContent(iManagedForm, scrolledForm.getBody());
    }

    public void createContent(IManagedForm iManagedForm, Composite composite) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.applyLayout(composite);
        this.sashForm = new MDSashForm(composite, 0);
        this.sashForm.setData("form", (Object)iManagedForm);
        formToolkit.adapt((Control)this.sashForm, false, false);
        this.sashForm.setMenu(composite.getMenu());
        this.applyLayoutData(this.sashForm);
        this.createMasterPart(iManagedForm, (Composite)this.sashForm);
        this.createDetailsPart(iManagedForm, (Composite)this.sashForm);
        this.hookResizeListener();
        this.createToolBarActions(iManagedForm);
        scrolledForm.updateToolBar();
    }

    protected void applyLayoutData(SashForm sashForm) {
        sashForm.setLayoutData((Object)new GridData(1808));
    }

    protected void applyLayout(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
    }

    private void hookResizeListener() {
        Listener listener = ((MDSashForm)this.sashForm).listener;
        Control[] controlArray = this.sashForm.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (!(controlArray[n] instanceof Sash)) {
                controlArray[n].addListener(11, listener);
            }
            ++n;
        }
    }

    protected abstract void createMasterPart(IManagedForm var1, Composite var2);

    protected abstract void registerPages(DetailsPart var1);

    protected abstract void createToolBarActions(IManagedForm var1);

    private void createDetailsPart(IManagedForm iManagedForm, Composite composite) {
        this.detailsPart = new DetailsPart(iManagedForm, composite, 0);
        iManagedForm.addPart(this.detailsPart);
        this.registerPages(this.detailsPart);
    }

    private void onSashPaint(Event event) {
        Sash sash = (Sash)event.widget;
        IManagedForm iManagedForm = (IManagedForm)sash.getParent().getData("form");
        FormColors formColors = iManagedForm.getToolkit().getColors();
        boolean bl = (sash.getStyle() & 0x200) != 0;
        GC gC = event.gc;
        Boolean bl2 = (Boolean)sash.getData("hover");
        gC.setBackground(formColors.getColor("org.eclipse.ui.forms.TB_BG"));
        gC.setForeground(formColors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        Point point = sash.getSize();
        if (bl) {
            if (bl2 != null) {
                gC.fillRectangle(0, 0, point.x, point.y);
            }
        } else if (bl2 != null) {
            gC.fillRectangle(0, 0, point.x, point.y);
        }
    }

    class MDSashForm
    extends SashForm {
        ArrayList sashes;
        Listener listener;

        public MDSashForm(Composite composite, int n) {
            super(composite, n);
            this.sashes = new ArrayList();
            this.listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 6: {
                            event.widget.setData("hover", (Object)Boolean.TRUE);
                            ((Control)event.widget).redraw();
                            break;
                        }
                        case 7: {
                            event.widget.setData("hover", null);
                            ((Control)event.widget).redraw();
                            break;
                        }
                        case 9: {
                            MasterDetailsBlock.this.onSashPaint(event);
                            break;
                        }
                        case 11: {
                            MDSashForm.this.hookSashListeners();
                        }
                    }
                }
            };
        }

        public void layout(boolean bl) {
            super.layout(bl);
            this.hookSashListeners();
        }

        public void layout(Control[] controlArray) {
            super.layout(controlArray);
            this.hookSashListeners();
        }

        private void hookSashListeners() {
            this.purgeSashes();
            Control[] controlArray = this.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Sash sash;
                if (controlArray[n] instanceof Sash && !this.sashes.contains(sash = (Sash)controlArray[n])) {
                    sash.addListener(9, this.listener);
                    sash.addListener(6, this.listener);
                    sash.addListener(7, this.listener);
                    this.sashes.add(sash);
                }
                ++n;
            }
        }

        private void purgeSashes() {
            Iterator iterator = this.sashes.iterator();
            while (iterator.hasNext()) {
                Sash sash = (Sash)iterator.next();
                if (!sash.isDisposed()) continue;
                iterator.remove();
            }
        }
    }
}

