/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ManagedForm
implements IManagedForm {
    private Object input;
    private ScrolledForm form;
    private FormToolkit toolkit;
    private Object container;
    private boolean ownsToolkit;
    private boolean initialized;
    private Vector parts = new Vector();

    public ManagedForm(Composite composite) {
        this.toolkit = new FormToolkit(composite.getDisplay());
        this.ownsToolkit = true;
        this.form = this.toolkit.createScrolledForm(composite);
    }

    public ManagedForm(FormToolkit formToolkit, ScrolledForm scrolledForm) {
        this.form = scrolledForm;
        this.toolkit = formToolkit;
    }

    @Override
    public void addPart(IFormPart iFormPart) {
        this.parts.add(iFormPart);
        iFormPart.initialize(this);
    }

    @Override
    public void removePart(IFormPart iFormPart) {
        this.parts.remove(iFormPart);
    }

    @Override
    public IFormPart[] getParts() {
        return this.parts.toArray(new IFormPart[this.parts.size()]);
    }

    @Override
    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    @Override
    public ScrolledForm getForm() {
        return this.form;
    }

    @Override
    public void reflow(boolean bl) {
        this.form.reflow(bl);
    }

    @Override
    public void fireSelectionChanged(IFormPart iFormPart, ISelection iSelection) {
        int n = 0;
        while (n < this.parts.size()) {
            IFormPart iFormPart2 = (IFormPart)this.parts.get(n);
            if (!iFormPart.equals(iFormPart2) && iFormPart2 instanceof IPartSelectionListener) {
                ((IPartSelectionListener)((Object)iFormPart2)).selectionChanged(iFormPart, iSelection);
            }
            ++n;
        }
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            return;
        }
        int n = 0;
        while (n < this.parts.size()) {
            IFormPart iFormPart = (IFormPart)this.parts.get(n);
            iFormPart.initialize(this);
            ++n;
        }
        this.initialized = true;
    }

    public void dispose() {
        int n = 0;
        while (n < this.parts.size()) {
            IFormPart iFormPart = (IFormPart)this.parts.get(n);
            iFormPart.dispose();
            ++n;
        }
        if (this.ownsToolkit) {
            this.toolkit.dispose();
        }
    }

    @Override
    public void refresh() {
        Thread thread;
        Thread thread2 = Thread.currentThread();
        if (thread2.equals(thread = this.toolkit.getColors().getDisplay().getThread())) {
            this.doRefresh();
        } else {
            this.toolkit.getColors().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ManagedForm.this.doRefresh();
                }
            });
        }
    }

    private void doRefresh() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.parts.size()) {
            IFormPart iFormPart = (IFormPart)this.parts.get(n2);
            if (iFormPart.isStale()) {
                iFormPart.refresh();
                ++n;
            }
            ++n2;
        }
        if (n > 0) {
            this.form.reflow(true);
        }
    }

    @Override
    public void commit(boolean bl) {
        int n = 0;
        while (n < this.parts.size()) {
            IFormPart iFormPart = (IFormPart)this.parts.get(n);
            if (iFormPart.isDirty()) {
                iFormPart.commit(bl);
            }
            ++n;
        }
    }

    @Override
    public boolean setInput(Object object) {
        boolean bl = false;
        this.input = object;
        int n = 0;
        while (n < this.parts.size()) {
            IFormPart iFormPart = (IFormPart)this.parts.get(n);
            boolean bl2 = iFormPart.setFormInput(object);
            if (bl2) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    @Override
    public Object getInput() {
        return this.input;
    }

    public void setFocus() {
        if (this.parts.size() > 0) {
            IFormPart iFormPart = (IFormPart)this.parts.get(0);
            iFormPart.setFocus();
        }
    }

    @Override
    public boolean isDirty() {
        int n = 0;
        while (n < this.parts.size()) {
            IFormPart iFormPart = (IFormPart)this.parts.get(n);
            if (iFormPart.isDirty()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean isStale() {
        int n = 0;
        while (n < this.parts.size()) {
            IFormPart iFormPart = (IFormPart)this.parts.get(n);
            if (iFormPart.isStale()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void dirtyStateChanged() {
    }

    @Override
    public void staleStateChanged() {
    }

    @Override
    public Object getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Object object) {
        this.container = object;
    }

    @Override
    public IMessageManager getMessageManager() {
        return this.form.getMessageManager();
    }
}

