/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.FormsResources;

public class HyperlinkSettings {
    public static final int UNDERLINE_NEVER = 1;
    public static final int UNDERLINE_HOVER = 2;
    public static final int UNDERLINE_ALWAYS = 3;
    private int hyperlinkUnderlineMode = 3;
    private Color background;
    private Color foreground;
    private Color activeBackground;
    private Color activeForeground;

    public HyperlinkSettings(Display display) {
        this.initializeDefaultForegrounds(display);
    }

    public void initializeDefaultForegrounds(Display display) {
        Color color = JFaceColors.getHyperlinkText((Display)display);
        Color color2 = JFaceColors.getActiveHyperlinkText((Display)display);
        if (color == null) {
            color = display.getSystemColor(9);
        }
        this.setForeground(color);
        this.setActiveForeground(color2);
    }

    public Color getActiveBackground() {
        return this.activeBackground;
    }

    public Color getActiveForeground() {
        return this.activeForeground;
    }

    public Color getBackground() {
        return this.background;
    }

    public Cursor getBusyCursor() {
        return FormsResources.getBusyCursor();
    }

    public Cursor getTextCursor() {
        return FormsResources.getTextCursor();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Cursor getHyperlinkCursor() {
        return FormsResources.getHandCursor();
    }

    public int getHyperlinkUnderlineMode() {
        return this.hyperlinkUnderlineMode;
    }

    public void setActiveBackground(Color color) {
        this.activeBackground = color;
    }

    public void setActiveForeground(Color color) {
        this.activeForeground = color;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setHyperlinkUnderlineMode(int n) {
        this.hyperlinkUnderlineMode = n;
    }
}

