/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public final class HyperlinkGroup
extends HyperlinkSettings {
    private ArrayList links = new ArrayList();
    private Hyperlink lastActivated;
    private Hyperlink lastEntered;
    private GroupListener listener = new GroupListener();
    private boolean isActiveBackgroundSet;
    private boolean isActiveForegroundSet;
    private boolean isBackgroundSet;
    private boolean isForegroundSet;

    public HyperlinkGroup(Display display) {
        super(display);
    }

    public Hyperlink getLastActivated() {
        return this.lastActivated;
    }

    public void add(Hyperlink hyperlink) {
        if (this.isBackgroundSet) {
            hyperlink.setBackground(this.getBackground());
        }
        if (this.isForegroundSet) {
            hyperlink.setForeground(this.getForeground());
        }
        if (this.getHyperlinkUnderlineMode() == 3) {
            hyperlink.setUnderlined(true);
        }
        this.hook(hyperlink);
    }

    @Override
    public void setActiveBackground(Color color) {
        super.setActiveBackground(color);
        this.isActiveBackgroundSet = true;
    }

    @Override
    public void setActiveForeground(Color color) {
        super.setActiveForeground(color);
        this.isActiveForegroundSet = true;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.isBackgroundSet = true;
        if (this.links != null) {
            int n = 0;
            while (n < this.links.size()) {
                Hyperlink hyperlink = (Hyperlink)((Object)this.links.get(n));
                hyperlink.setBackground(color);
                ++n;
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.isForegroundSet = true;
        if (this.links != null) {
            int n = 0;
            while (n < this.links.size()) {
                Hyperlink hyperlink = (Hyperlink)((Object)this.links.get(n));
                hyperlink.setForeground(color);
                ++n;
            }
        }
    }

    @Override
    public void setHyperlinkUnderlineMode(int n) {
        super.setHyperlinkUnderlineMode(n);
        if (this.links != null) {
            int n2 = 0;
            while (n2 < this.links.size()) {
                Hyperlink hyperlink = (Hyperlink)((Object)this.links.get(n2));
                hyperlink.setUnderlined(n == 3);
                ++n2;
            }
        }
    }

    private void hook(Hyperlink hyperlink) {
        hyperlink.addListener(3, this.listener);
        hyperlink.addHyperlinkListener(this.listener);
        hyperlink.addListener(12, this.listener);
        hyperlink.addListener(6, this.listener);
        hyperlink.addListener(7, this.listener);
        this.links.add(hyperlink);
    }

    private void unhook(Hyperlink hyperlink) {
        hyperlink.removeListener(3, this.listener);
        hyperlink.removeHyperlinkListener(this.listener);
        hyperlink.removeListener(6, this.listener);
        hyperlink.removeListener(7, this.listener);
        if (this.lastActivated == hyperlink) {
            this.lastActivated = null;
        }
        if (this.lastEntered == hyperlink) {
            this.lastEntered = null;
        }
        this.links.remove((Object)hyperlink);
    }

    private void onMouseDown(Event event) {
        if (event.button == 1) {
            return;
        }
        this.lastActivated = (Hyperlink)event.widget;
    }

    private class GroupListener
    implements Listener,
    IHyperlinkListener {
        private Color previousBackground;
        private Color previousForeground;

        private GroupListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 6: {
                    this.onMouseEnter(event);
                    break;
                }
                case 7: {
                    this.onMouseExit(event);
                    break;
                }
                case 3: {
                    HyperlinkGroup.this.onMouseDown(event);
                    break;
                }
                case 12: {
                    HyperlinkGroup.this.unhook((Hyperlink)event.widget);
                }
            }
        }

        private void onMouseEnter(Event event) {
            Hyperlink hyperlink = (Hyperlink)event.widget;
            this.previousBackground = hyperlink.getBackground();
            this.previousForeground = hyperlink.getForeground();
            if (HyperlinkGroup.this.isActiveBackgroundSet) {
                hyperlink.setBackground(HyperlinkGroup.this.getActiveBackground());
            }
            if (HyperlinkGroup.this.isActiveForegroundSet) {
                hyperlink.setForeground(HyperlinkGroup.this.getActiveForeground());
            }
            if (HyperlinkGroup.this.getHyperlinkUnderlineMode() == 2) {
                hyperlink.setUnderlined(true);
            }
            hyperlink.setCursor(HyperlinkGroup.this.getHyperlinkCursor());
        }

        private void onMouseExit(Event event) {
            Hyperlink hyperlink = (Hyperlink)event.widget;
            if (HyperlinkGroup.this.isActiveBackgroundSet) {
                hyperlink.setBackground(this.previousBackground);
            }
            if (HyperlinkGroup.this.isActiveForegroundSet) {
                hyperlink.setForeground(this.previousForeground);
            }
            if (HyperlinkGroup.this.getHyperlinkUnderlineMode() == 2) {
                hyperlink.setUnderlined(false);
            }
        }

        @Override
        public void linkActivated(HyperlinkEvent hyperlinkEvent) {
        }

        @Override
        public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            Hyperlink hyperlink = (Hyperlink)hyperlinkEvent.widget;
            if (HyperlinkGroup.this.lastEntered != null) {
                this.linkExited(HyperlinkGroup.this.lastEntered);
            }
            HyperlinkGroup.this.lastEntered = hyperlink;
        }

        @Override
        public void linkExited(HyperlinkEvent hyperlinkEvent) {
            this.linkExited((Hyperlink)hyperlinkEvent.widget);
        }

        private void linkExited(Hyperlink hyperlink) {
            hyperlink.setCursor(null);
            if (HyperlinkGroup.this.lastEntered == hyperlink) {
                HyperlinkGroup.this.lastEntered = null;
            }
        }
    }
}

