/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class FormColors {
    public static final String TITLE = "org.eclipse.ui.forms.TITLE";
    public static final String BORDER = "org.eclipse.ui.forms.BORDER";
    public static final String SEPARATOR = "org.eclipse.ui.forms.SEPARATOR";
    public static final String TB_BG = "org.eclipse.ui.forms.TB_BG";
    public static final String TB_FG = "org.eclipse.ui.forms.TB_FG";
    public static final String TB_GBG = "org.eclipse.ui.forms.TB_BG";
    public static final String TB_BORDER = "org.eclipse.ui.forms.TB_BORDER";
    public static final String TB_TOGGLE = "org.eclipse.ui.forms.TB_TOGGLE";
    public static final String TB_TOGGLE_HOVER = "org.eclipse.ui.forms.TB_TOGGLE_HOVER";
    protected Map colorRegistry = new HashMap(10);
    private LocalResourceManager resources;
    protected Color background;
    protected Color foreground;
    private boolean shared;
    protected Display display;
    protected Color border;

    public FormColors(Display display) {
        this.display = display;
        this.initialize();
    }

    public Display getDisplay() {
        return this.display;
    }

    protected void initialize() {
        this.background = this.display.getSystemColor(25);
        this.foreground = this.display.getSystemColor(24);
        this.initializeColorTable();
        this.updateBorderColor();
    }

    protected void initializeColorTable() {
        this.createTitleColor();
        this.createColor(SEPARATOR, this.getColor(TITLE).getRGB());
        RGB rGB = this.getSystemColor(2);
        RGB rGB2 = this.getSystemColor(35);
        this.createColor(BORDER, FormColors.blend(rGB2, rGB, 80));
    }

    public void initializeSectionToolBarColors() {
        if (this.colorRegistry.containsKey("org.eclipse.ui.forms.TB_BG")) {
            return;
        }
        this.createTitleBarGradientColors();
        this.createTitleBarOutlineColors();
        this.createTwistieColors();
    }

    protected void initializeFormHeaderColors() {
        if (this.colorRegistry.containsKey("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2")) {
            return;
        }
        this.createFormHeaderColors();
    }

    public RGB getSystemColor(int n) {
        return this.getDisplay().getSystemColor(n).getRGB();
    }

    public Color createColor(String string, RGB rGB) {
        Color color = this.getResourceManager().createColor(rGB);
        Color color2 = (Color)this.colorRegistry.get(string);
        if (color2 != null && !color2.isDisposed()) {
            this.getResourceManager().destroyColor(color2.getRGB());
        }
        this.colorRegistry.put(string, color);
        return color;
    }

    public Color getInactiveBackground() {
        String string = "__ncbg__";
        Color color = this.getColor(string);
        if (color == null) {
            RGB rGB = this.getSystemColor(26);
            RGB rGB2 = FormColors.blend(rGB, this.getSystemColor(1), 5);
            color = this.createColor(string, rGB2);
        }
        return color;
    }

    public Color createColor(String string, int n, int n2, int n3) {
        return this.createColor(string, new RGB(n, n2, n3));
    }

    protected void updateBorderColor() {
        if (this.isWhiteBackground()) {
            this.border = this.getColor(BORDER);
        } else {
            this.border = this.display.getSystemColor(22);
            Color color = this.getImpliedBackground();
            if (this.border.getRed() == color.getRed() && this.border.getGreen() == color.getGreen() && this.border.getBlue() == color.getBlue()) {
                this.border = this.display.getSystemColor(17);
            }
        }
    }

    public void setBackground(Color color) {
        this.background = color;
        this.updateBorderColor();
        this.updateFormHeaderColors();
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBorderColor() {
        return this.border;
    }

    public boolean isWhiteBackground() {
        Color color = this.getImpliedBackground();
        return color.getRed() == 255 && color.getGreen() == 255 && color.getBlue() == 255;
    }

    public Color getColor(String string) {
        if (string.startsWith("org.eclipse.ui.forms.TB_")) {
            this.initializeSectionToolBarColors();
        } else if (string.startsWith("org.eclipse.ui.forms.H_")) {
            this.initializeFormHeaderColors();
        }
        return (Color)this.colorRegistry.get(string);
    }

    public void dispose() {
        if (this.resources != null) {
            this.resources.dispose();
        }
        this.resources = null;
        this.colorRegistry = null;
    }

    public void markShared() {
        this.shared = true;
    }

    public boolean isShared() {
        return this.shared;
    }

    public static RGB blend(RGB rGB, RGB rGB2, int n) {
        int n2 = FormColors.blend(rGB.red, rGB2.red, n);
        int n3 = FormColors.blend(rGB.green, rGB2.green, n);
        int n4 = FormColors.blend(rGB.blue, rGB2.blue, n);
        return new RGB(n2, n3, n4);
    }

    public static boolean testAnyPrimaryColor(RGB rGB, int n, int n2) {
        if (FormColors.testPrimaryColor(rGB.red, n, n2)) {
            return true;
        }
        if (FormColors.testPrimaryColor(rGB.green, n, n2)) {
            return true;
        }
        return FormColors.testPrimaryColor(rGB.blue, n, n2);
    }

    public static boolean testTwoPrimaryColors(RGB rGB, int n, int n2) {
        int n3 = 0;
        if (FormColors.testPrimaryColor(rGB.red, n, n2)) {
            ++n3;
        }
        if (FormColors.testPrimaryColor(rGB.green, n, n2)) {
            ++n3;
        }
        if (FormColors.testPrimaryColor(rGB.blue, n, n2)) {
            ++n3;
        }
        return n3 >= 2;
    }

    private static int blend(int n, int n2, int n3) {
        int n4 = (n3 * n + (100 - n3) * n2) / 100;
        return Math.min(255, n4);
    }

    private Color getImpliedBackground() {
        if (this.getBackground() != null) {
            return this.getBackground();
        }
        return this.getDisplay().getSystemColor(22);
    }

    private static boolean testPrimaryColor(int n, int n2, int n3) {
        return n > n2 && n < n3;
    }

    private void createTitleColor() {
        RGB rGB = this.getImpliedBackground().getRGB();
        RGB rGB2 = this.getSystemColor(26);
        RGB rGB3 = this.getSystemColor(24);
        RGB rGB4 = rGB2;
        if (FormColors.testTwoPrimaryColors(rGB2, -1, 121)) {
            rGB4 = rGB2;
        } else if (FormColors.testTwoPrimaryColors(rGB2, 120, 256) || rGB.red == 0 && rGB.green == 0 && rGB.blue == 0) {
            rGB4 = FormColors.blend(rGB2, rGB3, 50);
        }
        this.createColor(TITLE, rGB4);
    }

    private void createTwistieColors() {
        RGB rGB = this.getColor(TITLE).getRGB();
        RGB rGB2 = this.getSystemColor(1);
        this.createColor(TB_TOGGLE, rGB);
        rGB = FormColors.blend(rGB, rGB2, 60);
        this.createColor(TB_TOGGLE_HOVER, rGB);
    }

    private void createTitleBarGradientColors() {
        RGB rGB = this.getSystemColor(31);
        RGB rGB2 = this.getImpliedBackground().getRGB();
        rGB = FormColors.testTwoPrimaryColors(rGB, 179, 256) ? FormColors.blend(rGB, rGB2, 30) : (FormColors.testTwoPrimaryColors(rGB, 120, 180) ? FormColors.blend(rGB, rGB2, 20) : FormColors.blend(rGB, rGB2, 10));
        this.createColor("org.eclipse.ui.forms.TB_BG", rGB);
        this.createColor("org.eclipse.ui.forms.TB_BG", rGB);
    }

    private void createTitleBarOutlineColors() {
        RGB rGB = this.getSystemColor(31);
        RGB rGB2 = this.getImpliedBackground().getRGB();
        rGB = FormColors.testTwoPrimaryColors(rGB, 179, 256) ? FormColors.blend(rGB, rGB2, 70) : (FormColors.testTwoPrimaryColors(rGB, 120, 180) ? FormColors.blend(rGB, rGB2, 50) : FormColors.blend(rGB, rGB2, 30));
        this.createColor(TB_BORDER, rGB);
    }

    private void updateFormHeaderColors() {
        if (this.colorRegistry.containsKey("org.eclipse.ui.forms.H_GRADIENT_END")) {
            this.disposeIfFound("org.eclipse.ui.forms.H_GRADIENT_END");
            this.disposeIfFound("org.eclipse.ui.forms.H_GRADIENT_START");
            this.disposeIfFound("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1");
            this.disposeIfFound("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2");
            this.disposeIfFound("org.eclipse.ui.forms.H_H_HOVER_LIGHT");
            this.disposeIfFound("org.eclipse.ui.forms.H_H_HOVER_FULL");
            this.initializeFormHeaderColors();
        }
    }

    private void disposeIfFound(String string) {
        Color color = this.getColor(string);
        if (color != null) {
            this.colorRegistry.remove(string);
            color.dispose();
        }
    }

    private void createFormHeaderColors() {
        this.createFormHeaderGradientColors();
        this.createFormHeaderKeylineColors();
        this.createFormHeaderDNDColors();
    }

    private void createFormHeaderGradientColors() {
        RGB rGB;
        RGB rGB2;
        RGB rGB3 = this.getSystemColor(31);
        Color color = this.getImpliedBackground();
        RGB rGB4 = color.getRGB();
        if (FormColors.testTwoPrimaryColors(rGB3, 179, 256)) {
            rGB2 = FormColors.blend(rGB3, rGB4, 30);
            rGB = rGB4;
        } else if (FormColors.testTwoPrimaryColors(rGB3, 120, 180)) {
            rGB2 = FormColors.blend(rGB3, rGB4, 20);
            rGB = rGB4;
        } else {
            rGB2 = FormColors.blend(rGB3, rGB4, 10);
            rGB = rGB4;
        }
        this.createColor("org.eclipse.ui.forms.H_GRADIENT_END", rGB);
        this.createColor("org.eclipse.ui.forms.H_GRADIENT_START", rGB2);
    }

    private void createFormHeaderKeylineColors() {
        RGB rGB = this.getSystemColor(31);
        Color color = this.getImpliedBackground();
        RGB rGB2 = color.getRGB();
        this.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", new RGB(255, 255, 255));
        RGB rGB3 = FormColors.testTwoPrimaryColors(rGB, 179, 256) ? FormColors.blend(rGB, rGB2, 70) : (FormColors.testTwoPrimaryColors(rGB, 120, 180) ? FormColors.blend(rGB, rGB2, 50) : FormColors.blend(rGB, rGB2, 30));
        this.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", rGB3);
    }

    private void createFormHeaderDNDColors() {
        RGB rGB = this.getSystemColor(32);
        Color color = this.getImpliedBackground();
        RGB rGB2 = color.getRGB();
        RGB rGB3 = FormColors.blend(rGB, rGB2, 40);
        RGB rGB4 = FormColors.blend(rGB, rGB2, 60);
        this.createColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT", rGB3);
        this.createColor("org.eclipse.ui.forms.H_H_HOVER_FULL", rGB4);
    }

    private LocalResourceManager getResourceManager() {
        if (this.resources == null) {
            this.resources = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resources;
    }
}

